/***************************************************************************
 *   Copyright (C) 2005 by Will Entriken                                   *
 *   william.entriken@villanova.edu                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef PROCESSLISTVIEWITEM_H
#define PROCESSLISTVIEWITEM_H

#include <tqlistview.h>
#include <tqstring.h>
#include <tqobject.h>

class ProcessController;

class ProcessListViewItem : public TQObject, public TQListViewItem
{
	TQ_OBJECT
  
public:
  
	ProcessListViewItem( TQListView * parent );
	ProcessListViewItem( TQListViewItem * parent );
	ProcessListViewItem( TQListView * parent, TQListViewItem * after );
	ProcessListViewItem( TQListViewItem * parent, TQListViewItem * after );
	
	ProcessListViewItem( TQListView * parent,
			TQString,     TQString = TQString(),
			TQString = TQString(), TQString = TQString(),
			TQString = TQString(), TQString = TQString(),
			TQString = TQString(), TQString = TQString() );
	ProcessListViewItem( TQListViewItem * parent,
			TQString,     TQString = TQString(),
			TQString = TQString(), TQString = TQString(),
			TQString = TQString(), TQString = TQString(),
			TQString = TQString(), TQString = TQString() );
	
	ProcessListViewItem( TQListView * parent, TQListViewItem * after,
			TQString,     TQString = TQString(),
			TQString = TQString(), TQString = TQString(),
			TQString = TQString(), TQString = TQString(),
			TQString = TQString(), TQString = TQString() );
	ProcessListViewItem( TQListViewItem * parent, TQListViewItem * after,
			TQString,     TQString = TQString(),
			TQString = TQString(), TQString = TQString(),
			TQString = TQString(), TQString = TQString(),
			TQString = TQString(), TQString = TQString() );

	~ProcessListViewItem();
	
	ProcessController * getProcessController();
	
private:
	ProcessController * myProcessController;
};

#endif
