/*
 *  (C) Baryshev Dmitry, KSquirrel project.
 *  Originally based on kstartuplogo.h from KDevelop project
 */

/***************************************************************************
                          kstartuplogo.h  -  description
                             -------------------
    artwork              : KDevelop Project / Ralf Nolden <nolden@kde.org>
    begin                : Mon Oct 1 2001
    copyright            : (C) 2001 by Kai Heitkamp
    email                : koncd@kai-heitkamp.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301   *
 *   USA.                                                                  *
 *                                                                         *
 *   For license exceptions see LICENSE.EXC file, attached with the source *
 *   code.                                                                 *
 *                                                                         *
 ***************************************************************************/

#ifndef KSTARTUPLOGO_H
#define KSTARTUPLOGO_H

#include <tqwidget.h>

class SQ_Progress;

class SQ_SplashScreen : public TQWidget
{
    public:
        SQ_SplashScreen(TQWidget *parent = 0, const char *name = 0);
        ~SQ_SplashScreen();

        static void advance();
        static void finish();

        SQ_Progress *progress();

        static SQ_SplashScreen* instance() { return m_inst; }

    protected:
        virtual void mousePressEvent(TQMouseEvent *);

    private:
        SQ_Progress *pr;

        static SQ_SplashScreen *m_inst;
};

inline
SQ_Progress* SQ_SplashScreen::progress()
{
    return pr;
}

#endif
