/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** TQt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

/*
 *  SQ_Options is a configuration dialog for KSquirrel.
 */

// for KIPI defs
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef SQ_HAVE_KIPI
#include <libkipi/pluginloader.h>
#endif

void SQ_Options::init()
{
    buttonOk->setIconSet(SQ_IconLoader::instance()->loadIcon("ok", TDEIcon::Desktop, TDEIcon::SizeSmall));
    int tp;
    SQ_Config *tdeconf = SQ_Config::instance();
    TQColor color;

    pagesNumber->setRange(1, 1000, 1, true);

    tdeconf->setGroup("Main");

    checkKIPIDemand->setChecked(tdeconf->readBoolEntry("kipi_ondemand", true));
    tp = tdeconf->readNumEntry("applyto", SQ_CodecSettings::Both);
    buttonGroupCS->setButton(tp);
    checkMinimize->setChecked(tdeconf->readBoolEntry("minimize to tray", false));
    checkSync->setChecked(tdeconf->readBoolEntry("sync", false));
    checkSplash->setChecked(tdeconf->readBoolEntry("splash", true));
    checkAnime->setChecked(tdeconf->readBoolEntry("anime_dont", false));
    checkTreat->setChecked(tdeconf->readBoolEntry("treat", true));

    KFile::Mode mode = static_cast<KFile::Mode>(KFile::Directory | KFile::ExistingOnly | KFile::LocalOnly);

    tdeconf->setGroup("Fileview");

    tp = tdeconf->readNumEntry("sync type", 0);
    buttonGroupSync->setButton(tp);
    tp = tdeconf->readNumEntry("set path", 0);
    buttonGroupSetPath->setButton(tp);
    kURLReqOpenCustom->setURL(tdeconf->readEntry("custom directory", "/"));

    spinLines->setRange(1, 20, 1, true);
    spinLines->setValue(tdeconf->readNumEntry("tooltips_lines", 6));
    checkTooltipPreview->setChecked(tdeconf->readBoolEntry("tooltips_preview", false));
    checkTooltips->setChecked(tdeconf->readBoolEntry("tooltips", false));
    checkInactive->setChecked(tdeconf->readBoolEntry("tooltips_inactive", true));
    checkSaveHistory->setChecked(tdeconf->readBoolEntry("history", true));
    checkRunUnknown->setChecked(tdeconf->readBoolEntry("run unknown", false));
    checkSupportAr->setChecked(tdeconf->readBoolEntry("archives", true));
    checkJumpFirst->setChecked(tdeconf->readBoolEntry("tofirst", true));
    checkDisableDirs->setChecked(tdeconf->readBoolEntry("disable_dirs", false));
    checkCalc->setChecked(tdeconf->readBoolEntry("calculate", true));
    checkDrag->setChecked(tdeconf->readBoolEntry("drag", true));

// Init GLView page
    tdeconf->setGroup("GL view");

    TQPixmap p1;
    checkProgress->setChecked(tdeconf->readBoolEntry("progressiv", true));
    checkDrawQuads->setChecked(tdeconf->readBoolEntry("alpha_bkgr", true));
    checkMarks->setChecked(tdeconf->readBoolEntry("marks", true));    

    // tabs
    checkTabs->setChecked(tdeconf->readBoolEntry("tabs", false));    
    checkTabAsk->setChecked(tdeconf->readBoolEntry("tabs_ask", false));    
    checkTabClose->setChecked(tdeconf->readBoolEntry("tabs_close", true));    
    checkCloseAll->setChecked(tdeconf->readBoolEntry("closeall", false));    

    tp = tdeconf->readNumEntry("double_click", 0);
    buttonGroupDC->setButton(tp);
    tp = tdeconf->readNumEntry("load_pages", 0);
    buttonGroupPages->setButton(tp);
    pagesNumber->setEnabled(tp == 2);
    tp = tdeconf->readNumEntry("load_pages_number", 1);
    pagesNumber->setValue(tp);

    tp = tdeconf->readNumEntry("GL view background type", 1);
    buttonGroupColor->setButton(tp);
    widgetStack4->raiseWidget(tp);

    kColorSystem->setColor(colorGroup().color(TQColorGroup::Base));

    tp = tdeconf->readNumEntry("zoom limit", 1);
    buttonGroupZoomLimit->setButton(tp);
    spinZoomMin->setValue(tdeconf->readNumEntry("zoom_min", 1));
    spinZoomMax->setValue(tdeconf->readNumEntry("zoom_max", 10000));

    custpixmap = tdeconf->readEntry("GL view custom texture", "");
    kURLReqCustomTexture->setURL(custpixmap);

    if(!custpixmap.isEmpty())
        slotValidateCustomTexture();

    tp = tdeconf->readNumEntry("scroll", 0);
    buttonGroupScrolling->setButton(tp);
    sliderAngle->setRange(0, 180, 1, true);
    sliderAngle->setValue(tdeconf->readNumEntry("angle", 90));
    spinZoomFactor->setRange(0, 300, 1, true);
    spinZoomFactor->setValue(tdeconf->readNumEntry("zoom", 25));
    sliderMove->setRange(1, 50, 1, true);
    sliderMove->setValue(tdeconf->readNumEntry("move", 5));

    color.setNamedColor(tdeconf->readEntry("GL view background", "#4e4e4e"));
    kColorGLbackground->setColor(color);

    tdeconf->setGroup("Sidebar");

    tp = tdeconf->readNumEntry("recursion_type", 0);
    buttonGroupRecurs->setButton(tp);
    checkDevice->setChecked(tdeconf->readBoolEntry("mount_device", false));
    checkMountOptions->setChecked(tdeconf->readBoolEntry("mount_options", false));
    checkMountFS->setChecked(tdeconf->readBoolEntry("mount_fstype", true));
    color.setNamedColor(tdeconf->readEntry("preview_background", "#4e4e4e"));
    previewColor->setColor(color);
    color.setNamedColor(tdeconf->readEntry("preview_text", "#ffffff"));
    previewTextColor->setColor(color);
    preview->setChecked(tdeconf->readBoolEntry("preview", true));
    checkPreviewText->setChecked(tdeconf->readBoolEntry("preview_text_enable", true));
    previewDont->setChecked(tdeconf->readBoolEntry("preview_dont", true));
    previewDelay->setRange(50, 2000, 50, true);
    previewDelay->setValue(tdeconf->readNumEntry("preview_delay", 400));

    tdeconf->setGroup("Thumbnails");

    spinCacheSize->setRange(0, 104857, 10, true);
    spinMargin->setRange(0, 20, 1, true);
    spinMargin->setValue(tdeconf->readNumEntry("margin", 2));
    spinCacheSize->setValue(tdeconf->readNumEntry("cache", 1024*5));
    checkNoWriteThumbs->setChecked(tdeconf->readBoolEntry("dont write", false));
    checkMark->setChecked(tdeconf->readBoolEntry("mark", false));
    checkLazy->setChecked(tdeconf->readBoolEntry("lazy", true));
    spinLazy->setRange(10, 5000, 100, true);
    spinLazy->setValue(tdeconf->readNumEntry("lazy_delay", 500));
    spinRows->setRange(0, 5, 1, true);
    spinRows->setValue(tdeconf->readNumEntry("rows", 2));

    new SQ_IconListItem(listMain, SQ_IconLoader::instance()->loadIcon("display", TDEIcon::Desktop, TDEIcon::SizeMedium), i18n("General"));    
    new SQ_IconListItem(listMain, SQ_IconLoader::instance()->loadIcon("folder", TDEIcon::Desktop, TDEIcon::SizeMedium), i18n("Filing"));
    new SQ_IconListItem(listMain, SQ_IconLoader::instance()->loadIcon("images", TDEIcon::Desktop, TDEIcon::SizeMedium), i18n("Thumbnails"));
    new SQ_IconListItem(listMain, TQPixmap::fromMimeSource(locate("data", "images/listbox/image_win.png")), i18n("Image window"));
    new SQ_IconListItem(listMain, SQ_IconLoader::instance()->loadIcon("penguin", TDEIcon::Desktop, TDEIcon::SizeMedium), i18n("Sidebar"));

#ifdef SQ_HAVE_KIPI
    new SQ_IconListItem(listMain, SQ_IconLoader::instance()->loadIcon("kipi", TDEIcon::Desktop, TDEIcon::SizeMedium), i18n("KIPI"));

	TQWidget *pg6 = widgetStack->widget(5);
	TQGridLayout *pageLayout6 = new TQGridLayout(pg6, 2, 1, 0, -1, "pageLayout_6");
	kipi = new KIPI::ConfigWidget(pg6);
	pageLayout6->addWidget(textLabelKIPI, 0, 0);
	pageLayout6->addWidget(kipi, 1, 0);
	checkKIPIDemand->setEnabled(true);
#endif

    listMain->updateAndInstall(TQT_TQOBJECT(this));

    connect(listMain, TQT_SIGNAL(selectionChanged()), TQT_SLOT(slotShowPage()));

    kURLReqOpenCustom->setMode(mode);

    // restore selection page
    tdeconf->setGroup("Main");
    listMain->setCurrentItem(tdeconf->readNumEntry("options_last", 0));    
    tabNav->setCurrentPage(tdeconf->readNumEntry("options_last_tabNav", 0));
    tabGL->setCurrentPage(tdeconf->readNumEntry("options_last_tabGL", 0));
    tabSidebar->setCurrentPage(tdeconf->readNumEntry("options_last_tabSidebar", 0));

    if(!SQ_HLOptions::instance()->have_mountview)
        tabSidebar->setTabEnabled(tabSidebar->page(1), false);
}

int SQ_Options::start()
{
    int result = TQDialog::exec();

    if(result == TQDialog::Accepted)
    {
#ifdef SQ_HAVE_KIPI
	static_cast<KIPI::ConfigWidget *>(kipi)->apply();
#endif

        SQ_Config *tdeconf = SQ_Config::instance();

        tdeconf->setGroup("Fileview");
        tdeconf->writeEntry("set path", buttonGroupSetPath->selectedId());
        tdeconf->writeEntry("custom directory", kURLReqOpenCustom->url());
        tdeconf->writeEntry("sync type", buttonGroupSync->selectedId());
        tdeconf->writeEntry("history", checkSaveHistory->isChecked());
        tdeconf->writeEntry("run unknown", checkRunUnknown->isChecked());
        tdeconf->writeEntry("archives", checkSupportAr->isChecked());
        tdeconf->writeEntry("tofirst", checkJumpFirst->isChecked());
        tdeconf->writeEntry("disable_dirs", checkDisableDirs->isChecked());
        tdeconf->writeEntry("calculate", checkCalc->isChecked());
        tdeconf->writeEntry("drag", checkDrag->isChecked());
        tdeconf->writeEntry("tooltips", checkTooltips->isChecked());
        tdeconf->writeEntry("tooltips_inactive", checkInactive->isChecked());
        tdeconf->writeEntry("tooltips_lines", spinLines->value());
        tdeconf->writeEntry("tooltips_preview", checkTooltipPreview->isChecked());

        tdeconf->setGroup("Main");
        tdeconf->writeEntry("applyto", buttonGroupCS->selectedId());
        tdeconf->writeEntry("minimize to tray", checkMinimize->isChecked());
        tdeconf->writeEntry("sync", checkSync->isChecked());
        tdeconf->writeEntry("splash", checkSplash->isChecked());
        tdeconf->writeEntry("anime_dont", checkAnime->isChecked());
        tdeconf->writeEntry("kipi_ondemand", checkKIPIDemand->isChecked());
        tdeconf->writeEntry("treat", checkTreat->isChecked());
        tdeconf->writeEntry("options_last", listMain->currentItem());
        tdeconf->writeEntry("options_last_tabGL", tabGL->currentPageIndex());
        tdeconf->writeEntry("options_last_tabNav", tabNav->currentPageIndex());
        tdeconf->writeEntry("options_last_tabSidebar", tabSidebar->currentPageIndex());

        tdeconf->setGroup("Thumbnails");
        tdeconf->writeEntry("margin", spinMargin->value());
        tdeconf->writeEntry("cache", spinCacheSize->value());
        tdeconf->writeEntry("dont write", checkNoWriteThumbs->isChecked());
        tdeconf->writeEntry("mark", checkMark->isChecked());
        tdeconf->writeEntry("lazy", checkLazy->isChecked());
        tdeconf->writeEntry("lazy_delay", spinLazy->value());
        tdeconf->writeEntry("rows", spinRows->value());

        tdeconf->setGroup("GL view");
        tdeconf->writeEntry("double_click", buttonGroupDC->selectedId());
        tdeconf->writeEntry("load_pages", buttonGroupPages->selectedId());
        tdeconf->writeEntry("load_pages_number", pagesNumber->value());
        tdeconf->writeEntry("GL view background", kColorGLbackground->color().name());
        tdeconf->writeEntry("GL view custom texture", custpixmap);
        tdeconf->writeEntry("GL view background type", buttonGroupColor->selectedId());
        tdeconf->writeEntry("zoom limit", buttonGroupZoomLimit->selectedId());
        tdeconf->writeEntry("alpha_bkgr", checkDrawQuads->isChecked());
        tdeconf->writeEntry("marks", checkMarks->isChecked());
        tdeconf->writeEntry("progressiv", checkProgress->isChecked());
        tdeconf->writeEntry("scroll", buttonGroupScrolling->selectedId());
        tdeconf->writeEntry("angle", sliderAngle->value());
        tdeconf->writeEntry("zoom", spinZoomFactor->value());
        tdeconf->writeEntry("zoom_min", spinZoomMin->value());
        tdeconf->writeEntry("zoom_max", spinZoomMax->value());
        tdeconf->writeEntry("move", sliderMove->value());
        tdeconf->writeEntry("tabs", checkTabs->isChecked());
        tdeconf->writeEntry("tabs_ask", checkTabAsk->isChecked());
        tdeconf->writeEntry("tabs_close", checkTabClose->isChecked());
        tdeconf->writeEntry("closeall", checkCloseAll->isChecked());    

        tdeconf->setGroup("Sidebar");
        tdeconf->writeEntry("recursion_type", buttonGroupRecurs->selectedId());
        tdeconf->writeEntry("mount_device", checkDevice->isChecked());
        tdeconf->writeEntry("mount_options", checkMountOptions->isChecked());
        tdeconf->writeEntry("mount_fstype", checkMountFS->isChecked());
        tdeconf->writeEntry("preview_background", previewColor->color().name());
        tdeconf->writeEntry("preview_text", previewTextColor->color().name());
        tdeconf->writeEntry("preview_text_enable", checkPreviewText->isChecked());
        tdeconf->writeEntry("preview_delay", previewDelay->value());
        tdeconf->writeEntry("preview_dont", previewDont->isChecked());
        tdeconf->writeEntry("preview", preview->isChecked());
    }

    return result;
}

bool SQ_Options::validPixmap(TQPixmap pix)
{
    return (isPowerOf2(pix.width()) && isPowerOf2(pix.height()) && pix.width() <= 256 && pix.width() == pix.height() && !pix.isNull());
}

bool SQ_Options::isPowerOf2( int tested )
{
    int i = 1;
    
    if(tested == 1)
        return true;
    
    for(;tested > i;i <<= 1)
    ;

    return i == tested;
}

void SQ_Options::slotNewCustomTexture( const TQString & path)
{
    TQPixmap p1(path);
    
    if(validPixmap(p1))
    {
        custpixmap = path;
        textCustomValidate->setText(TQString::fromLatin1("%1x%2: OK")
            .arg(p1.width())
            .arg(p1.height()));
    }
    else
        textCustomValidate->setText(i18n("Wrong dimensions: %1x%2.")
            .arg(p1.width())
            .arg(p1.height()));
}

void SQ_Options::slotShowPage()
{
    int id = listMain->currentItem();

    widgetStack->raiseWidget(id);
}

void SQ_Options::slotCustomTextureToggled( bool en)
{
    kURLReqCustomTexture->setEnabled(en);
    groupBox3->setEnabled(en);
}

void SQ_Options::slotValidateCustomTexture()
{
    slotNewCustomTexture(kURLReqCustomTexture->url());
}

void SQ_Options::paletteChange( const TQPalette &oldPalette )
{
    TQDialog::paletteChange(oldPalette);

    kColorSystem->setColor(colorGroup().color(TQColorGroup::Base));
}

void SQ_Options::slotSetSystemBack( const TQColor & )
{
    kColorSystem->setColor(colorGroup().color(TQColorGroup::Base));
}
