/***************************************************************************
                          lmsensorsdock.cpp  -  description
                             -------------------
    begin                : Sun Sep 23 2001
    copyright            : (C) 2001 by Miguel Novas
    email                : michaell@teleline.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "lmsensorsdock.h"

#include <tqobjectlist.h>
#include <tdelocale.h>
#include <kiconloader.h>
#include <kapp.h>
#include <tdeaboutapplication.h>

#include <twin.h>
#include <netwm.h>

LMSensorsDock::LMSensorsDock(bool fNoDock, TQObject *parent, const char *name): TQObject(parent,name)
{
 noDock= fNoDock;
 
 sensors= new LMSensors;
 sensors->setMonitorized(true);

 connect(sensors,TQ_SIGNAL(configChanged(const char *)),this,TQ_SLOT(updateItemDock(const char *)));

 createAlarmControl();
 createWidgets();
 if(!noDock) createDockWidgets();
 createMenu();
}


LMSensorsDock::~LMSensorsDock()
{
  saveConfig();
  if(sensorsWidget)
    delete sensorsWidget;
  if(sensorsCfg)
    delete sensorsCfg;
  if(sensorsAlarm)
    delete sensorsAlarm;
  
  if (helpmenu)
  {
    menu->removeItem(helpmenu_id);
    delete helpmenu;
  }
  delete menu;
  if(sensors) delete sensors;
}


void LMSensorsDock::createMenu()
{
  helpmenu=new TDEPopupMenu;
  helpmenu->insertItem(SmallIcon("help"), i18n("&KSensors Handbook"), this, TQ_SLOT(showHandbook()));
  helpmenu->insertItem(kapp->miniIcon(), i18n("&About KSensors"), this, TQ_SLOT(showAbout()));

  menu= new TDEPopupMenu;
  menu->insertTitle(kapp->miniIcon(),"KSensors");
  menu->insertItem(SmallIcon("configure"),i18n("&Configure"), this, TQ_SLOT(createConfigWidget() ) ,0,101 );
  menu->insertSeparator();
  helpmenu_id=menu->insertItem(SmallIcon("help"), i18n("&Help"), helpmenu);
  menu->insertSeparator();
  if(!noDock) menu->insertItem(sensorsWidget ? i18n("&Minimize"):i18n("&Restore"), this, TQ_SLOT(minimizeRestoreWidget() ) ,0,100 );
  menu->insertItem(SmallIcon("system-log-out"),i18n("&Exit"), this, TQ_SLOT(close()),0,102);
}

void LMSensorsDock::createWidgets()
{
 TDEGlobal::config()->setGroup("General");
 if(noDock) createShowWidget();
 else if(TDEGlobal::config()->readBoolEntry("showWidget",false)) {
    int desktop = TDEGlobal::config()->readNumEntry("desktop", 0);
    createShowWidget(desktop);
 }
}

void LMSensorsDock::saveConfig()
{
 TDEGlobal::config()->setGroup("General");
 TDEGlobal::config()->writeEntry("showWidget",(bool)sensorsWidget);
 if(sensorsWidget) {
   NETWinInfo wm_client(tqt_xdisplay(), sensorsWidget->winId(), tqt_xrootwin(), NET::WMDesktop);
   TDEGlobal::config()->writeEntry("desktop", wm_client.desktop());
 }   
}

void LMSensorsDock::createDockWidgets()
{
TQObjectList *chips= sensors->getSensorsChips();

 countSensors= 0;
 if(chips)
    for(LMSensorsChip *chip= (LMSensorsChip *)chips->first(); chip!=0; chip= (LMSensorsChip *)chips->next()) {
        TQObjectList *list= (TQObjectList *)chip->getSensors();
        if(list) {
           for(LMSensor *sensor= (LMSensor *)list->first(); sensor!=0; sensor= (LMSensor *)list->next()) {
             if( LMSensorDockPanel::readShowInDock(sensor->name()) )
               createDockSensor(sensor);
          }
        }
    }
 if(countSensors==0) createDockSensor(0);
}

void LMSensorsDock::createAlarmControl()
{
 sensorsAlarm= new LMSensorsAlarms(sensors);
}


void LMSensorsDock::minimizeRestoreWidget()
{
 if(sensorsWidget)  delete sensorsWidget;
 else               createShowWidget();
 updateMenu();
}

void LMSensorsDock::updateMenu()
{
 if(noDock && !sensorsWidget)
   close();
 else
   menu->changeItem(100, sensorsWidget ? i18n("&Minimize") : i18n("&Restore"));
}

void LMSensorsDock::createShowWidget(int desktop)
{
 if(!sensorsWidget)  {
   sensorsWidget= new LMSensorsWidget(sensors);
   connect( sensorsWidget, TQ_SIGNAL(rightMouseClicked(TQMouseEvent *)), this, TQ_SLOT(mouseEventReceived(TQMouseEvent *)) );
   connect( sensorsWidget, TQ_SIGNAL(destroyed()), this, TQ_SLOT(updateMenu()) );
 }
 if ((desktop != 0) && (desktop <= KWin::numberOfDesktops())) KWin::setOnDesktop(sensorsWidget->winId(), desktop);
 sensorsWidget->show();
}


void LMSensorsDock::createConfigWidget()
{
 if(!sensorsCfg) {
   sensorsCfg= new KSensorsCfg(sensors);
 }
 sensorsCfg->show();
}


void LMSensorsDock::close()
{
 delete this;
}

void LMSensorsDock::mouseEventReceived(TQMouseEvent *e)
{
 if(e->type()==TQEvent::MouseButtonRelease) {
   if( e->button()==LeftButton  ) minimizeRestoreWidget();
   if( e->button()==RightButton ) menu->popup(e->globalPos());
 }
}

void LMSensorsDock::createDockSensor(Sensor *sensor)
{
  if(countSensors==0) {
    TQObjectList *list= (TQObjectList *)children();
    if(list)
      for(LMSensorDockPanel *sensor= (LMSensorDockPanel *)list->first(); sensor!=0; sensor= (LMSensorDockPanel *)list->next())
       delete sensor;
  }
  const char *name= sensor ?  sensor->name() : 0;
  LMSensorDockPanel *dock= new LMSensorDockPanel(sensor,name);
  connect( dock, TQ_SIGNAL(mouseEvent(TQMouseEvent *)), this, TQ_SLOT(mouseEventReceived(TQMouseEvent *)) );
  insertChild(dock);
  dock->show();
  if(name) countSensors++;
}

void LMSensorsDock::deleteDockSensor(LMSensorDockPanel *sensor)
{
 delete sensor;
 if(--countSensors==0) createDockSensor(0);
}

void LMSensorsDock::updateItemDock(const char *name)
{
 if(!name) return;

 Sensor *sensor= sensors->getSensor(name);

// if((bool)sensor && sensor->getType()==LMSensor::lmTemp) {
   bool   fShow= LMSensorDockPanel::readShowInDock(name);
   LMSensorDockPanel *dockSensor= (LMSensorDockPanel *)child(name);
   if( fShow!=(bool)dockSensor ) {
     if(dockSensor) deleteDockSensor(dockSensor);
     else           createDockSensor(sensor);
   } else {
     if(dockSensor!=0)
       dockSensor->updateConfig();
   }
// }
}

void LMSensorsDock::showAbout()
{
TDEAboutApplication *dialog;

  dialog= new TDEAboutApplication;
  dialog->exec();
  delete dialog;
}

void LMSensorsDock::showHandbook()
{
  kapp->invokeHelp();
}

#include "lmsensorsdock.moc"
