/***************************************************************************
*   Copyright (C) 2003 by                                                 *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*   Cyril Bosselut (bosselut@b1project.com)                               *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KREMENU_H
#define KREMENU_H

#include <ntqbuttongroup.h>
#include <ntqevent.h>
#include <ntqiconset.h>
#include <ntqmap.h>
#include <ntqpushbutton.h>
#include <ntqstring.h>

#include "krecipesview.h" //for KrePanel enum


/**
* @author Unai Garro
* @author Bosselut Cyril
*/

class Menu;
class KreMenu;
class KreMenuButton;
typedef TQValueList <Menu>::Iterator MenuId;


class Menu
{
public:
	// Methods

	Menu( void );
	Menu( const Menu &m );
	~Menu( void );
	void addButton( KreMenuButton *button );
	Menu& operator=( const Menu &m );

	// Variables

	TQMap <KreMenuButton*, int> positionList; // Stores the indexes for the widgets
	TQMap <int, KreMenuButton*> widgetList; // Stores the widgets for each position (just the inverse mapping)
	KreMenuButton* activeButton; // Indicates which button is highlighted
	int childPos;
	int widgetNumber;
private:
	// Methods
	void copyMap( TQMap <int, KreMenuButton*> &destMap, const TQMap <int, KreMenuButton*> &origMap );
	void copyMap( TQMap <KreMenuButton*, int> &destMap, const TQMap <KreMenuButton*, int> &origMap );
};


class KreMenu : public TQWidget
{
	TQ_OBJECT
public:
	KreMenu( TQWidget *parent = 0, const char *name = 0 );
	~KreMenu();

	MenuId createSubMenu( const TQString &title, const TQString &icon );
	MenuId mainMenu( void )
	{
		return mainMenuId;
	}
	MenuId currentMenu( void )
	{
		return currentMenuId;
	}
	TQSize sizeHint() const;
	TQSize minimumSizeHint() const;
	void resizeEvent( TQResizeEvent* e );
	void highlightButton( KreMenuButton *button );


protected:

	virtual void paintEvent ( TQPaintEvent *e );
	virtual void childEvent ( TQChildEvent *e );
	virtual void keyPressEvent( TQKeyEvent *e );

private:
	//Variables
	TQValueList <Menu> menus;
	MenuId mainMenuId;
	MenuId currentMenuId;
	Menu *m_currentMenu;

signals:
	void resized( int, int );
	void clicked( KrePanel );

private slots:
	void collectClicks( KreMenuButton *w );
	void showMenu( MenuId id );

};

class KreMenuButton: public TQWidget
{
	TQ_OBJECT
public:
	KreMenuButton( KreMenu *parent, KrePanel panel = KrePanel( -1 ), MenuId id = 0, const char *name = 0 );

	~KreMenuButton();

	TQSize sizeHint() const;
	TQSize minimumSizeHint() const;

	TQString title( void )
	{
		return text;
	}
	void setActive( bool active = true )
	{
		highlighted = active;
	}
	void setIconSet( const TQIconSet &is );
	MenuId menuId;
	MenuId subMenuId;

	KrePanel getPanel() const
	{
		return panel;
	}

signals:
	void resized( int, int );
	void clicked( void );
	void clicked( KreMenuButton* ); // sent together with clicked()
	void clicked( MenuId ); // sent together with clicked()

public slots:
	void setTitle( const TQString &s );
	void rescale( void );

private:
	// Button parts
	TQPixmap* icon;
	TQString text;
	bool highlighted;

	KrePanel panel;

private slots:

	void forwardClicks( void )
	{
		emit clicked( this );
		if ( subMenuId != 0 )
			emit clicked( subMenuId );
	}

protected:

	virtual void paintEvent( TQPaintEvent *e );
	virtual void mousePressEvent ( TQMouseEvent * e );

};



#endif
