/* This file is part of the KDE project
   Copyright (C) 2004 Cedric Pasteur <cedric.pasteur@free.fr>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include <tdemainwindow.h>
#include <tdelocale.h>
#include <kdebug.h>
#include <tdecmdlineargs.h>
#include <kiconloader.h>

#include <tqpixmap.h>
#include <tqstringlist.h>
#include <tqdatetimeedit.h>
#include <tqcursor.h>
#include <tqapplication.h>

#include <koproperty/property.h>
#include <koproperty/editor.h>

#include "test.h"

using namespace KoProperty;

Test::Test()
 : TDEMainWindow(0,"koproperty_test")
{
	TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();
	const bool flat = args->isSet("flat");
	const bool readOnly = args->isSet("ro");

//	setXMLFile("testui.rc");
	TQFont f;
	f.setPixelSize(f.pixelSize()*2/3);
	setFont(f);

/*  First, create the Set which will hold the properties.  */
	Property *p = 0;
	m_set = new Set(TQT_TQOBJECT(this), "test");
	m_set->setReadOnly(readOnly);
	TQCString group;
	if (!flat) {
		group = "SimpleGroup";
		m_set->setGroupDescription(group, "Simple Group");
	}
	m_set->addProperty(new Property("Name", "Name"), group);
	(*m_set)["Name"].setAutoSync(1);

	m_set->addProperty(new Property("Int", 2, "Int"), group);
	m_set->addProperty(new Property("Double", 3.1415,"Double"), group);
	m_set->addProperty(new Property("Bool", TQVariant(true), "Bool"), group);
	m_set->addProperty(p = new Property("3 States", TQVariant(), "3 States", "", Boolean), group);
	p->setOption("3rdState", "None");
	m_set->addProperty(p = new Property("Date", TQDate::currentDate(),"Date"), group);
	p->setIcon("date");
	m_set->addProperty(new Property("Time", TQTime::currentTime(),"Time"), group);
	m_set->addProperty(new Property("DateTime", TQDateTime::currentDateTime(),"Date/Time"), group);

	TQStringList list;//keys
	list << "myitem" << "otheritem" << "3rditem";
	TQStringList name_list; //strings
	name_list << "My Item" << "Other Item" << "Third Item";
	m_set->addProperty(new Property("List", list, name_list, "otheritem", "List"), group);

	// A valueFromList property matching strings with ints (could be any type supported by TQVariant)
	TQValueList<TQVariant> keys;
	keys.append(1);
	keys.append(2);
	keys.append(3);
	Property::ListData *listData = new Property::ListData(keys, name_list);
	m_set->addProperty(new Property("List2", listData, 3, "List 2"), group);

//  Complex
	if (!flat) {
		group = "ComplexGroup";
		m_set->setGroupDescription(group, "Complex Group");
	}
	m_set->addProperty(new Property("Rect", this->geometry(),"Rect"), group);
	m_set->addProperty(new Property("Point", TQPoint(3,4), "Point"), group);
	m_set->addProperty(new Property("Size", TQPoint(3,4), "Size"), group);

//  Appearance
	if (!flat) {
		group = "Appearance Group";
		m_set->setGroupDescription(group, "Appearance Group");
		m_set->setGroupIcon(group, "appearance");
	}
	m_set->addProperty(new Property("Color", TQColor(this->paletteBackgroundColor()),"Color"), group);
	TQPixmap pm(DesktopIcon("network"));
	m_set->addProperty(p = new Property("Pixmap", pm,"Pixmap"), group);
	p->setIcon("kpaint");
	m_set->addProperty(p = new Property("Font", TQFont(this->font()),"Font"), group);
	p->setIcon("fonts");
	m_set->addProperty(new Property("Cursor", TQCursor(TQt::WaitCursor),"Cursor"), group);
	m_set->addProperty(new Property("LineStyle", 3, "Line Style", "", LineStyle), group);
	m_set->addProperty(new Property("SizePolicy", sizePolicy(), "Size Policy"), group);

//	kdDebug() << m_set->groupNames() << endl;

	Editor *edit = new Editor(this,true/*autosync*/);
	setCentralWidget(edit);
	edit->changeSet(m_set);
	resize(400,tqApp->desktop()->height()-200);
	move(x(),5);
	edit->setFocus();
}

Test::~Test()
{
}

#include "test.moc"
