#ifndef __shadowdialogimpl_h__
#define __shadowdialogimpl_h__

#include "shadowdialog.h"
#include "global.h"

class KPrTextPreview;

class KPrShadowDialogImpl : public ShadowDialogBase
{
    Q_OBJECT
  

public:
    KPrShadowDialogImpl( TQWidget *parent, const char* name = 0 );
    ~KPrShadowDialogImpl() {}

    void setShadowDirection( ShadowDirection sd );
    void setShadowDistance( int sd );
    void setShadowColor( const TQColor &sc );

    ShadowDirection shadowDirection();
    int shadowDistance();
    TQColor shadowColor();

signals:
    void apply();

protected slots:
    void colorChanged( const TQColor& );
    void directionChanged( int );
    void distanceChanged( int );
    void applyClicked();
    void okClicked();

protected:
    KPrTextPreview *_preview;
};


#endif
