#include "kchartWizardSetupAxesPage.h"
#include "kchart_view.h"
#include "kchart_part.h"

#include <tqlabel.h>
#include <tqframe.h>
#include <tqlineedit.h>
#include <tqcheckbox.h>
#include <tqgroupbox.h>
#include <tqlayout.h>
#include <tdelocale.h>
#include <tdefontdialog.h>
#include <knumvalidator.h>
#include <math.h>
#include <float.h>


#include <tqspinbox.h>
#include <tqpushbutton.h>
#include <tqcolor.h>

#include "kchart_params.h"

namespace KChart
{

KChartWizardSetupAxesPage::KChartWizardSetupAxesPage( TQWidget* parent,
                                                      KChartPart* chart ) :
    TQWidget( parent ),
    _chart( chart )
{
    chart3d=true;

    TQGridLayout *grid1 = new TQGridLayout(this,2,2,KDialog::marginHint(), KDialog::spacingHint());

    TQGroupBox* tmpTQGroupBox;
    tmpTQGroupBox = new TQGroupBox( this, "GroupBox_1" );
    tmpTQGroupBox->setFrameStyle( 49 );

    TQGridLayout *grid2 = new TQGridLayout(tmpTQGroupBox,3,2,KDialog::marginHint(), KDialog::spacingHint());

    
    //grid = new TQCheckBox( i18n( "Has grid:" ), tmpTQGroupBox  );
    new TQLabel( i18n( "Grid Lines" ), tmpTQGroupBox );
    gridX = new TQCheckBox( i18n( "X axis:" ), tmpTQGroupBox  );
    gridY = new TQCheckBox( i18n( "Y axis:" ), tmpTQGroupBox  );

    gridX->setChecked(_chart->params()->showGrid());
    gridY->setChecked(_chart->params()->showGrid());
    grid2->addWidget(gridX, 0, 0);
    grid2->addWidget(gridY, 1, 0);

    gridColor=new KColorButton(tmpTQGroupBox);
    // PENDING(kalle) Put back in
    //     colorGrid=_chart->params()->GridColor;
    gridColor->setColor( colorGrid );
    grid2->addWidget(gridColor, 0, 1);

    border = new TQCheckBox( i18n( "Border:" ), tmpTQGroupBox );
    // PENDING(kalle) Put back in
    //     border->setChecked( _chart->params()->border );
    grid2->addWidget(border, 2, 0);
    border->setEnabled(false);

    borderColor=new KColorButton(tmpTQGroupBox);
    // PENDING(kalle) Put back in
    //     colorBorder=_chart->params()->LineColor;
    borderColor->setColor( colorBorder );
    grid2->addWidget(borderColor,2,1);
    borderColor->setEnabled(false);

    grid1->addWidget(tmpTQGroupBox,0,0);


    tmpTQGroupBox = new TQGroupBox( this, "GroupBox_2" );
    tmpTQGroupBox->setFrameStyle( 49 );

    grid2 = new TQGridLayout(tmpTQGroupBox,3,2,KDialog::marginHint(), KDialog::spacingHint());

    TQLabel *tmpLabel;
    tmpLabel=new TQLabel(tmpTQGroupBox);
    tmpLabel->setText(i18n("Angle 3D:"));
    grid2->addWidget(tmpLabel,0,0);
    angle = new TQSpinBox(1, 90, 1,tmpTQGroupBox );
    angle->setValue( _chart->params()->threeDBarAngle() );
    grid2->addWidget(angle,0,1);

    tmpLabel=new TQLabel(tmpTQGroupBox);
    tmpLabel->setText(i18n("Depth 3D:"));
    grid2->addWidget(tmpLabel,1,0);
    depth = new TQSpinBox(1, 40, 1, tmpTQGroupBox);
    depth->setValue( static_cast<int>( _chart->params()->threeDBarDepth() ) );
    grid2->addWidget(depth,1,1);

    // Bar width is computed automatically in KDChart (and can be
    //     changed via gaps)
    //     tmpLabel=new TQLabel(tmpTQGroupBox);
//     tmpLabel->setText(i18n("Bar width:"));
//     grid2->addWidget(tmpLabel,2,0);
//     barWidth = new TQSpinBox(1, 200, 1, tmpTQGroupBox);
//     barWidth->setValue(_chart->params()->bar_width);
//     grid2->addWidget(barWidth,2,1);

    grid1->addWidget(tmpTQGroupBox,0,1);

    tmpTQGroupBox = new TQGroupBox( this, "GroupBox_3" );
    tmpTQGroupBox->setFrameStyle( 49 );

    grid2 = new TQGridLayout(tmpTQGroupBox,3,2,KDialog::marginHint(), KDialog::spacingHint());

    tmpLabel=new TQLabel(tmpTQGroupBox);
    tmpLabel->setText(i18n("Y interval:"));
    grid2->addWidget(tmpLabel,0,0);

    TQString tmp;
    y_interval=new TQLineEdit(tmpTQGroupBox);
    y_interval->setValidator(new KFloatValidator( y_interval));
    grid2->addWidget(y_interval,0,1);
    // PENDING(kalle) Put back in
    //     if( _chart->params()->requested_yinterval != -DBL_MAX)
//         y_interval->setText( tmp.setNum(_chart->params()->requested_yinterval));

    tmpLabel=new TQLabel(tmpTQGroupBox);
    tmpLabel->setText(i18n("Y min:"));
    grid2->addWidget(tmpLabel,1,0);
    y_min=new TQLineEdit(tmpTQGroupBox);
    y_min->setValidator(new KFloatValidator( y_min));
    grid2->addWidget(y_min,1,1);
    // PENDING(kalle) Put back in
    //     if( _chart->params()->requested_ymin != DBL_MAX)
//         y_min->setText( tmp.setNum(_chart->params()->requested_ymin));

    tmpLabel=new TQLabel(tmpTQGroupBox);
    tmpLabel->setText(i18n("Y max:"));
    grid2->addWidget(tmpLabel,2,0);
    y_max=new TQLineEdit(tmpTQGroupBox);
    y_max->setValidator(new KFloatValidator( y_max));
    grid2->addWidget(y_max,2,1);
    // PENDING(kalle) Put back in
    //     if( _chart->params()->requested_ymax != -DBL_MAX)
//         y_max->setText( tmp.setNum(_chart->params()->requested_ymax));

    grid1->addWidget(tmpTQGroupBox,1,0);
    tmpTQGroupBox->setEnabled(false);

    tmpTQGroupBox = new TQGroupBox( this, "GroupBox_3" );
    tmpTQGroupBox->setFrameStyle( 49 );

    grid2 = new TQGridLayout(tmpTQGroupBox,3,2,KDialog::marginHint(), KDialog::spacingHint());

    tmpLabel=new TQLabel(tmpTQGroupBox);
    tmpLabel->setText(i18n("Y-label format:"));
    grid2->addWidget(tmpLabel,0,0);
    ylabel_fmt=new TQLineEdit(tmpTQGroupBox);
    grid2->addWidget(ylabel_fmt,0,1);

    // PENDING(kalle) Put back in
    //     if( !_chart->params()->ylabel_fmt.isEmpty()) {
//         int len=_chart->params()->ylabel_fmt.length();
//         ylabel_fmt->setText(_chart->params()->ylabel_fmt.right(len-3));
//     }
    ylabelFont = new TQPushButton( tmpTQGroupBox);
    grid2->addWidget(ylabelFont,1,0);
    ylabelFont->setText(i18n("Font..."));
    // PENDING(kalle) Put back in
    //     ylabel=_chart->params()->yAxisFont();

    ylabelColor=new KColorButton(tmpTQGroupBox);
    grid2->addWidget(ylabelColor,1,1);
    // PENDING(kalle) Put back in
    //     ycolor=_chart->params()->YLabelColor;
    ylabelColor->setColor( ycolor );

#if 0
    tmpLabel=new TQLabel(tmpTQGroupBox);
    tmpLabel->setText(i18n("Y-label 2 format:"));
    grid2->addWidget(tmpLabel,2,0);

    ylabel2_fmt=new TQLineEdit(tmpTQGroupBox);
    grid2->addWidget(ylabel2_fmt,2,1);
    // PENDING(kalle) Put back in
    //     if( !_chart->params()->ylabel2_fmt.isEmpty()) {
//         int len=_chart->params()->ylabel2_fmt.length();
//         ylabel2_fmt->setText(_chart->params()->ylabel2_fmt.right(len-3));
//     }
#endif
    tmpTQGroupBox->setEnabled(false);
    grid1->addWidget(tmpTQGroupBox,1,1);



    connect(ylabelFont,TQT_SIGNAL(clicked()),this,TQT_SLOT(changeLabelFont()));


    connect(ylabelColor,TQT_SIGNAL(changed( const TQColor & )),
            this,TQT_SLOT(changeLabelColor(const TQColor &)));
    connect(borderColor,TQT_SIGNAL(changed( const TQColor & )),
            this,TQT_SLOT(changeBorderColor(const TQColor &)));
    connect(gridColor,TQT_SIGNAL(changed( const TQColor & )),
            this,TQT_SLOT(changeGridColor(const TQColor &)));
}


KChartWizardSetupAxesPage::~KChartWizardSetupAxesPage()
{
    // _chart->removeAutoUpdate( preview );
}

void KChartWizardSetupAxesPage::changeLabelColor(const TQColor &_color)
{
    ycolor=_color;
}

void KChartWizardSetupAxesPage::changeBorderColor(const TQColor &_color)
{
    colorBorder=_color;
}

void KChartWizardSetupAxesPage::changeGridColor(const TQColor &_color)
{
    colorGrid=_color;
}

void KChartWizardSetupAxesPage::changeLabelFont()
{
    if( TDEFontDialog::getFont( ylabel,false,this ) == TQDialog::Rejected )
        return;
}

void KChartWizardSetupAxesPage::paintEvent( TQPaintEvent *)
{
    if(chart3d) {
        angle->setEnabled(true);
        depth->setEnabled(true);
        //barWidth->setEnabled(true);
    } else {
        angle->setEnabled(false);
        depth->setEnabled(false);
        //barWidth->setEnabled(false);
    }
}

void KChartWizardSetupAxesPage::apply()
{
    _chart->params()->setAxisShowGrid(KDChartAxisParams::AxisPosLeft,gridY->isChecked() );
    _chart->params()->setAxisShowGrid(KDChartAxisParams::AxisPosBottom,gridX->isChecked() );

    KDChartAxisParams leftparams;
    leftparams = _chart->params()->axisParams( KDChartAxisParams::AxisPosLeft );
/*    if( !y_max->text().isEmpty())
    {
        leftparams.setAxisAreaMode(KDChartAxisParams::AxisAreaModeMinMaxSize);
        leftparams.setAxisAreaMax(y_max->text().toDouble());
    }
    else
    leftparams.setAxisAreaMode(KDChartAxisParams::AxisAreaModeAutoSize);*/
    //leftparams.setAxisCalcMode(KDChartAxisParams::AxisCalcLogarithmic);
    _chart->params()->setAxisParams( KDChartAxisParams::AxisPosLeft, leftparams );
    // PENDING(kalle) Put back in
    //     _chart->params()->grid =grid->isChecked() ;
//     if( !y_interval->text().isEmpty())
//         _chart->params()->requested_yinterval=y_interval->text().toDouble();
//     else
//         _chart->params()->requested_yinterval=0;
//     if( !y_max->text().isEmpty())
//         _chart->params()->requested_ymax=y_max->text().toDouble();
//     else
//         _chart->params()->requested_ymax=0;
//     if( !y_min->text().isEmpty())
//         _chart->params()->requested_ymin=y_min->text().toDouble();
//     else
//         _chart->params()->requested_ymin=0;

    // PENDING(kalle) Put back in
//     _chart->params()->border =border->isChecked() ;

    _chart->params()->setThreeDBarAngle( angle->value() );
    // PENDING(kalle) Put back in
    //     if(! ylabel_fmt->text().isEmpty()) {
//         TQString tmp="%g "+ylabel_fmt->text();
//         _chart->params()->ylabel_fmt=tmp;
//     } else {
//         _chart->params()->ylabel_fmt="";
//     }
//     _chart->params()->setYAxisFont(ylabel);
//     _chart->params()->YLabelColor=ycolor;
//     _chart->params()->GridColor=colorGrid;
//     _chart->params()->LineColor=colorBorder;
    _chart->params()->setThreeDBarDepth( depth->value() );
    // PENDING(kalle) Put back in
    //     if(! ylabel2_fmt->text().isEmpty()) {
//         TQString tmp="%g "+ylabel2_fmt->text();
//         _chart->params()->ylabel2_fmt=tmp;
//     } else {
//         _chart->params()->ylabel2_fmt="";
//     }
}

}  //namespace KChart

#include "kchartWizardSetupAxesPage.moc"
