/* This file is part of the KDE project
   Copyright (C) 2002, The Karbon Developers

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef __XAMLIMPORT_H__
#define __XAMLIMPORT_H__

#include <KoFilter.h>
#include <tqdom.h>
#include <tqmap.h>
#include <tqptrstack.h>
#include <core/vdocument.h>
#include <core/vgradient.h>
#include <core/vfill.h>
#include <core/vstroke.h>
#include <core/vfillrule.h>
#include "xamlgraphiccontext.h"

class VGroup;
class VPath;

class XAMLImport : public KoFilter
{
	Q_OBJECT
  

public:
	XAMLImport(KoFilter *parent, const char *name, const TQStringList&);
	virtual ~XAMLImport();

	virtual KoFilter::ConversionStatus convert(const TQCString& from, const TQCString& to);

protected:
	class GradientHelper
	{
	public:
		GradientHelper()
		{
			bbox = true;
		}
		VGradient	gradient;
		bool		bbox;
		TQWMatrix	gradientTransform;
	};

	void parseGroup( VGroup *, const TQDomElement & );
	void parseStyle( VObject *, const TQDomElement & );
	void parsePA( VObject *, XAMLGraphicsContext *, const TQString &, const TQString & );
	void parseGradient( const TQDomElement & );
	void parseColorStops( VGradient *, const TQDomElement & );
	double parseUnit( const TQString &, bool horiz = false, bool vert = false, KoRect bbox = KoRect() );
	void parseColor( VColor &, const TQString & );
	TQColor parseColor( const TQString & );
	double toPercentage( TQString );
	double fromPercentage( TQString );
	void setupTransform( const TQDomElement & );
	void addGraphicContext();
	TQDomDocument inpdoc;
	TQDomDocument outdoc;
	void convert();
	VObject* createObject( const TQDomElement & );
	void createText( VGroup *, const TQDomElement & );
	void parseFont( const TQDomElement & );
	// find object with given id in document
	VObject* findObject( const TQString &name );
	// find object with given id in given group
	VObject* findObject( const TQString &name, VGroup * );

private:
	VDocument						m_document;
	TQPtrStack<XAMLGraphicsContext>	m_gc;
	TQMap<TQString, GradientHelper>	m_gradients;
	TQMap<TQString, TQDomElement>		m_paths;
	KoRect							m_outerRect;
};

#endif
