/***************************************************************************
 *                                                                         *
 *   Copyright (C) 2005, 2006 by Kevin Gilbert                             *
 *   kev.gilbert@cdu.edu.au                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 *                                                                         *
 ***************************************************************************/

#ifndef _PANDSOPTIONS_H_
#define _PANDSOPTIONS_H_

#ifdef HAVE_CONFIG_H
#	include <config.h>
#endif

#include <ntqwidget.h>
#include "global.h"

//	forward class definitions
//	=========================

class TQCheckBox;
class TQLineEdit;
class TDEConfig;

//	SimpleOptions class definition
//	==============================

class PAndSOptions : public TQWidget
{	TQ_OBJECT

	public:
		PAndSOptions( TQWidget* parent, const char* name = NULL );

		void finaliseInitialisation( );
		bool getOptions( bool& needRoot );
		void readProfile( TDEConfig* config );
		void saveProfile( TDEConfig* config );
		void setInitialValues( );

		bool    ackState( )            const { return m_ackState;            }
		TQString ackValue( )            const { return m_ackValue;            }
		bool    arpState( )            const { return m_arpState;            }
		bool    dontPingState( )       const { return m_dontPingState;       }
		bool    echoState( )           const { return m_echoState;           }
		bool    netmaskState( )        const { return m_netmaskState;        }
		bool    scanAckState( )        const { return m_scanAckState;        }
		bool    scanFINState( )        const { return m_scanFINState;        }
		bool    scanFTPBounceState( )  const { return m_scanFTPBounceState;  }
		TQString scanFTPRelayHost( )    const { return m_scanFTPRelayHost;    }
		bool    scanIdleState( )       const { return m_scanIdleState;       }
		bool    scanListState( )       const { return m_scanListState;       }
		bool    scanNullState( )       const { return m_scanNullState;       }
		bool    scanPingState( )       const { return m_scanPingState;       }
		bool    scanProtocolState( )   const { return m_scanProtocolState;   }
		bool    scanRPCState( )        const { return m_scanRPCState;        }
		bool    scanSYNState( )        const { return m_scanSYNState;        }
		bool    scanTCPConnectState( ) const { return m_scanTCPConnectState; }
		bool    scanUDPState( )        const { return m_scanUDPState;        }
		bool    scanVersionState( )    const { return m_scanVersionState;    }
		bool    scanWindowState( )     const { return m_scanWindowState;     }
		bool    scanXmasState( )       const { return m_scanXmasState;       }
		bool    synState( )            const { return m_synState;            }
		TQString synValue( )            const { return m_synValue;            }
		bool    timestampState( )      const { return m_timestampState;      }
		TQString zombieDetails( )       const { return m_zombieDetails;       }

	signals:
		void disableFastScan( );
		void displayDocBook( const TQString& );
		void displayHelp( const TQString& );
		void displayUnknown( );
		void optionsDirty( );

	private slots:
		void slotAckClicked( );
		void slotScanFTPBounceCheckBoxClicked( );
		void slotScanIdleCheckBoxClicked( );
		void slotSynClicked( );
		void slotWhatsThisClicked( );

	private:
		void createLayout( );

		TQCheckBox* m_ackCheckBox;
		TQLineEdit* m_ackLineEdit;
		bool       m_ackState;
		TQString    m_ackValue;
		TQCheckBox* m_arpCheckBox;
		bool       m_arpState;
		TQCheckBox* m_dontPingCheckBox;
		bool       m_dontPingState;
		TQCheckBox* m_echoCheckBox;
		bool       m_echoState;
		TQCheckBox* m_netmaskCheckBox;
		bool       m_netmaskState;
		TQCheckBox* m_scanAckCheckBox;
		bool       m_scanAckState;
		TQCheckBox* m_scanFINCheckBox;
		bool       m_scanFINState;
		TQCheckBox* m_scanFTPBounceCheckBox;
		bool       m_scanFTPBounceState;
		TQString    m_scanFTPRelayHost;
		TQLineEdit* m_scanFTPRelayLineEdit;
		TQCheckBox* m_scanIdleCheckBox;
		bool       m_scanIdleState;
		TQCheckBox* m_scanListCheckBox;
		bool       m_scanListState;
		TQCheckBox* m_scanNullCheckBox;
		bool       m_scanNullState;
		TQCheckBox* m_scanPingCheckBox;
		bool       m_scanPingState;
		TQCheckBox* m_scanProtocolCheckBox;
		bool       m_scanProtocolState;
		TQCheckBox* m_scanRPCCheckBox;
		bool       m_scanRPCState;
		TQCheckBox* m_scanTCPConnectCheckBox;
		bool       m_scanTCPConnectState;
		TQCheckBox* m_scanUDPCheckBox;
		bool       m_scanUDPState;
		TQCheckBox* m_scanVersionCheckBox;
		bool       m_scanVersionState;
		TQCheckBox* m_scanWindowCheckBox;
		bool       m_scanWindowState;
		TQCheckBox* m_scanSYNCheckBox;
		bool       m_scanSYNState;
		TQCheckBox* m_scanXmasCheckBox;
		bool       m_scanXmasState;
		TQCheckBox* m_synCheckBox;
		TQLineEdit* m_synLineEdit;
		bool       m_synState;
		TQString    m_synValue;
		TQCheckBox* m_timestampCheckBox;
		bool       m_timestampState;
		TQString    m_zombieDetails;
		TQLineEdit* m_zombieLineEdit;
};

#endif	// _PANDSOPTIONS_H_
