
/***************************************************************************
                          kstartdlg.h  -  description
                             -------------------
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSTARTDLG_H
#define KSTARTDLG_H

#include <kdialogbase.h>

#include <tdelocale.h>
#include <tdefontdialog.h>
#include <kurlrequester.h>
#include <kiconview.h>

#include <tqstring.h>
#include <tqradiobutton.h>
#include <tqlineedit.h>
#include <tqcheckbox.h>
#include <tqpushbutton.h>

/**KMyMoney 2 start dialog
  */

class KStartDlg : public KDialogBase  {
   Q_OBJECT
  
public:
	KStartDlg( TQWidget *parent=0, const char *name=0, bool modal=true );
	virtual ~KStartDlg();
  bool isNewFile(void)  const        { return isnewfile;           }
  bool isOpenFile(void) const        { return !kurlrequest->url().isEmpty();          }
  const TQString getURL(void) const { return kurlrequest->url(); }
  TQString getTemplateName(void) const { return templatename;    }

private: // Private methods
  TQString m_filename;
	bool fileExists(KURL url);

  void setPage_Template();
  void setPage_Documents();
  /** misc widgets */
  /** Write config window */
  void writeConfig();
  /** Read config window */
  void readConfig();
  TDEIconView *view_wizard;
  TDEIconView *view_recent;
  KURLRequester *kurlrequest;
  /** misc variables */
  bool isnewfile;
  bool isopenfile;
  TQString templatename;
  TQVBox *templateMainFrame;
  TQFrame *recentMainFrame;

protected slots:
  /** No descriptions */
  void slotOk();
private slots:
  void slotTemplateClicked(TQIconViewItem *item);
  /** slot to recent view */
  void slotRecentClicked(TQIconViewItem *item);

  /** Handle selections */
  void slotTemplateSelectionChanged(TQIconViewItem* item);
  void slotRecentSelectionChanged(TQIconViewItem* item);
  void slotAboutToShowPage(TQWidget* page);
};

#endif
