/***************************************************************************
    Copyright (C) 2004 Christian Hubinger
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kmfruleoptioneditmac.h"


// TQt includes
#include <tqstring.h>

// KDE includes
#include <kdebug.h>
#include <tdelocale.h>

// Project includes
#include "../../core/iptrule.h"
#include "../../core/kmfruleeditinterface.h"
#include "kmfruleeditmac.h"

namespace KMF {
KMFRuleOptionEditMAC::KMFRuleOptionEditMAC(TQObject *parent, const char *name)
		: KMFRuleOptionEditInterface(parent, name) {
	kdDebug() <<"KMFRuleOptionEditMAC::KMFRuleOptionEditMAC(TQObject *parent, const char *name)" << endl;
	kdDebug() << "Parent has Type: " << parent->className()  << endl;
	
	m_edit = new KMFRuleEditMac( 0 , "Edit", 0 );
	m_edit->hide();

	connect( m_edit,TQ_SIGNAL(sigHideMe() ), 
		this,TQ_SLOT( slotShowOverview() ) );
}

KMFRuleOptionEditMAC::~KMFRuleOptionEditMAC() {}

void KMFRuleOptionEditMAC::slotShowOverview() {
	if ( KMFRuleEditInterface* ruleedit = dynamic_cast<KMFRuleEditInterface*> ( parent() ) ) {
		ruleedit->showOverview();
	} else {
		kdDebug() << "KMFRuleOptionEditMAC::slotShowOverview(): parent() not of type KMFRuleEditInterface" << endl;
	}
}

const TQString& KMFRuleOptionEditMAC::optionEditName() const {
	return *( new TQString( i18n("MAC Option") ) );
}
const TQString& KMFRuleOptionEditMAC::description() const {
	return *( new TQString( i18n("This plugin manages the MAC address based options of iptables.") ) );
}

void KMFRuleOptionEditMAC::loadRule( IPTRule* rule ) {
	if ( !rule ) {
		kdDebug() << "KMFRuleOptionEditMAC::loadRule( IPTRule* rule ) - rule == 0" << endl;
		return;
	}
	
	m_edit->loadRule( rule );
	m_rule = rule;

}

TQWidget* KMFRuleOptionEditMAC::editWidget() {
	if ( ! m_edit ) {
		kdDebug() << "KMFRuleOptionEditMAC::editWidget() - m_edit == 0" << endl;
		return 0;
	}
	return m_edit;
}





// It's usually safe to leave the factory code alone.. with the
// notable exception of the TDEAboutData data
#include <tdeaboutdata.h>
#include <tdelocale.h>

// TDEInstance* KMFRuleOptionEditMACFactory::s_instance = 0L;
// TDEAboutData* KMFRuleOptionEditMACFactory::s_about = 0L;

KMFRuleOptionEditMACFactory::KMFRuleOptionEditMACFactory( TQObject* parent, const char* name )
		: KLibFactory( parent, name ) {
// 	s_instance = new TDEInstance( "KMFRuleOptionEditMACFactory" );
}

TQObject* KMFRuleOptionEditMACFactory::createObject( TQObject* parent, const char* name,
        const char*, const TQStringList & ) {
	TQObject * obj = new KMFRuleOptionEditMAC( parent, name );
	emit objectCreated( obj );
	return obj;
}


extern "C" {
	void* init_libkmfruleoptionedit_mac() {
		return new KMFRuleOptionEditMACFactory;
	}
}


}

#include "kmfruleoptioneditmac.moc"
