/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2001-2004
*/

#ifndef KMFLISTVIEWITEM_H
#define KMFLISTVIEWITEM_H

#include "kmflistview.h"

// TQt includes
#include <tqstring.h>
#include <tquuid.h>
#include <tqguardedptr.h>

// KDE includes

// Project includes

/**
@author Christian Hubinger
*/

namespace KMF {
class IPTable;
class IPTChain;
class IPTRule;
class IPTRuleOption;
class NetfilterObject;
class KMFNetZone;
class KMFNetHost;
class KMFTarget;
class KMFProtocol;
class KMFProtocolCategory;

class KDE_EXPORT KMFListViewItem : public TDEListViewItem {
public:
	KMFListViewItem( TDEListView *parent, NetfilterObject* );
	KMFListViewItem( TDEListViewItem *parent, NetfilterObject* );
	KMFListViewItem( TDEListView *parent, TDEListViewItem *after, NetfilterObject* );
	KMFListViewItem( TDEListViewItem *parent, TDEListViewItem *after, NetfilterObject* );

	virtual ~KMFListViewItem();

	NetfilterObject* netfilterObject() const;

	IPTable* table()  const {
		return m_table;
	};
	IPTChain* chain() const {
		return m_chain;
	};
	IPTRule* rule() const {
		return m_rule;
	};
	IPTRuleOption* ruleOption() const {
		return m_option;
	};

	KMFNetZone* zone() const {
		return m_zone;
	};

	KMFNetHost* host() const {
		return m_host;
	};
	
	KMFTarget* target() const {
		return m_target;
	};
	
	KMFProtocol* protocol() const {
		return m_protocol;
	};
	
	KMFProtocolCategory* protocolCategory() const {
		return m_protocolCategory;
	};


	bool isTopItem() const {
		return m_top;
	};
	
	int type();

	const TQUuid& uuid() const {
		return m_obj_id;
	}

	void setupZoneView();
	void setupTargetView();
	void setupNetHostView();
	void setupProtocolView();
	void setupProtocolCategoryView();
	
	void deleteChildren();
	void setChildrenInUse( bool );
	void setTopItem( bool );
	void setInUse( bool );
	bool inUse();
	// enum { TABLE = 0, CHAIN = 1, RULE = 2, RULEOPTION = 3 , NETZONE = 4, NETHOST = 5,  KMFTARGET = 6 };

	void loadNetfilterObject( NetfilterObject* );
	virtual TQString key( int column, bool ascending ) const;

private:
/*	IPTable *m_table;
	IPTChain *m_chain;
	IPTRule *m_rule;
	IPTRuleOption *m_option;
	KMFNetZone* m_zone;
	KMFNetHost* m_host;
	KMFTarget* m_target;
	KMFProtocol* m_protocol;
	KMFProtocolCategory* m_protocolCategory;
	NetfilterObject* m_object;*/
	
	TQGuardedPtr<IPTable> m_table;
	TQGuardedPtr<IPTChain> m_chain;
	TQGuardedPtr<IPTRule> m_rule;
	TQGuardedPtr<IPTRuleOption> m_option;
	TQGuardedPtr<KMFNetZone> m_zone;
	TQGuardedPtr<KMFNetHost> m_host;
	TQGuardedPtr<KMFTarget> m_target;
	TQGuardedPtr<KMFProtocol>  m_protocol;
	TQGuardedPtr<KMFProtocolCategory> m_protocolCategory;
	TQGuardedPtr<NetfilterObject> m_object;

	
	// int m_type;
	TQUuid m_obj_id;
	bool m_top;
	bool m_inUse;
};
}
#endif
