//
// C++ Interface: $MODULE$
//
// Description: 
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KMFPROTOCOL_H
#define KMFPROTOCOL_H

#include "netfilterobject.h"

// TQt includes
#include <tqstringlist.h>
#include <tqstring.h>
#include <tqguardedptr.h>
#include <tqptrlist.h>
#include <tqvaluelist.h>
#include <tqmap.h>

// KDE includes
#include <kdemacros.h>
#include <kurl.h>

// Project includes
#include "kmfprotocolcategory.h"

/**
@author Christian Hubinger
*/

namespace KMF {
class KMFGenericDoc;
class KMFNetZone;
class KMFError;
class KMFProtocolCategory;
class KMFProtocolUsage;

class KDE_EXPORT KMFProtocol : public NetfilterObject {
	friend class KMFProtocolCategory;
	
public:
   
    ~KMFProtocol();
	virtual int type();
	virtual void clear();

	void addPort( const TQString& , int );
	void delPort( const TQString&, int );
	void setCustomProtocol( bool );
	void setCategory( KMFProtocolCategory* );
	
	virtual const TQDomDocument& getDOMTree();
	virtual void loadXML(const TQDomDocument&, TQStringList& errors );
	virtual void loadXML( TQDomNode, TQStringList& errors );
	
	bool customProtocol() const {
		return m_customProtocol;
	};
	
	KMFProtocolCategory* category() const {
		return m_category;
	}
	
	TQValueList<int>&  udpPorts() {
		return m_udpPorts;
	}

	TQValueList<int>&  tcpPorts() {
		return m_tcpPorts;
	}

	
	const TQString& udpPortsList();
	const TQString& tcpPortsList();
	
	bool replaceTCPPort( int oldPort, int newPort );
	bool replaceUDPPort( int oldPort, int newPort );

	bool isEquivalent( KMFProtocol *other );

	enum { TCP, UDP /*, ICMP */ } Protocol;
	
	KMFProtocolUsage *createUsage();
	
private:	
	 KMFProtocol( KMFProtocolCategory* parent, const char* name );
	 
private:
	TQValueList<KMFProtocolUsage*> m_usages;
	KMFProtocolCategory* m_category;
	TQValueList<int> m_udpPorts;
	TQValueList<int> m_tcpPorts;
	bool m_customProtocol;
};
}
#endif
