/***************************************************************************
begin                : Mon Feb 4 2002
copyright            : (C) 2002 by Christian Hubinger
email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef IPTRULEOPTION_H
#define IPTRULEOPTION_H

#include "netfilterobject.h"

// TQt
#include <tqstring.h>
#include <tqstringlist.h>
#include <tqdict.h>

#include <tqdom.h>

#include <kdemacros.h>

#define MAXOPTNUM 10
namespace KMF {
class KMFIPTDoc;
class IPTRule;

/**
  * class IPTRuleOption
  *
  */

class KDE_EXPORT IPTRuleOption : public NetfilterObject {
	//########## BEGIN STATIC ##############

public:
	/** Contains the option commands for each option type. */
	static TQDict<TQStringList>* getOptionStringDict();
	
	/** Returns a Stringlist containing the user visible strings for the opition */
	static TQDict<TQStringList>* getGUIStringDict();
	
	/** Return a list of all currently available option types */
	static TQPtrList<TQString>* getAvailableOptionTypes();
	
	static void readRuleOptionDefinition( const TQDomDocument& );
private:
	/** Reads a XML OptionDefinitionNode */
	static void readRuleOptionDefinitionNode( const TQDomNode& curr, TQStringList* vals, TQStringList* gui ) ;

private:  // DATA
	static TQDict<TQStringList>* m_dict_option_strings;
	static TQDict<TQStringList>* m_dict_gui_strings;
	static TQDict<TQString>* m_dict_option_names;
	
	static TQPtrList<TQString>* m_known_types;
	static bool m_created_dict;
	//########## END STATIC ################

	/** Public methods: */
public:
	IPTRuleOption( IPTRule* rule, const char* name );
	~IPTRuleOption();

	virtual int type();
	virtual void clear();
	
	/** restore the opotion config from an xml sniplet */
	virtual void loadXML( const TQDomDocument&, TQStringList& errors );

	/** restore the opotion config from an xml sniplet */
	virtual void loadXML( TQDomNode, TQStringList& errors );

	/** Makes the option empty. */
	void reset();

	/** Returns true if no option values are set */
	bool isEmpty();

	/** Return DomDocument representing this rule() */
	const TQDomDocument& getDOMTree( );

	/** Returns a TQString containing the option. */
	const TQString& toString( );

	/** Set Option Type */
	void setOptionType( const TQString& );
	
	/** Return the type of the option. */
	const TQString& getOptionType() const {
		return m_option_type;
	};
	
	/** Return the type of the option. */
	const TQString& guiName() const ;

	/** Returns true if this is a target option otherwise false*/
	bool isTargetOption() const {
		return m_target_option;
	};

	/** Returns a pointer to the rule to which this options belongs */
	IPTRule* rule() const {
		return m_rule;
	};

	/** Make this option a target option.
		Target options are appended at the very
		end of the rule */
	void setTargetOption( bool );

	/** Load the provided option values in the TQStringList. */
	void loadValues( TQStringList );

	/** Returns a TQStringList containing the option values. */
	const TQStringList& getValues();

private:
	IPTRule *m_rule;
	TQString m_option_type;
	bool m_target_option;
	TQString m_values[ MAXOPTNUM ];
};
}

#endif // IPTRULEOPTION_H
