/*
 * Copyright (C) 2004 Robert Hogan <robert at roberthogan dot net>
 */

#ifndef _FRESHKLAM_H_
#define _FRESHKLAM_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tdeapplication.h>
#include <tdemainwindow.h>
#include <kdirlister.h> //stack allocated
#include <kurl.h>       //stack allocated
#include <kresolver.h> // namespace

namespace DOM {
  class Node;
}


using namespace KNetwork;

class KPrinter;
class TDEToggleAction;
class KURL;
class TQLineEdit;
class TQComboBox;
class TQCheckBox;
class TQListBox;
class TQPushButton;
class TQLabel;
class TDEProcess;
class TDEConfig;
class KURLRequester;
class KLineEdit;
class KProgressDialog;
class KProcIO;

/**
 * This class serves as the main window for Freshklam.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author $AUTHOR <$EMAIL>
 * @version $APP_VERSION
 */
class Freshklam : public TQWidget
{
    TQ_OBJECT
public:
    /**
     * Default Constructor
     */
    Freshklam(TQWidget *parent, const char *name=0);

    /**
     * Default Destructor
     */
    virtual ~Freshklam();

    /**
     * Use this method to load whatever file/URL you have
     */
    void  setDirName(TQString);
    TQString  getCurrentDBDir();
    bool isFreshklamAlive();
    TQPushButton *search_button, *cancel_button;
    void enableAutoUpdates();

protected:
    /**
     * Overridden virtuals for TQt drag 'n drop (XDND)
     */
    /*virtual void dragEnterEvent(TQDragEnterEvent *event);
    virtual void dropEvent(TQDropEvent *event);*/

protected:
    /**
     * This function is called when it is time for the app to save its
     * properties for session management purposes.
     */
    //void saveProperties(TDEConfig *);

    /**
     * This function is called when this app is restored.  The TDEConfig
     * object points to the session management config file that was saved
     * with @ref saveProperties
     */
    //void readProperties(TDEConfig *);



private:
    void setupAccel();
    void setupActions();

private:
    //FreshklamView *m_view;



signals:
    void itemSelected(TQString abs_filename, int line);


public slots:
    void slotSearch();
    void slotCancel();
    void getCurrentVersionOfClamAV( );
private slots:
/*    void slotProg();*/
    void childExited();
    void processDied();
    void receivedOutput(TDEProcess *proc, char *buffer, int buflen);
    void slotClear();
    void writeConf();
    void handleChecks();
    //void arkollonExited(TDEProcess *arkollonproc);
/*    void klamavInstallationExited(TDEProcess *arkollonproc);
    void clamavInstallationExited(TDEProcess *arkollonproc);*/
    //void newItems( const KFileItemList& );
    void readVersionLine(KProcIO *);
/*    void parseSFPage();
    void parseSFPageHack();*/
/*    void updateCanceled();*/
    void versionExited();
private:
/*    void getLatestVersionFromSF(KURL url);
    void getLatestVersionFromSFHack(KURL url);*/
    void processOutput();
    void finish();
    void getout();
    void updateMailClient();
    void enableInputs();
    void disableInputs();
    bool killPID();
    void  createDBDir();
/*    void  downloadComponent(TQString component, TQString version, TQString extension);*/
    void startProgressDialog( const TQString & text );
/*    void checkForNewKlamAV();*/
    void initCheckBoxes();
/*    void getVersionFromLink( const DOM::Node &n );
    void completedSearchForUpdates(const TQString &component, const TQString &extension);*/
    void updateMetaDB();
/*    TQString getMirror();*/
    TQLineEdit *template_edit;
    TQComboBox *check_combo;
    KURLRequester *dir_combo;
    KURLRequester *proxy_dir_combo;
    TQCheckBox *daemon_box;
    TQCheckBox *recursive_box;
    TQListBox *resultbox;
    TQLabel *status_label, *matches_label;
    TDEProcess *childproc;
    KProcIO *versionproc;
    TQString buf;
    TDEConfig* config;
    TQStringList lastSearchItems;
    TQStringList lastDownloadPaths;
    KLineEdit    *proxyIP;
    KLineEdit    *proxyPort;
    KLineEdit    *proxyUser;
    KLineEdit    *proxyPass;
    TQString tempFileName;
    TQString errorMessage;
    TQString pidFileName;
    bool freshklamAlive;
    KProgressDialog *progressDialog;
    TQTimer *timer;
/*    bool upgradeinprogress;*/
    bool checkingDirectly;
/*    double highestsofarnumeric;
    TQString highestsofarraw;
    TQString highestsofarfilename;*/
/*    TQString currentClamAVVersion;
    TDEHTMLPart *filelist;*/

// private:
//     KDirLister clamav_lister;
//     KURL       clamav_url;
//     KDirLister klamav_lister;
//     KURL       klamav_url;
     KURL       m_url;
};

#endif // _Freshklam_H_
