/***************************************************************************
                          boldmenuitem.h  -  description
                             -------------------
    begin                : Sat Sep 1 2001
    copyright            : (C) 2001 by Leonid Zeitlin
    email                : lz@europe.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BOLDMENUITEM_H
#define BOLDMENUITEM_H

#include <ntqmenudata.h>

/**A custom menu item that can display its text in bold
  *@author Leonid Zeitlin
  * 02.09.2001: somehow I cannot make it work. The item looks ok when not
  * selected, but appears empty when selected. I have a suspicion that this
  * is a problem with some KDE styles (B3 in particular), the style doesn't
  * paint custom menu items correctly. With some other styles, such as TQt built-in
  * Windows style, everything works correctly. I suspend the work on this for the
  * time being...
  */

class BoldMenuItem : public TQCustomMenuItem  {
private:
  TQString m_text;
  TQColor m_active_text_color;
  bool m_bold;
  TQSize m_size;
public: 
	BoldMenuItem(const TQString &text, const TQColor &active_text_color, bool bold = false);
	~BoldMenuItem();
	TQString& text() { return m_text; };
	void setText(const TQString& value) { m_text = value; };
	bool bold() { return m_bold; };
	void setBold(bool value) { m_bold = value; };
	virtual void paint(TQPainter* painter, const TQColorGroup& /*cg*/,
	  bool act, bool /*enabled*/, int x, int y, int w, int h);
	virtual void setFont(const TQFont& font);
	virtual TQSize sizeHint() { return m_size; };
};

#endif
