/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2005-07-07
 * Description : a kipi plugin to export images to Flickr web service
 *
 * Copyright (C) 2005-2008 by Vardhman Jain <vardhman at gmail dot com>
 * Copyright (C) 2008 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// TQt includes.

#include <tqpushbutton.h>
#include <tqlabel.h>
#include <tqframe.h>
#include <tqheader.h>
#include <tqbuttongroup.h>
#include <tqradiobutton.h>
#include <tqgroupbox.h>
#include <tqspinbox.h>
#include <tqcheckbox.h>
#include <tqlayout.h>
#include <tqtooltip.h>
#include <tqwhatsthis.h>

// KDE includes.

#include <ktabwidget.h>
#include <klineedit.h>
#include <kdialog.h>
#include <kactivelabel.h>
#include <tdelocale.h>
#include <tdehtml_part.h>
#include <tdehtmlview.h>
#include <kseparator.h>
#include <kiconloader.h>
#include <tdeapplication.h>

// Libkipi includes.

#include <libkipi/interface.h>

// Local includes.

#include "imageslist.h"
#include "flickrwidget.h"
#include "flickrwidget.moc"

namespace KIPIFlickrExportPlugin
{

FlickrWidget::FlickrWidget(TQWidget* parent, KIPI::Interface *iface)
            : TQWidget(parent)
{
    setName("FlickrWidget");

    TQVBoxLayout* flickrWidgetLayout = new TQVBoxLayout(this, 5, 5);

    m_photoView               = 0; //new TDEHTMLPart(splitter);
    KSeparator *line          = new KSeparator(Horizontal, this);
    m_tab                     = new KTabWidget(this);
    KActiveLabel *headerLabel = new KActiveLabel(this);
    headerLabel->setFocusPolicy(TQWidget::NoFocus);
    headerLabel->setLinkUnderline(false);
    headerLabel->setText(i18n("<qt><b><h2><a href='http://www.flickr.com'>"
                              "<font color=\"#0065DE\">flick</font>"
                              "<font color=\"#FF0084\">r</font></a>"
                              " Export"
                              "</h2></b></qt>"));

    // -------------------------------------------------------------------

    m_imglst                       = new ImagesList(m_tab, iface);
    TQWidget* settingsBox           = new TQWidget(m_tab);
    TQVBoxLayout* settingsBoxLayout = new TQVBoxLayout(settingsBox);

    //m_newAlbumBtn = new TQPushButton(settingsBox, "m_newAlbumBtn");
    //m_newAlbumBtn->setSizePolicy(TQSizePolicy::Fixed, TQSizePolicy::Fixed);
    //m_newAlbumBtn->setText(i18n("&New Album"));

    TQGridLayout* tagsLayout  = new TQGridLayout(1, 1);
    TQLabel* tagsLabel        = new TQLabel(i18n("Added Tags: "), settingsBox);
    m_tagsLineEdit           = new KLineEdit(settingsBox);
    m_exportHostTagsCheckBox = new TQCheckBox(settingsBox);
    m_exportHostTagsCheckBox->setText(i18n("Use Host Application Tags"));
    m_stripSpaceTagsCheckBox = new TQCheckBox(settingsBox);
    m_stripSpaceTagsCheckBox->setText(i18n("Strip Space From Host Application Tags"));
    TQToolTip::add(m_tagsLineEdit, i18n("Enter here new tags separated by space."));

    tagsLayout->addWidget(tagsLabel,                0, 0);
    tagsLayout->addWidget(m_tagsLineEdit,           0, 1);
    tagsLayout->addWidget(m_exportHostTagsCheckBox, 1, 1);
    tagsLayout->addWidget(m_stripSpaceTagsCheckBox, 2, 1);

    // ------------------------------------------------------------------------

    TQGroupBox* optionsBox         = new TQGroupBox(i18n("Override Default Options"), settingsBox);
    optionsBox->setColumnLayout(0, Qt::Vertical);
    optionsBox->layout()->setSpacing(KDialog::spacingHint());
    optionsBox->layout()->setMargin(KDialog::spacingHint());
    TQGridLayout* optionsBoxLayout = new TQGridLayout(optionsBox->layout(), 5, 3);

    m_publicCheckBox = new TQCheckBox(optionsBox);
    m_publicCheckBox->setText(i18n("As in accessible for people", "Public (anyone can see them)"));

    m_familyCheckBox = new TQCheckBox(optionsBox);
    m_familyCheckBox->setText(i18n("Visible to Family"));

    m_friendsCheckBox = new TQCheckBox(optionsBox);
    m_friendsCheckBox->setText(i18n("Visible to Friends"));

    m_resizeCheckBox = new TQCheckBox(optionsBox);
    m_resizeCheckBox->setText(i18n("Resize photos before uploading"));
    m_resizeCheckBox->setChecked(false);

    m_dimensionSpinBox = new TQSpinBox(0, 5000, 10, optionsBox);
    m_dimensionSpinBox->setValue(600);
    m_dimensionSpinBox->setSizePolicy(TQSizePolicy::Fixed, TQSizePolicy::Fixed);
    m_dimensionSpinBox->setEnabled(false);

    TQLabel* resizeLabel = new TQLabel(i18n("Maximum dimension (pixels):"), optionsBox);

    m_imageQualitySpinBox = new TQSpinBox(0, 100, 1, optionsBox);
    m_imageQualitySpinBox->setValue(85);
    m_imageQualitySpinBox->setSizePolicy(TQSizePolicy::Fixed, TQSizePolicy::Fixed);

    // NOTE: The term Compression factor may be to technical to write in the label
    TQLabel* imageQualityLabel = new TQLabel(i18n("JPEG Image Quality (higher is better):"), optionsBox);

    optionsBoxLayout->addMultiCellWidget(m_publicCheckBox,      0, 0, 0, 3);
    optionsBoxLayout->addMultiCellWidget(m_familyCheckBox,      1, 1, 0, 3);
    optionsBoxLayout->addMultiCellWidget(m_friendsCheckBox,     2, 2, 0, 3);
    optionsBoxLayout->addMultiCellWidget(imageQualityLabel,     3, 3, 0, 2);
    optionsBoxLayout->addMultiCellWidget(m_imageQualitySpinBox, 3, 3, 3, 3);
    optionsBoxLayout->addMultiCellWidget(m_resizeCheckBox,      4, 4, 0, 3);
    optionsBoxLayout->addMultiCellWidget(resizeLabel,           5, 5, 1, 2);
    optionsBoxLayout->addMultiCellWidget(m_dimensionSpinBox,    5, 5, 3, 3);
    optionsBoxLayout->setColSpacing(0, KDialog::spacingHint());
    optionsBoxLayout->setColStretch(1, 10);
    optionsBoxLayout->setSpacing(KDialog::spacingHint());
    optionsBoxLayout->setMargin(0);

    // ------------------------------------------------------------------------

    TQGroupBox* accountBox = new TQGroupBox(i18n("Account"), settingsBox);
    accountBox->setColumnLayout(0, Qt::Vertical);
    accountBox->layout()->setSpacing(KDialog::spacingHint());
    accountBox->layout()->setMargin(KDialog::spacingHint());
    TQGridLayout* accountBoxLayout = new TQGridLayout(accountBox->layout(), 1, 3);

    TQLabel *userNameLabel  = new TQLabel(i18n("User Name: "), accountBox);
    m_userNameDisplayLabel = new TQLabel(accountBox);
    m_changeUserButton     = new TQPushButton(accountBox);
    m_changeUserButton->setText(i18n("Use a different account"));
    m_changeUserButton->setIconSet(SmallIcon("switchuser"));

    accountBoxLayout->addMultiCellWidget(userNameLabel,          0, 0, 0, 0);
    accountBoxLayout->addMultiCellWidget(m_userNameDisplayLabel, 0, 0, 1, 1);
    accountBoxLayout->addMultiCellWidget(m_changeUserButton,     0, 0, 3, 3);
    accountBoxLayout->setColStretch(2, 10);
    accountBoxLayout->setSpacing(KDialog::spacingHint());
    accountBoxLayout->setMargin(0);

    settingsBoxLayout->addLayout(tagsLayout);
    settingsBoxLayout->addWidget(optionsBox);
    settingsBoxLayout->addWidget(accountBox);
    settingsBoxLayout->addStretch(10);
    settingsBoxLayout->setSpacing(KDialog::spacingHint());
    settingsBoxLayout->setMargin(KDialog::spacingHint());

    // ------------------------------------------------------------------------

    flickrWidgetLayout->addWidget(headerLabel);
    flickrWidgetLayout->addWidget(line);
    flickrWidgetLayout->addWidget(m_tab, 5);
    flickrWidgetLayout->setSpacing(KDialog::spacingHint());
    flickrWidgetLayout->setMargin(0);

    m_tab->insertTab(m_imglst,    i18n("Files List"),     FILELIST);
    m_tab->insertTab(settingsBox, i18n("Upload Options"), UPLOAD);

    // ------------------------------------------------------------------------

    connect(m_resizeCheckBox, TQT_SIGNAL(clicked()),
            this, TQT_SLOT(slotResizeChecked()));

    connect(m_exportHostTagsCheckBox, TQT_SIGNAL(clicked()),
            this, TQT_SLOT(slotExportHostTagsChecked()));
}

FlickrWidget::~FlickrWidget()
{
}

void FlickrWidget::slotResizeChecked()
{
    m_dimensionSpinBox->setEnabled(m_resizeCheckBox->isChecked());
}

void FlickrWidget::slotExportHostTagsChecked()
{
    m_stripSpaceTagsCheckBox->setEnabled(m_exportHostTagsCheckBox->isChecked());
}

} // namespace KIPIFlickrExportPlugin
