/*
 *   kioskgui.h
 *
 *   Copyright (C) 2003,2004 Waldo Bastian <bastian@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2 as
 *   published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#ifndef _KIOSKGUI_H_
#define _KIOSKGUI_H_

#include <tqlistview.h>

#include <tdeconfig.h>
#include <tdemainwindow.h>

class MainView;
class ProfileSelectionPageUI;
class ComponentSelectionPage;
class ProfilePropsPage;
class PageWidget;
class KioskData;
class KioskRun;
class ComponentData;
class TDEAction;
class TDEToggleAction;

class KioskGui : public TDEMainWindow
{
   Q_OBJECT
  
public:
   enum { PAGE_PROFILE_SELECTION = 1,
          PAGE_COMPONENT_SELECTION = 2, 
          PAGE_COMPONENT = 3,
          PAGE_PROFILE_NEW = 4,
          PAGE_PROFILE_PROPS = 5,
          PAGE_PROFILE_ASSIGN = 6,
          PAGE_LAST = PAGE_PROFILE_ASSIGN };

   KioskGui();
   ~KioskGui();

   void setupActions();
   void saveProperties(TDEConfig *config);
   void readProperties(TDEConfig *config);

   void selectPage(int page, bool save);
   void loadPage(int page);
   bool savePage(int page);

   void loadProfiles();

public slots:
   void updateButtons();
   void finishedPage(bool save=true);
   void discardPage();
   void nextPage();
   void slotDeleteProfile(TQListViewItem *item=0);
   void slotAddProfile();
   void slotProfileProperties();
   void slotProfileSetup();
   void slotManageUsers();
   void slotProfileContextMenu(TQListViewItem *item, const TQPoint &p);
   void slotConfig();

   void uploadAllProfiles();
   void uploadCurrentProfile();
   void slotUpdateBackground();

   void slotCheckEtcSkel();

protected:
   void updateActions();
   void updateBackground();
   void setWidgetBackground(TQWidget *w);
   void setSubCaption(const TQString &subCaption);
   
   virtual bool queryClose();

protected:
   MainView *m_view;
   ProfileSelectionPageUI *m_profileSelectionPage;
   ComponentSelectionPage *m_componentSelectionPage;
   PageWidget *m_componentPage;
   PageWidget *m_profileAssignPage;
   ProfilePropsPage *m_profilePropsPage;
   
   KioskData *m_data;
   KioskRun *m_run;
   
   int m_activePage;
   TQString m_profile;
   TQString m_component;
   ComponentData * m_componentData;
   TDEAction *m_uploadAction;
   TDEToggleAction *m_backgroundAction;
};

#endif
