/***************************************************************************
    begin                :  2003-07-01 17:33:00 CEST 2003
    copyright            : (C) 2003 by Jeroen Wijnhout
    email                :  Jeroen.Wijnhout@kdemail.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KILEACTIONS_H
#define KILEACTIONS_H

#include <tqdict.h>

#include <tdeaction.h>
#include <kdialogbase.h>
#include <klineedit.h>

class TQCheckBox;
class TQLineEdit;

class KileInfo;

namespace KileAction
{

enum { KeepHistory=1, ShowAlternative=2, ShowBrowseButton=4, FromLabelList=8, FromBibItemList=16, ShowLabel=32, AddProjectFile=64};
/*
	TagData
*/

class TagData
{
public:
	TagData(const TQString &t, const TQString &tB = TQString(), const TQString &tE = TQString(), int x = 0, int y = 0, const TQString &desc = TQString())
		: text(t), tagBegin(tB), tagEnd(tE), dx(x), dy(y), description(desc) {}

	TagData() : text(TQString()), tagBegin(TQString()), tagEnd(TQString()), dx(0), dy(0), description(TQString()) {}

	TQString		text;
	TQString		tagBegin, tagEnd;
	int			dx,dy;
	TQString		description;
};

class Tag : public TDEAction
{
	TQ_OBJECT
  

public:
	//constructors
	Tag(const TQString &text, const TDEShortcut &cut, const TQObject *receiver, const char *slot, TDEActionCollection *parent, const char *name
			, const TQString &tagBegin, const TQString &tagEnd = TQString(), int dx=0, int dy=0, const TQString &description = TQString());

	Tag(const TQString &text, const TQString& pix, const TDEShortcut &cut, const TQObject *receiver, const char *slot, TDEActionCollection *parent, const char *name
			, const TQString &tagBegin, const TQString &tagEnd = TQString(), int dx=0, int dy=0, const TQString &description = TQString());

	Tag(const TQString &text, const TDEShortcut &cut, const TQObject *receiver, const char *slot, TDEActionCollection *parent, const char *name
			, const TagData& data);

	Tag(const TQString &text, const TQString& pix, const TDEShortcut &cut, const TQObject *receiver, const char *slot, TDEActionCollection *parent, const char *name
			, const TagData& data);

	~Tag();

private:
	void init(const TQObject *receiver = 0, const char *slot = 0);

signals:
	//sends along tagdata so that receiver knows what to insert
	void activated(const KileAction::TagData&);

private slots:
	//emits the activated(TagData) signal
	virtual void emitData();

protected:
	TagData m_data;
};

/*
	InputTag: adds a history list and options for a input dialog to TagData
*/
class InputTag : public Tag
{
	TQ_OBJECT
  

public:
	//constructors
	InputTag(KileInfo* ki, const TQString &text, const TDEShortcut &cut, const TQObject *receiver, const char *slot, TDEActionCollection *parent, const char *name, TQWidget *wparent,uint options
			, const TQString &tagBegin, const TQString &tagEnd = TQString(), int dx=0, int dy=0, const TQString &description = TQString(), const TQString &hint = TQString(), const TQString &alter = TQString());

	InputTag(KileInfo* ki, const TQString &text, const TQString& pix, const TDEShortcut &cut, const TQObject *receiver, const char *slot, TDEActionCollection *parent, const char *name, TQWidget *wparent,uint options
			, const TQString &tagBegin, const TQString &tagEnd = TQString(), int dx=0, int dy=0, const TQString &description = TQString(), const TQString &hint = TQString(), const TQString &alter = TQString());

	InputTag(KileInfo* ki, const TQString &text, const TDEShortcut &cut, const TQObject *receiver, const char *slot, TDEActionCollection *parent, const char *name, TQWidget *wparent,uint options
			, const TagData& data, const TQString &hint = TQString(), const TQString &alter = TQString());

	InputTag(KileInfo* ki, const TQString &text, const TQString& pix, const TDEShortcut &cut, const TQObject *receiver, const char *slot, TDEActionCollection *parent, const char *name, TQWidget *wparent,uint options
			, const TagData& data, const TQString &hint = TQString(), const TQString &alter = TQString());

	~InputTag();

	bool hasHistory() {return (m_options & KeepHistory); }
	bool hasAlternative() { return (m_options & ShowAlternative); }
	bool hasBrowseButton() { return (m_options & ShowBrowseButton); }

	void addToHistory(const TQString& str) { if ( m_history.first() != str ) m_history.prepend(str); }

private:
	void init();

private slots:
	//emits the activated(TagData) signal
	virtual void emitData();

private:
	KileInfo	*m_ki;
	TQStringList			m_history;
	TQWidget				*m_parent;
	uint				m_options;
	TQString				m_hint;
	TQString				m_alter;
};


/*
	InputDialog
*/
class InputDialog : public KDialogBase
{
	TQ_OBJECT
  

public:
	InputDialog(const TQString &caption, uint options, const TQStringList& history, const TQString &hint, const TQString &alter, KileInfo *ki, TQWidget *parent=0, const char *name=0);
	~InputDialog();

	bool useAlternative() {return m_useAlternative;}
	bool useLabel() {return m_useLabel;}
	bool useAddProjectFile() {return m_useAddProjectFile;}

public slots:
	void slotBrowse();
	void slotAltClicked();

	void setTag(const TQString&);

signals:
	void setInput(const TQString&);

public:
	TQString tag() { return m_tag; }
	TQString label();
	bool usedSelection() { return m_usedSelection; }
	
	KLineEdit *m_edLabel;

private:
	TQString	m_tag;
	TQString	m_labelprefix;
	bool		m_useAlternative,m_useLabel,m_usedSelection,m_useAddProjectFile;
	KileInfo	*m_ki;
};

class Select : public TDESelectAction
{
	TQ_OBJECT
  

public:
	//constructors
	Select(const TQString &text, const TDEShortcut &cut, TDEActionCollection *parent, const char *name);

private:
	void init();

signals:
	void activated(const TDEAction&);

public slots:
	void setItems(TQPtrList<TDEAction> &);

private slots:
	void emitData(const TQString&);

private:
	TQDict<TDEAction> m_dict;
};

}

#endif

