/***************************************************************************
    date                 : Feb 15 2007
    version              : 0.34
    copyright            : (C) 2005-2007 by Holger Danielsson
    email                : holger.danielsson@versanet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QUICKPREVIEW_H
#define QUICKPREVIEW_H

#include "kileinfo.h"
#include "kiletool.h"
#include "kileedit.h"
#include "previewwidget.h"

#include <tqobject.h> 
#include <tqstring.h>
#include <tqstringlist.h>

namespace KileTool
{
enum { qpSelection=0, qpEnvironment, qpSubdocument, qpMathgroup };

class QuickPreview : public TQObject
{
	Q_OBJECT
  

public:
	QuickPreview(KileInfo *ki);
	~QuickPreview();
	
	bool run(const TQString &text,const TQString &textfilename,int startrow);
	bool isRunning();

	void previewEnvironment(Kate::Document *doc);
	void previewSelection(Kate::Document *doc, bool previewInWidgetConfig=true);
	void previewSubdocument(Kate::Document *doc);
	void previewMathgroup(Kate::Document *doc);
  
  /**
   * run (text, textfilename, startrow) works with the 
   * default configuration for QuickPreview. This method
   * supports a forth parameter to choose the configuration as
   * comma - separated string as you can see them in run (text, textfilename, startrow)
   *
   * It is also possible not to specify a viewer, so the viewer is not
   * executed.
   *
   * @param text         Text to preview
   * @param textfilename Filename of the document
   * @param startrow     Position of preview text in the document
   * @param spreviewlist user defined configuration, e.g. "PreviewLaTeX,DVItoPS,,,ps" (with no preview)
   * @return             true if method succeeds, else false
   */
	bool run (const TQString &text, const TQString &textfilename, int startrow, const TQString &spreviewlist);
	void getTaskList(TQStringList &tasklist);
  
  /**
   * QuickPreview uses temporary files for processing the output. 
   * If you want to work with files from QuickPreview, you 
   * can use this method. The method run returns true, and then
   * you can get the generated ps e.g. with getPreviewFile ("eps");
   * It works with all extensions which are generated while running
   * the corresponding tools (e.g. tex, dvi, ps, pdf, ...)
   *
   * @param  extension defines which file to use
   * @return           The temporary file with extension
   */
	TQString getPreviewFile(const TQString &extension); 
	
private slots:
	void toolDestroyed();

private:
	enum { pvLatex=0, pvDvips=1, pvDvipsCfg=2, pvViewer=3, pvViewerCfg=4, pvExtension=5 };
	
	KileInfo *m_ki;
	TQString m_tempfile;
	TQStringList m_taskList;
	int m_running;
		
	int createTempfile(const TQString &text);
	void removeTempFiles(bool rmdir=false);
	void showError(const TQString &text);
};

}

#endif
