/***************************************************************************
    begin                : Die Sep 16 2003
    copyright            : (C) 2003 by Jeroen Wijnhout
    email                : wijnhout@science.uva.nl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef OUTPUTFILTER_H
#define OUTPUTFILTER_H

#include <tqvaluestack.h>
#include <tqstring.h>
#include <tqwidget.h>

#include "outputinfo.h"

/**An object of this class is used to parse the output messages
of any third-party tool.
 
@author Thorsten Lck
  *@author Jeroen Wijnhout
  */

class KTextEdit;

class OutputFilter : public TQObject
{
    Q_OBJECT
  

public:
    OutputFilter();
    virtual ~OutputFilter();

protected:

public:
    virtual bool Run(const TQString & logfile);

    //void setLog(const TQString &log) { m_log = log; }
    const TQString & log() const { return m_log; }

    void setSource(const TQString &src);
    const TQString & source() const  { return m_source; }
    const TQString & path() const { return m_srcPath; }

signals:
    void problem(int, const TQString &);
    void output(const TQString &);

protected:
    virtual short parseLine(const TQString & strLine, short dwCookie);
    virtual bool OnTerminate();
    /**
    Returns the zero based index of the currently parsed line in the
    output file.
    */
    int GetCurrentOutputLine() const;

private:
    /** Number of current line in output file */
    unsigned int		m_nOutputLines;
    TQString		m_log, m_source, m_srcPath;
};
#endif
