/* This file is part of the Keep project
   Copyright (C) 2006 Jean-Rémy Falleri <jr.falleri@laposte.net>

   Keep is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   Keep is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Keep; if not, write to the
   Free Software Foundation, Inc.,
   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           */

#include "incrementlistviewitem.h"

#include <tdelocale.h>
#include <tqdir.h>
#include <tdelistview.h>

IncrementListViewItem::IncrementListViewItem(TDEListView *parent,TQDateTime date): TQListViewItem (parent) 
{ 
	setDate(date);
}

IncrementListViewItem::IncrementListViewItem(TDEListView *parent,TQListViewItem *item,TQDateTime date): TQListViewItem (parent,item) 
{ 
	setDate(date);
}


IncrementListViewItem::~IncrementListViewItem()
{
}

TQDateTime IncrementListViewItem::date()
{
	return m_date;
}

void IncrementListViewItem::setDate(TQDateTime date)
{
	m_date = date;
	setDateText();
}

void IncrementListViewItem::setDateText()
{
	setText(0, m_date.toString(TQt::LocalDate) );
}


