/*
 * status.h
 * Copyright (C) 1999 Kurt Granroth <granroth@kde.org>
 *
 * This file contains the declaration of the KBiffStatus
 * widget.
 *
 * $Id$
 */
#ifndef KBIFFSTATUS_H 
#define KBIFFSTATUS_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <ntqframe.h>
#include <ntqptrlist.h>
#include <ntqstring.h>

class TQListView;
class TQPoint;

class KBiffStatusItem : TQObject
{
    Q_OBJECT
public:
	KBiffStatusItem(const TQString& mailbox, const int num_new);
	KBiffStatusItem(const TQString& mailbox, const int num_new,const int num_cur);
	virtual ~KBiffStatusItem();

	TQString mailbox() const { return _mailbox; }
	TQString newMessages() const { return _newMessages; }
	TQString curMessages() const { return _curMessages; }

protected:
	TQString _mailbox;
	TQString _newMessages;
	TQString _curMessages;
};

typedef TQPtrList<KBiffStatusItem>         KBiffStatusList;
typedef TQPtrListIterator<KBiffStatusItem> KBiffStatusListIterator;

class KBiffStatus : public TQFrame
{
	Q_OBJECT
public:
	KBiffStatus(TQWidget *parent, const TQString& profile, const KBiffStatusList& list);
	virtual ~KBiffStatus();

	void updateListView(const KBiffStatusList& list);
	void popup(const TQPoint& pos);

protected:
	TQListView *_listView;
};

#endif // KBIFFSTATUS_H
