/*
 * klameenc.h
 *
 * Copyright (C) 2006 Christophe Thommeret <hftom@free.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef KLAMEENC_H
#define KLAMEENC_H

#include <lame/lame.h>

#include <tdeconfig.h>

#include "kaffeineaudioencoder.h"
#include "lameconfig.h"

class LameSettings : public LameConfig
{
	TQ_OBJECT
  
public:
	LameSettings( TQWidget *parent, TDEConfig *confile );
	~LameSettings();

	int getBitrate();
	bool isVBR();

public slots:
	virtual void accept();

private:
	TDEConfig *Conf;
};

class KLameEnc : public KaffeineAudioEncoder
{
	TQ_OBJECT
  

public:

	KLameEnc( TQWidget*, const char*, TQObject*, const char*, const TQStringList& );
	~KLameEnc();

	// Reimplemented from KaffeineAudioEncoder
	bool options( TQWidget*, TDEConfig* );
	TQString getExtension();
	void start( TQString title=0, TQString artist=0, TQString album=0, TQString tracknumber=0, TQString genre=0 );
	char* getHeader( int &len );
	char* encode( char *data, int datalen, int &len );
	char* stop( int &len );
	//****************************

	static TDEAboutData* createAboutData();

private:

	char bufEncode[8000];
	lame_global_flags *flags;
	int bitrate;
	bool vbr;
};

#endif /* KLAMEENC_H */
