//
// C++ Interface: 
//
// Description: 
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef K9MENCODERCMDGEN_H
#define K9MENCODERCMDGEN_H

#include "mencoderCmdGen.h"
#include <tqscrollview.h>
#include <tqgrid.h>
#include <tqdom.h>
#include <tqlayout.h>
#include <tqlistview.h>
#include <tqhbox.h>
class _k9CheckListItem;

class k9MencoderCmdGen : public MyDialog1
{
  Q_OBJECT
  

public:
  k9MencoderCmdGen(TQWidget* parent, const TQString &_cmd, bool modal = FALSE, WFlags fl = 0 );
  ~k9MencoderCmdGen();
  /*$PUBLIC_FUNCTIONS$*/
  static bool getMencoderOptions(TQString &_cmd);
public slots:
  /*$PUBLIC_SLOTS$*/
private:
   TQScrollView *m_scrollView;
   TQGrid *m_grid;
   TQGrid *m_hbox;
   int m_row,m_page,m_cpt;
   TQDomDocument m_doc;
   TQString m_cmd;

   void addWidgets(_k9CheckListItem *_item,TQString _root,TQString _cat);
   void loadXml();
   void fillListView();
   void addInt(TQDomElement _eOpt);
   void addFloat(TQDomElement _eOpt);
   void addBool(TQDomElement _eOpt);
   void addString(TQDomElement _eOpt);
   void addList(TQDomElement _eOpt);

   const TQString & getCmd(const TQString &_root);
   void selectCodec(const TQString &_root,const TQString &_codec);
   void parseCodecOptions(const TQString &_root,const TQString &_codec,const TQString & _options);
   void parseCmd(const TQString &_cmd);

protected:
  /*$PROTECTED_FUNCTIONS$*/

protected slots:
  /*$PROTECTED_SLOTS$*/
    void listViewCurrentChanged(TQListViewItem*);
};

#endif

