/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2007-01-30
 * Description : a button bar to navigate between album items
 *               using status bar.
 *
 * Copyright (C) 2007 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// TQt includes.

#include <tqlayout.h>
#include <tqtoolbutton.h>
#include <tqtooltip.h>

// KDE includes.

#include <kiconloader.h>
#include <tdelocale.h>

// Local includes.

#include "statusnavigatebar.h"
#include "statusnavigatebar.moc"

namespace Digikam
{

class StatusNavigateBarPriv
{
public:

    StatusNavigateBarPriv()
    {
        firstButton = 0;
        prevButton  = 0;
        nextButton  = 0;
        lastButton  = 0;
        itemType    = StatusNavigateBar::ItemCurrent;
    }

    int          itemType;

    TQToolButton *firstButton;
    TQToolButton *prevButton;
    TQToolButton *nextButton;
    TQToolButton *lastButton;
};

StatusNavigateBar::StatusNavigateBar(TQWidget *parent)
                 : TQWidget(parent, 0, TQt::WDestructiveClose)
{
    d = new StatusNavigateBarPriv;
    setFocusPolicy(TQWidget::NoFocus);

    TQHBoxLayout *lay = new TQHBoxLayout(this);

    d->firstButton = new TQToolButton(this);
    d->firstButton->setFocusPolicy(TQWidget::NoFocus);
    d->firstButton->setAutoRaise(true);
    d->firstButton->setIconSet(SmallIconSet("go-first"));
    TQToolTip::add(d->firstButton, i18n("Go to the first item"));

    d->prevButton = new TQToolButton(this);
    d->prevButton->setFocusPolicy(TQWidget::NoFocus);
    d->prevButton->setAutoRaise(true);
    d->prevButton->setIconSet(SmallIconSet("back"));
    TQToolTip::add(d->prevButton, i18n("Go to the previous item"));

    d->nextButton = new TQToolButton(this);
    d->nextButton->setFocusPolicy(TQWidget::NoFocus);
    d->nextButton->setAutoRaise(true);
    d->nextButton->setIconSet(SmallIconSet("forward"));
    TQToolTip::add(d->nextButton, i18n("Go to the next item"));

    d->lastButton = new TQToolButton(this);
    d->lastButton->setFocusPolicy(TQWidget::NoFocus);
    d->lastButton->setAutoRaise(true);
    d->lastButton->setIconSet(SmallIconSet("go-last"));
    TQToolTip::add(d->lastButton, i18n("Go to the last item"));

    lay->addWidget(d->firstButton);
    lay->addWidget(d->prevButton);
    lay->addWidget(d->nextButton);
    lay->addWidget(d->lastButton);

    connect(d->firstButton, TQT_SIGNAL(clicked()),
            this, TQT_SIGNAL(signalFirstItem()));

    connect(d->prevButton, TQT_SIGNAL(clicked()),
            this, TQT_SIGNAL(signalPrevItem()));

    connect(d->nextButton, TQT_SIGNAL(clicked()),
            this, TQT_SIGNAL(signalNextItem()));

    connect(d->lastButton, TQT_SIGNAL(clicked()),
            this, TQT_SIGNAL(signalLastItem()));
}

StatusNavigateBar::~StatusNavigateBar()
{
    delete d;
}

void StatusNavigateBar::setNavigateBarState(bool hasPrev, bool hasNext)
{
    if (hasPrev && hasNext)
        setButtonsState(ItemCurrent);
    else if (!hasPrev && hasNext)
        setButtonsState(ItemFirst);
    else if (hasPrev && !hasNext)
        setButtonsState(ItemLast);
    else
        setButtonsState(NoNavigation);
}

void StatusNavigateBar::setButtonsState(int itemType)
{
    d->itemType = itemType;

    if (d->itemType == ItemFirst)
    {
       d->firstButton->setEnabled(false);
       d->prevButton->setEnabled(false);
       d->nextButton->setEnabled(true);
       d->lastButton->setEnabled(true);
    }
    else if (d->itemType == ItemLast)
    {
       d->firstButton->setEnabled(true);
       d->prevButton->setEnabled(true);
       d->nextButton->setEnabled(false);
       d->lastButton->setEnabled(false);
    }
    else if (d->itemType == ItemCurrent)
    {
       d->firstButton->setEnabled(true);
       d->prevButton->setEnabled(true);
       d->nextButton->setEnabled(true);
       d->lastButton->setEnabled(true);
    }
    else if (d->itemType == NoNavigation)
    {
       d->firstButton->setEnabled(false);
       d->prevButton->setEnabled(false);
       d->nextButton->setEnabled(false);
       d->lastButton->setEnabled(false);
    }
}

int StatusNavigateBar::getButtonsState()
{
    return (d->itemType);
}

}  // namespace Digikam

