#ifndef ABAKUS_VALUEMANAGER_H
#define ABAKUS_VALUEMANAGER_H
/*
 * valuemanager.h - part of abakus
 * Copyright (C) 2004, 2005 Michael Pyne <michael.pyne@kdemail.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <tqobject.h>
#include <tqmap.h>
#include <tqstring.h>
#include <tqstringlist.h>

#include "numerictypes.h"

class ValueManager : public TQObject
{
    Q_OBJECT
  
    public:
    typedef TQMap<TQString, Abakus::number_t> valueMap;

    static ValueManager *instance();

    Abakus::number_t value(const TQString &name) const;

    bool isValueSet(const TQString &name) const;
    bool isValueReadOnly(const TQString &name) const;

    void setValue(const TQString &name, const Abakus::number_t value);
    void removeValue(const TQString &name);

    TQStringList valueNames() const;

    /**
     * Returns a textual description of a constant built-into abakus.
     */
    static TQString description(const TQString &valueName);

    signals:
    void signalValueAdded(const TQString &name, Abakus::number_t value);
    void signalValueRemoved(const TQString &name);
    void signalValueChanged(const TQString &name, Abakus::number_t newValue);

    public slots:
    void slotRemoveUserVariables();

    private:
    ValueManager(TQObject *parent = 0, const char *name = "value manager");

    static ValueManager *m_manager;
    valueMap m_values;
};

#endif
