/***************************************************************************
 *   Copyright (C) 2004 by David Sansome                                   *
 *   me@davidsansome.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.              *
 ***************************************************************************/
#ifndef RCPARSER_H
#define RCPARSER_H

#include <ntqstringlist.h>
#include <ntqmap.h>

class RcParser
{
public:
	RcParser();
	~RcParser();
	
	void addSearchDir(TQString dir);
	bool openFile(TQString name);
	
	TQStringList sectionList();
	void setSection(TQString section);
	
	TQString readString(TQString key, TQString def=TQString::null);
	int readInt(TQString key, int def=0);
	bool readBool(TQString key, bool def=false);
	TQStringList readList(TQString key);
	
private:
	TQStringList dirs;
	TQString fileName;
	TQString currentSection;
	TQMap< TQString, TQMap< TQString, TQString> > sections;
};

#endif
