/***************************************************************************
** $Id: tork_plug_in.cpp,v 1.4 2008/07/31 19:56:28 hoganrobert Exp $
 *   Copyright (C) 2006 - 2008 Robert Hogan                                *
 *   robert@roberthogan.net                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.              *
 ***************************************************************************/

/***************************************************************************
                          kget_plug_in.cpp  -  description
                             -------------------
    begin                : Wed Jul  3 22:09:28 CEST 2002
    copyright            : (C) 2002 by Patrick
    email                : pch@valleeurpe.net
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "tork_plug_in.h"

#include <dcopref.h>
#include <kdatastream.h>
#include <kdebug.h>
#include <tdehtml_part.h>
#include <kiconloader.h>
#include <tdeglobal.h>
#include <tdeaction.h>
#include <kinstance.h>
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <tdepopupmenu.h>
#include <krun.h>

#include <dom/html_document.h>
#include <dom/html_misc.h>
#include <dom/dom_element.h>

#include <tdeparts/partmanager.h>

#include <set>


Tork_plug_in::Tork_plug_in( TQObject* parent, const char* name )
    : Plugin( parent, name )
{
    TQPixmap pix = TDEGlobal::iconLoader()->loadIcon("tork",
                                                  TDEIcon::MainToolbar);
    TDEActionMenu *menu = new TDEActionMenu( i18n("Anonymity Manager"), pix,
                                         actionCollection(), "tork_menu" );
    menu->setDelayed( false );
    connect( menu->popupMenu(), SIGNAL( aboutToShow() ), SLOT( showPopup() ));

    m_paToggleTDE=new TDEAction(i18n("Anonymize TDE"),
                                           TDEGlobal::iconLoader()->loadIconSet("tork_konqueroroff",                                               TDEIcon::Small),
                                           TDEShortcut(),
                                           this, SLOT(toggleTDE()),
                                           actionCollection(), "tork_konqueroron" );

    menu->insert( m_paToggleTDE );


    TDEAction *m_firefox=new TDEAction(i18n("Re-Open Anonymously with Firefox"),
                                           TDEGlobal::iconLoader()->loadIconSet("tork_firefox",                                               TDEIcon::Small),
                                           TDEShortcut(),
                                           this, SLOT(openWithFirefox()),
                                           actionCollection(), "tork_firefox" );
    menu->insert( m_firefox );

    TDEAction *m_opera=new TDEAction(i18n("Re-Open Anonymously with Opera"),
                                           TDEGlobal::iconLoader()->loadIconSet("tork_opera",                                               TDEIcon::Small),
                                           TDEShortcut(),
                                           this, SLOT(openWithOpera()),
                                           actionCollection(), "tork_opera" );
    menu->insert( m_opera );

    p_dcopServer= new DCOPClient();
    p_dcopServer->attach ();
}


Tork_plug_in::~Tork_plug_in()
{
    p_dcopServer->detach();
    delete p_dcopServer;
}


void Tork_plug_in::showPopup()
{
    bool anonymized = false;

    if (p_dcopServer->isApplicationRegistered ("tork"))
    {
        DCOPRef tork( "tork", "DCOPTork" );
        anonymized = tork.call( "getTDESetting" );
    }

    if (anonymized){
        m_paToggleTDE->setIconSet( TDEGlobal::iconLoader()->loadIconSet("tork_konqueroroff",
                                                  TDEIcon::Small) );
        m_paToggleTDE->setText( "De-Anonymize TDE" );
    }else{
        m_paToggleTDE->setIconSet( TDEGlobal::iconLoader()->loadIconSet("tork_konqueroron",
                                                  TDEIcon::Small) );
        m_paToggleTDE->setText( "Anonymize TDE" );
    }
}

void Tork_plug_in::openWithFirefox()
{

    openWithBrowser("Firefox");

}

void Tork_plug_in::openWithOpera()
{

    openWithBrowser("Opera");

}

void Tork_plug_in::openWithBrowser(const TQString &browser)
{
    TDEHTMLPart *htmlPart = static_cast<TDEHTMLPart*>( parent() );
    TQString url = htmlPart->toplevelURL().url();

    if (p_dcopServer->isApplicationRegistered ("tork")){
        TQString function = TQString("anonymized%1").arg(browser);
        DCOPRef("tork", "DCOPTork").send("startEverything");
        DCOPRef("tork", "DCOPTork").send(TQCString(function),url);
    }else
        KRun::runCommand( TQString("tork --anonymous%1 %2").arg(browser).arg(url), "tork", "tork" );

}

void Tork_plug_in::toggleTDE()
{
    if (!p_dcopServer->isApplicationRegistered ("tork"))
        KRun::runCommand("tork --toggleTDE");
    else
    {
        DCOPRef tork( "tork", "DCOPTork" );
        tork.send( "toggleTDESetting");
    }
}


KPluginFactory::KPluginFactory( TQObject* parent, const char* name )
        : KLibFactory( parent, name )
{
    s_instance = new TDEInstance("KPluginFactory");
}

TQObject* KPluginFactory::createObject( TQObject* parent, const char* name, const char*, const TQStringList & )
{
    TQObject *obj = new Tork_plug_in( parent, name );
    return obj;
}

KPluginFactory::~KPluginFactory()
{
    delete s_instance;
}

extern "C"
{
    KDE_EXPORT void* init_tdehtml_tork()
    {
        TDEGlobal::locale()->insertCatalogue("tork");
        return new KPluginFactory;
    }

}

TDEInstance* KPluginFactory::s_instance = 0L;

#include "tork_plug_in.moc"
