/***************************************************************************
 *   Copyright (C) 2004 by David Sansome                                   *
 *   me@davidsansome.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.              *
 ***************************************************************************/
#include "rcparser.h"

#include <ntqregexp.h>
#include <ntqfile.h>
#include <ntqtextstream.h>

RcParser::RcParser()
{
}


RcParser::~RcParser()
{
}

void RcParser::addSearchDir(TQString dir)
{
	dirs.append(dir);
}

bool RcParser::openFile(TQString name)
{
	// Check if it exists
	fileName = "";
	for ( TQStringList::Iterator it = dirs.begin(); it != dirs.end(); ++it )
	{
		if (TQFile::exists((*it) + "/" + name))
		{
			fileName = (*it) + "/" + name;
			break;
		}
	}
	
	if (fileName.isEmpty())
		return false;
	
	// Clear the current data
	sections.clear();
	
	// Read the file's contents
	TQFile file(fileName);
	file.open(IO_ReadOnly);
	TQTextStream stream(&file);
	
	TQRegExp sectionRegExp("^\\[([^\\]]*)\\]$");
	TQRegExp pairRegExp("^([^=\\s]*)([=\\s]*)(.*)$");
	currentSection = "RcParserDefaultSection";
	
	while (!stream.atEnd())
	{
		TQString line = stream.readLine();
		if (line.left(1) == "#") // Comment
			continue;
		
		line = line.stripWhiteSpace();
		
		if (sectionRegExp.search(line) != -1)
		{
			currentSection = sectionRegExp.cap(1);
			//printf("Found section \"%s\"\n", currentSection.latin1());
			continue;
		}
		if (pairRegExp.search(line) != -1)
		{
			TQString key = pairRegExp.cap(1);
			TQString value = pairRegExp.cap(3);
			sections[currentSection][key] = value;
			//printf("Found pair \"%s\" = \"%s\"\n", key.latin1(), value.latin1());
			continue;
		}
		
		// Parse error, ignore the line
	}
	
	currentSection = "RcParserDefaultSection";
	return true;
}

void RcParser::setSection(TQString section)
{
	currentSection = section;
}

TQStringList RcParser::sectionList()
{
	return sections.keys();
}

TQString RcParser::readString(TQString key, TQString def)
{
	TQString ret = sections[currentSection][key];
	if (ret.isEmpty())
		return def;
	return ret;
}

int RcParser::readInt(TQString key, int def)
{
	bool ok;
	int ret = sections[currentSection][key].toInt(&ok);
	if (!ok)
		return def;
	return ret;
}

bool RcParser::readBool(TQString key, bool def)
{
	bool ret = def;
	if (sections[currentSection][key].lower() == "true")
		ret = true;
	if (sections[currentSection][key].lower() == "false")
		ret = false;
	if (sections[currentSection][key] == "1")
		ret = true;
	if (sections[currentSection][key] == "0")
		ret = false;
	return ret;
}

TQStringList RcParser::readList(TQString key)
{
	return TQStringList::split(",", sections[currentSection][key]);
}




