/***************************************************************************
 *   Copyright (C) 2004 by David Sansome                                   *
 *   me@davidsansome.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.              *
 ***************************************************************************/
#ifndef WIZARD_H
#define WIZARD_H

#include <tqlistview.h>
#include <tqprocess.h>
#include <tqsettings.h>
#include <tqiconview.h>
#include <tqregexp.h>
#include <tqvaluevector.h>
#include <tqstring.h>

#include <wizardbase.h>

#include <stdio.h>

#include "logdialog.h"

class HeaderListItem;

struct Component
{
	TQString name;
	TQString niceName;
	TQString subDir;
	TQString forceDir;
	bool optional;
	bool kdeOnly;
	bool gnomeOnly;
	TQString description;
	TQString confOptions;
	
	TQMap<TQString, uint> buildTimes;
	
	bool alreadyInstalled;
};

class ComponentListItem : public TQCheckListItem
{
public:
	ComponentListItem(struct Component c, TQListView* parent);
	int compare(TQListViewItem* i, int col, bool ascending) const;
	int rtti() const { return 1001; }
	
	struct Component component;
	int section;
};

class ActionFormat
{
public:
	ActionFormat() {}
	ActionFormat(TQString a, TQString t, TQString r, int) { action=a; tool=t; regExp=r; }
	~ActionFormat() {}
	
	TQString action;
	TQString tool;
	TQRegExp regExp;
};


class CompileError
{
public:
    CompileError() {}
    CompileError( const TQString& type, const TQString& message )
        : t( type ), m( message )
    { }

    TQString type()   const          { return t; }
    TQString message()   const          { return m; }
private:
    TQString t;
    TQString m;
};



class Wizard : public WizardBase
{
	Q_OBJECT
	
public:
	Wizard(TQWidget *parent = 0, const char *name = 0);
	
	~Wizard();

	
private:
	void createActionFormats();
	void startProcess();
	void nextStep();
	void checkPassword();
	
	void updateTime(TQString key);
	TQString lastTimeLine;
	
	void logLine(TQString line);
	void errorOccured();
	TQString makeDirNice(TQString name);
	
	TQString sub(TQString s);
	
	TQString rootPassword;
	
private slots:
	void processExited();
	void readyReadStdout();
	void readyReadStderr();
	void kdeDirReady();
	void getInstalledComponents();
	void installedComponentsReady();
	
	void cancelPressed();
	void nextPressed();
	void previousPressed();
	void runPressed();
	void logPressed();
	void componentSelected(TQListViewItem* item);
	void setProgress2Text(TQString text);
	
	void setup();
	void setupFromRc();
	bool setupFromDir();

private:
	enum Stage
	{
		None,
		Autogen,
		Configure,
		Compile,
		Install,
		WriteUninstallInfo
	};
	
	TQString dir;
	TQStringList buildOrder;
	TQValueList<struct Component> selectedComponents;
	uint totalBTime;
	uint elapsedBTime;
	uint elapsedTime;
	TQTime timer;
	TQProcess* externalProcess;
	TQProcess* kdeDirProcess;
	TQProcess* installedComponentsProcess;
	TQString commandLine;
	bool currentIsTQMake;
	uint currentComponent;
	enum Stage currentStage;
	bool needRoot;
	TQString prefix;
	
	TQStringList installedComponents;
	TQString exec;
	TQString desktop;
	
	TQString kdeDir;
	
	LogDialog* logDialog;
	
	TQMap<int, HeaderListItem*> headers;
	TQValueList<ActionFormat> actionFormats;
	TQStringList installedFiles;

};

#endif
