/***************************************************************************
 *   Copyright (C) 2006 by Sebastien Laout                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.         *
 ***************************************************************************/

#ifndef LIKEBACK_PRIVATE_H
#define LIKEBACK_PRIVATE_H

#include <tqtimer.h>

#include <kdialogbase.h>

#include "likeback.h"

class TQToolButton;
class TQTextEdit;
class TQCheckBox;
class TQButtonGroup;
class Kaction;

class LikeBackPrivate
{
  public:
	LikeBackPrivate();
	~LikeBackPrivate();
	LikeBackBar             *bar;
	TDEConfig                 *config;
	const TDEAboutData        *aboutData;
	LikeBack::Button         buttons;
	TQString                  hostName;
	TQString                  remotePath;
	TQ_UINT16                 hostPort;
	TQStringList              acceptedLocales;
	TQString                  acceptedLanguagesMessage;
	LikeBack::WindowListing  windowListing;
	bool                     showBarByDefault;
	bool                     showBar;
	int                      disabledCount;
	TQString                  fetchedEmail;
	TDEAction                 *action;
};

class LikeBackBar : public TQWidget
{
  Q_OBJECT
  public:
	LikeBackBar(LikeBack *likeBack);
	~LikeBackBar();
  public slots:
	void startTimer();
	void stopTimer();
  private slots:
	void autoMove();
	void clickedLike();
	void clickedDislike();
	void clickedBug();
	void clickedFeature();
  private:
	LikeBack    *m_likeBack;
	TQTimer       m_timer;
	TQToolButton *m_likeButton;
	TQToolButton *m_dislikeButton;
	TQToolButton *m_bugButton;
	TQToolButton *m_featureButton;
};

class LikeBackDialog : public KDialogBase
{
  Q_OBJECT
  public:
	LikeBackDialog(LikeBack::Button reason, const TQString &initialComment, const TQString &windowPath, const TQString &context, LikeBack *likeBack);
	~LikeBackDialog();
  private:
	LikeBack     *m_likeBack;
	TQString       m_windowPath;
	TQString       m_context;
	TQButtonGroup *m_group;
	TQTextEdit    *m_comment;
	TQCheckBox    *m_showButtons;
	TQString introductionText();
  private slots:
	void polish();
	void slotDefault();
	void slotOk();
	void changeButtonBarVisible();
	void commentChanged();
	void send();
	void requestFinished(int id, bool error);
};

#endif // LIKEBACK_PRIVATE_H
