/***************************************************************************
    copyright            : (C) 2003-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#include "stringmapdialog.h"

#include <tdelistview.h>
#include <tdelocale.h>
#include <klineedit.h>
#include <kbuttonbox.h>
#include <kiconloader.h>

#include <tqlayout.h>
#include <tqheader.h>
#include <tqhbox.h>
#include <tqwhatsthis.h>
#include <tqpushbutton.h>

using Tellico::StringMapDialog;

StringMapDialog::StringMapDialog(const TQMap<TQString, TQString>& map_, TQWidget* parent_, const char* name_/*=0*/, bool modal_/*=false*/)
    : KDialogBase(parent_, name_, modal_, TQString(), Ok|Cancel) {
  TQWidget* page = new TQWidget(this);
  TQVBoxLayout* l = new TQVBoxLayout(page, 0, KDialog::spacingHint());

  m_listView = new TDEListView(page);
  m_listView->setAllColumnsShowFocus(true);
  m_listView->setShowSortIndicator(true);
  m_listView->addColumn(TQString());
  m_listView->addColumn(TQString());
  m_listView->header()->hide(); // hide header since neither column has a label initially
  m_listView->setColumnWidthMode(0, TQListView::Maximum);
  m_listView->setColumnWidthMode(1, TQListView::Maximum);
  m_listView->setResizeMode(TQListView::AllColumns);
  connect(m_listView, TQT_SIGNAL(currentChanged(TQListViewItem*)), TQT_SLOT(slotUpdate(TQListViewItem*)));
  connect(m_listView, TQT_SIGNAL(clicked(TQListViewItem*)), TQT_SLOT(slotUpdate(TQListViewItem*)));
  l->addWidget(m_listView);

  TQHBox* box = new TQHBox(page);
  box->setMargin(4);
  box->setSpacing(KDialog::spacingHint());

  m_edit1 = new KLineEdit(box);
  m_edit1->setFocus();
  m_edit2 = new KLineEdit(box);
  KButtonBox* bb = new KButtonBox(box);
  bb->addStretch();
  TQPushButton* btn = bb->addButton(i18n("&Set"), TQT_TQOBJECT(this), TQT_SLOT(slotAdd()));
  btn->setIconSet(BarIcon(TQString::fromLatin1("document-new"), TDEIcon::SizeSmall));
  btn = bb->addButton(i18n("&Delete"), TQT_TQOBJECT(this), TQT_SLOT(slotDelete()));
  btn->setIconSet(BarIcon(TQString::fromLatin1("edit-delete"), TDEIcon::SizeSmall));

  l->addWidget(box);
  l->addStretch(1);
  setMainWidget(page);

  for(TQMap<TQString, TQString>::ConstIterator it = map_.begin(); it != map_.end(); ++it) {
    if(!it.data().isEmpty()) {
      (void) new TDEListViewItem(m_listView, it.key(), it.data());
    }
  }

  setMinimumWidth(400);
  enableButtonSeparator(true);
}

void StringMapDialog::slotAdd() {
  TQString s1 = m_edit1->text();
  TQString s2 = m_edit2->text();
  if(s1.isEmpty() && s2.isEmpty()) {
    return;
  }
  TQListViewItem* item = m_listView->currentItem();
  if(item && s1 == item->text(0)) { // only update values if same key
    item->setText(1, s2);
  } else {
    item = new TDEListViewItem(m_listView, s1, s2);
  }
  m_listView->ensureItemVisible(item);
  m_listView->setSelected(item, true);
  m_listView->setCurrentItem(item);
}

void StringMapDialog::slotDelete() {
  delete m_listView->currentItem();
  m_edit1->clear();
  m_edit2->clear();
  m_listView->setSelected(m_listView->currentItem(), true);
}

void StringMapDialog::slotUpdate(TQListViewItem* item_) {
  if(item_) {
    m_edit1->setText(item_->text(0));
    m_edit2->setText(item_->text(1));
    m_listView->header()->adjustHeaderSize();
  } else {
    m_edit1->clear();
    m_edit2->clear();
  }
}

void StringMapDialog::setLabels(const TQString& label1_, const TQString& label2_) {
  m_listView->header()->setLabel(0, label1_);
  m_listView->header()->setLabel(1, label2_);
  m_listView->header()->show();
}

TQMap<TQString, TQString> StringMapDialog::stringMap() {
  TQMap<TQString, TQString> map;
  for(TQListViewItem* item = m_listView->firstChild(); item; item = item->nextSibling()) {
    map.insert(item->text(0), item->text(1));
  }
  return map;
}

#include "stringmapdialog.moc"
