/***************************************************************************
    copyright            : (C) 2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef YAHOOFETCHER_H
#define YAHOOFETCHER_H

namespace Tellico {
  class XSLTHandler;
}

#include "fetcher.h"
#include "configwidget.h"
#include "../datavectors.h"

#include <tqcstring.h> // for TQByteArray
#include <tqguardedptr.h>

namespace TDEIO {
  class Job;
}

namespace Tellico {
  namespace Fetch {

/**
 * @author Robby Stephenson
 */
class YahooFetcher : public Fetcher {
Q_OBJECT
  

public:
  /**
   */
  YahooFetcher(TQObject* parent, const char* name = 0);
  /**
   */
  virtual ~YahooFetcher();

  /**
   */
  virtual TQString source() const;
  virtual bool isSearching() const { return m_started; }
  virtual void search(FetchKey key, const TQString& value);
  virtual void continueSearch();
  virtual bool canSearch(FetchKey k) const { return k == Title || k == Person; }
  virtual void stop();
  virtual Data::EntryPtr fetchEntry(uint uid);
  virtual Type type() const { return Yahoo; }
  virtual bool canFetch(int type) const;
  virtual void readConfigHook(const TDEConfigGroup& config);

  virtual void updateEntry(Data::EntryPtr entry);

  /**
   * Returns a widget for modifying the fetcher's config.
   */
  virtual Fetch::ConfigWidget* configWidget(TQWidget* parent) const;

  class ConfigWidget : public Fetch::ConfigWidget {
  public:
    ConfigWidget(TQWidget* parent_, const YahooFetcher* fetcher = 0);
    virtual void saveConfig(TDEConfigGroup&) {}
    virtual TQString preferredName() const;
  };
  friend class ConfigWidget;

  static TQString defaultName();

private slots:
  void slotData(TDEIO::Job* job, const TQByteArray& data);
  void slotComplete(TDEIO::Job* job);

private:
  void initXSLTHandler();
  void doSearch();
  void getTracks(Data::EntryPtr entry);
  TQString insertValue(const TQString& str, const TQString& value, uint pos);

  XSLTHandler* m_xsltHandler;
  int m_limit;
  int m_start;
  int m_total;

  TQByteArray m_data;
  TQMap<int, Data::EntryPtr> m_entries; // they get modified after collection is created, so can't be const
  TQGuardedPtr<TDEIO::Job> m_job;

  FetchKey m_key;
  TQString m_value;
  bool m_started;
};

  } // end namespace
} // end namespace
#endif
