/***************************************************************************
    copyright            : (C) 2003-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef BIBTEXHANDLER_H
#define BIBTEXHANDLER_H

class TQString;
class TQStringList;
class TQRegExp;

#include "../datavectors.h"

#include <tqmap.h>

namespace Tellico {

/**
 * @author Robby Stephenson
 */
class BibtexHandler {
public:
  enum QuoteStyle { BRACES=0, QUOTES=1 };
  static TQStringList bibtexKeys(const Data::EntryVec& entries);
  static TQString bibtexKey(Data::ConstEntryPtr entry);
  static TQString importText(char* text);
  static TQString exportText(const TQString& text, const TQStringList& macros);
  static bool setFieldValue(Data::EntryPtr entry, const TQString& bibtexField, const TQString& value);
  /**
   * Strips the text of all vestiges of LaTeX.
   *
   * @param text A reference to the text
   * @return A reference to the text
   */
  static TQString& cleanText(TQString& text);

  static QuoteStyle s_quoteStyle;

private:
  typedef TQMap<TQString, TQStringList> StringListMap;

  static TQString bibtexKey(const TQString& author, const TQString& title, const TQString& year);
  static void loadTranslationMaps();
  static TQString& addBraces(TQString& string);

  static StringListMap* s_utf8LatexMap;
  static const TQRegExp s_badKeyChars;
};

} // end namespace
#endif
