/***************************************************************************
                          mapslistview.h  -  description
                             -------------------
    begin                : Weg Feb 26 2003
    copyright            : (C) 2003 by Jan Schfer
    email                : janschaefer@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _MAPSLISTVIEW_H_
#define _MAPSLISTVIEW_H_

#include <tqvbox.h>

#include "kimagemapeditor.h"
class TDEListView;

/**
 * Simple class that shows all map tags of the current open html file in a ListView
 * 
 * Jan Schaefer
 **/
class MapsListView : public TQVBox
{
Q_OBJECT
  
public:
  MapsListView(TQWidget *parent, const char *name);
  ~MapsListView();
  
  /**
   * Adds the given map to the ListView
   */
  void addMap(const TQString &);
  
  /**
   * Adds all maps of the given TQList to the ListView
   */
  void addMaps(TQPtrList<MapTag> *);
  
  /**
   * Removes the given map from the ListView
   */
  void removeMap(const TQString &);
  
  /**
   * Set the the given map selected in the ListView.
   * it does not emit mapSelected afterwards.
   */
  void selectMap(const TQString &);
  
  /**
   * Selects the given ListViewItem and deselects the current selected item
   */
  void selectMap(TQListViewItem* item);
  
  /**
   * Changes the name of the map with the @p oldName to @p newName 
   */
  void changeMapName(const TQString & oldName, const TQString & newName);
  
  /**
   * Returns the current selected map
   */
  TQString selectedMap();
  
  
  /**
   * Removes all maps from the ListView
   */
  void clear();
  
  /**
   * Returns a name for a map which is not used yet.
   * Returns for example Unnamed1 
   */
  TQString getUnusedMapName();
  
  /**
   * Wether or not the given map name already exists
   */
  bool nameAlreadyExists(const TQString &);
  
  /**
   * Returns a TQStringList of all maps
   */
  TQStringList getMaps();
  
  /**
   * Returns the number of maps
   */
  uint count();
  
  TDEListView* listView() { return _listView; }
protected:
  TDEListView* _listView;   

protected slots:
  void slotSelectionChanged(TQListViewItem*);  
  void slotItemRenamed(TQListViewItem*);
    
signals:

  /**
   * Gets emitted when the user selects a map in
   * the ListView
   */
  void mapSelected(const TQString &);  
  
  
  /**
   * Emitted when the user has renamed a map in the ListView
   */
  void mapRenamed(const TQString & newName);
  
  
};

#endif
