/**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#include "tqobjectlist.h"
#include "previewwidgetimpl.h"

PreviewWidget::PreviewWidget( TQWidget *parent, const char *name )
    : PreviewWidgetBase( parent, name )
{
    // install event filter on child widgets
    TQObjectList *l = queryList(TQWIDGET_OBJECT_NAME_STRING);
    TQObjectListIt it(*l);
    TQObject * obj;
    while ((obj = it.current()) != 0) {
        ++it;
        obj->installEventFilter(this);
	((TQWidget*)obj)->setFocusPolicy(TQ_NoFocus);
    }
}

void PreviewWidget::closeEvent(TQCloseEvent *e)
{
    e->ignore();
}

bool PreviewWidget::eventFilter(TQObject *, TQEvent *e)
{
    switch ( e->type() ) {
    case TQEvent::MouseButtonPress:
    case TQEvent::MouseButtonRelease:
    case TQEvent::MouseButtonDblClick:
    case TQEvent::MouseMove:
    case TQEvent::KeyPress:
    case TQEvent::KeyRelease:
    case TQEvent::Enter:
    case TQEvent::Leave:
	return true; // ignore;
    default:
	break;
    }
    return false;
}
#include "previewwidgetimpl.moc"
