/***************************************************************************
                         spinboxint.cpp - Integer spinbox widget 
                             -------------------
    copyright            : (C) 2002 by Marc Britton
    email                : consume@optusnet.com.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/* KDE INCLUDES */

/* QT INCLUDES */
#include <tqobject.h>
#include <tqstring.h>
#include <tqwidget.h>
#include <tqstringlist.h>
#include <tqevent.h>
#include <tqspinbox.h>

/* OTHER INCLUDES */
#include <specials.h>
#include "spinboxint.h"

SpinBoxInt::SpinBoxInt(TQWidget *a_parent, const char *a_name)
  : TQSpinBox(a_parent, a_name), KommanderWidget(TQT_TQOBJECT(this))
{
  TQStringList states;
  states << "default";
  setStates(states);
  setDisplayStates(states);
}

SpinBoxInt::~SpinBoxInt()
{
}

TQString SpinBoxInt::currentState() const
{
  return "default";
}

bool SpinBoxInt::isKommanderWidget() const
{
  return true;
}

TQStringList SpinBoxInt::associatedText() const
{
  return KommanderWidget::associatedText();
}

void SpinBoxInt::setAssociatedText(const TQStringList& a_at)
{
  KommanderWidget::setAssociatedText(a_at);
}

void SpinBoxInt::setPopulationText(const TQString& a_text)
{
  KommanderWidget::setPopulationText(a_text);
}

TQString SpinBoxInt::populationText() const
{
  return KommanderWidget::populationText();
}

void SpinBoxInt::populate()
{
  setWidgetText(KommanderWidget::evalAssociatedText( populationText()));
}

void SpinBoxInt::setWidgetText(const TQString &a_text)
{
  setValue(a_text.toInt());
  emit widgetTextChanged(a_text);
}

void SpinBoxInt::showEvent( TQShowEvent *e )
{
  TQSpinBox::showEvent(e);
  emit widgetOpened();
}

void SpinBoxInt::focusOutEvent( TQFocusEvent * e)
{
  TQSpinBox::focusOutEvent(e);
  emit lostFocus();
}

void SpinBoxInt::focusInEvent( TQFocusEvent * e)
{
  TQSpinBox::focusInEvent(e);
  emit gotFocus();
}

bool SpinBoxInt::isFunctionSupported(int f)
{
  return f == DCOP::text || f == DCOP::setText || f == DCOP::setMaximum  || f == DCOP::geometry|| f == DCOP::getBackgroundColor || f == DCOP::setBackgroundColor;
}

TQString SpinBoxInt::handleDCOP(int function, const TQStringList& args)
{
  switch (function) {
    case DCOP::text:
      return cleanText();
    case DCOP::setText:
      setWidgetText(args[0]);
      break;
    case DCOP::setMaximum:
      setMaxValue(args[0].toUInt());
      break;
    case DCOP::geometry:
    {
      TQString geo = TQString::number(this->x())+" "+TQString::number(this->y())+" "+TQString::number(this->width())+" "+TQString::number(this->height());
      return geo;
      break;
    }
    case DCOP::getBackgroundColor:
      return this->paletteBackgroundColor().name();
      break;
    case DCOP::setBackgroundColor:
    {
      TQColor color;
      color.setNamedColor(args[0]);
      this->setPaletteBackgroundColor(color);
      break;
    }
    default:
      return KommanderWidget::handleDCOP(function, args);
  }
  return TQString();
}

#include "spinboxint.moc"
