/***************************************************************************
*   Copyright (C) 1998 by Sandy Meier                                     *
*   smeier@rz.uni-potsdam.de                                              *
*   Copyright (C) 1999 by Benoit.Cerrina                                  *
*   Benoit.Cerrina@writeme.com                                            *
*   Copyright (C) 2002 by Bernd Gehrmann                                  *
*   bernd@kdevelop.org                                                    *
*   Copyright (C) 2003 by Eray Ozkural                                    *
*   <erayo@cs.bilkent.edu.tr>                                             *
*   Copyright (C) 2003-2004 by Alexander Dymo                             *
*   adymo@kdevelop.org                                                    *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#include "cppnewclassdlg.h"

#include <tqcheckbox.h>
#include <tqfile.h>
#include <tqfileinfo.h>
#include <tqradiobutton.h>
#include <tqregexp.h>
#include <tqtextedit.h>
#include <tqrect.h>
#include <tqstyle.h>

#include <kdebug.h>
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <tqcombobox.h>
#include <tqlistview.h>
#include <tqpopupmenu.h>
#include <tqpushbutton.h>
#include <tqtabwidget.h>
#include <klineedit.h>
#include <tdeversion.h>

#include "cppsupportpart.h"
#include "kdevproject.h"
#include "kdevsourceformatter.h"
#include "kdevcoderepository.h"
#include "kdevpartcontroller.h"
#include "backgroundparser.h"
#include "domutil.h"
#include "filetemplate.h"
#include "storeconverter.h"
#include "qtbuildconfig.h"

#include "classgeneratorconfig.h"

TQString TQRegExp_escape( const TQString& str )
{
	return TQRegExp::escape( str );
}

CppNewClassDialog::CppNewClassDialog( CppSupportPart *part, TQWidget *parent, const char *name )
		: CppNewClassDialogBase( parent, name ), myModel( 0 )
{
	headerModified = false;
	baseincludeModified = false;
	implementationModified = false;
	m_part = part;
	// read file template configuration
	//    KDevProject *project = part->project();
	TQDomDocument &dom = *part->projectDom();
	interface_url = DomUtil::readEntry( dom, "/cppsupportpart/filetemplates/interfaceURL" );
	implementation_url = DomUtil::readEntry( dom, "/cppsupportpart/filetemplates/implementationURL" );
	interface_suffix = DomUtil::readEntry( dom, "/cppsupportpart/filetemplates/interfacesuffix", ".h" );
	implementation_suffix = DomUtil::readEntry( dom, "/cppsupportpart/filetemplates/implementationsuffix", ".cpp" );
	lowercase_filenames = DomUtil::readBoolEntry( dom, "/cppsupportpart/filetemplates/lowercasefilenames", true );
	m_parse = DomUtil::readEntry( *m_part->projectDom(), "/cppsupportpart/newclass/filenamesetting", "none" );
	//    name_handler_combo->setCurrentText(m_parse);
	baseclasses_view->setSorting( -1 );
	constructors_view->setSorting( -1 );

	accessMenu = new TQPopupMenu( this );
	accessMenu->insertItem( i18n( "Use as Private" ),
	                        this, TQT_SLOT( changeToPrivate() ), 0, 1 );
	accessMenu->insertItem( i18n( "Use as Protected" ),
	                        this, TQT_SLOT( changeToProtected() ), 0, 2 );
	accessMenu->insertItem( i18n( "Use as Public" ),
	                        this, TQT_SLOT( changeToPublic() ), 0, 3 );
	accessMenu->insertSeparator();
	accessMenu->insertItem( i18n( "Unset" ),
	                        this, TQT_SLOT( changeToInherited() ), 0, 5 );

	overMenu = new TQPopupMenu( this );
	overMenu->insertItem( i18n( "Extend Base Class Functionality" ),
	                      this, TQT_SLOT( extendFunctionality() ), 0, 11 );
	overMenu->insertItem( i18n( "Replace Base Class Method" ),
	                      this, TQT_SLOT( replaceFunctionality() ), 0, 12 );

	compBasename = basename_edit->completionObject();
	setCompletionBasename( m_part->codeModel() );
	compNamespace = namespace_edit->completionObject();
	setCompletionNamespaceRecursive( m_part->codeModel() ->globalNamespace() );
	classname_edit->setFocus();

	// enable/disable qt options for non qt projects
	childclass_box->setEnabled( m_part->qtBuildConfig()->isUsed() );
	qobject_box->setEnabled( m_part->qtBuildConfig()->isUsed() );
}


CppNewClassDialog::~CppNewClassDialog()
{
	delete compBasename;
	delete compNamespace;
	delete myModel;
}

void CppNewClassDialog::setCompletionBasename( CodeModel *model )
{
	compBasename->clear();

	// Import selected namespace without qualifier
	NamespaceDom namespaceDom = model->globalNamespace();

	TQStringList::const_iterator it = currNamespace.begin();
	for ( ; it != currNamespace.end() ; ++it )
	{
		if ( ! namespaceDom->hasNamespace( *it ) )
			break;
		namespaceDom = namespaceDom->namespaceByName( *it );
	}

	if ( it == currNamespace.end() )
		// complete namespace has been found (not breaked)
		compBasename->insertItems( sortedNameList( namespaceDom -> classList() ) );

	addCompletionBasenameNamespacesRecursive( model->globalNamespace() );

	TQStringList compItems = compBasename->items();
	it = compItems.begin();
	for ( int i = 0;
	        it != compItems.end(); ++it, ++i )
		kdDebug( 9007 ) << "compBasename->items()[" << i << "] = \"" << *it << "\"" << endl;
}

TQStringList& gres( TQStringList &list, const TQRegExp & rx, const TQString & after )
{
	TQStringList::Iterator it = list.begin();
	while ( it != list.end() )
	{
		( *it ).replace( rx, after );
		++it;
	}
	return list;
}

void CppNewClassDialog::addCompletionBasenameNamespacesRecursive( const NamespaceDom & namespaceDom,
        const TQString & namespaceParent )
{
	// Add classes of this namespace
	TQStringList classList = sortedNameList( namespaceDom -> classList() );

	if ( ! namespaceParent.isEmpty() )
	{
		classList.gres( TQRegExp( "^" ), namespaceParent + "::" );
	}

	compBasename -> insertItems( classList );


	// Recursion
	NamespaceList namespaceList = namespaceDom->namespaceList();
	NamespaceList::const_iterator it = namespaceList.begin();

	for ( ; it != namespaceList.end() ; ++it )
	{
		TQString fullNamespace;

		if ( ! namespaceParent.isEmpty() )
			fullNamespace = namespaceParent + "::";

		fullNamespace += ( *it ) -> name();
		addCompletionBasenameNamespacesRecursive( *it, fullNamespace );
	}
}


void CppNewClassDialog::setCompletionNamespaceRecursive( const NamespaceDom & namespaceDom, const TQString & namespaceParent )
{
	NamespaceList namespaceList = namespaceDom->namespaceList();
	NamespaceList::const_iterator it = namespaceList.begin();
	for ( ; it != namespaceList.end() ; ++it )
	{
		TQString fullNamespace;

		if ( ! namespaceParent.isEmpty() )
			fullNamespace = namespaceParent + "::";

		fullNamespace += ( *it ) -> name();
		kdDebug( 9007 ) << "compNamespace -> addItem( \"" << fullNamespace << "\" )" << endl;
		compNamespace -> addItem( fullNamespace );
		setCompletionNamespaceRecursive( *it, fullNamespace );
	}
}

void CppNewClassDialog::nameHandlerChanged( const TQString &text )
{
	DomUtil::writeEntry( *m_part->projectDom(), "/cppsupportpart/newclass/filenamesetting", text );
	m_parse = text;
	classNameChanged( classname_edit->text() );
}

void CppNewClassDialog::classNameChanged( const TQString &text )
{
	TQString str = text;

	if ( !headerModified )
	{
		TQString header = str + interface_suffix;
		switch ( gen_config->fileCase() )
		{
		case ClassGeneratorConfig::LowerCase:
			header = header.lower();
			break;
		case ClassGeneratorConfig::UpperCase:
			header = header.upper();
			break;
		default:
			;
		}
		header = header.replace( TQRegExp( "(template *<.*> *)?(class +)?" ), "" );
		header_edit->setText( header );
	}
	if ( !implementationModified )
	{
		TQString implementation;
		if ( str.contains( "template" ) )
			implementation = str + "_impl" + interface_suffix;
		else
			implementation = str + implementation_suffix;
		switch ( gen_config->fileCase() )
		{
		case ClassGeneratorConfig::LowerCase:
			implementation = implementation.lower();
			break;
		case ClassGeneratorConfig::UpperCase:
			implementation = implementation.upper();
			break;
		default:
			;
		}
		implementation = implementation.replace( TQRegExp( "(template *<.*> *)?(class +)?" ), "" );
		implementation_edit->setText( implementation );
	}
}

void CppNewClassDialog::classNamespaceChanged( const TQString &text )
{
	currNamespace = TQStringList::split( TQString( "::" ), text );
	setCompletionBasename( m_part -> codeModel() );
	reloadAdvancedInheritance( true );
}

void CppNewClassDialog::baseclassname_changed( const TQString &text )
{
	if ( ( basename_edit->hasFocus() ) && ( !baseincludeModified ) )
	{
		TQString header = text;

		// handle TQt classes in a special way.
		if( m_part->qtBuildConfig()->isUsed() && header.startsWith( "Q" ) )
		{
			if( m_part->qtBuildConfig()->version() == 3 )
			{
				header = header.lower() + ".h";
			}
			else if( m_part->qtBuildConfig()->version() == 4 )
			{
				// 1:1, e.g TQObject is #include <TQObject>
			}
		}
		else
		{
			if ( header.contains( TQRegExp( "::" ) ) )
				header = header.mid( header.findRev( TQRegExp( "::" ) ) + 2 );
			header = header.replace( TQRegExp( " *<.*>" ), "" );
			header += interface_suffix;

			switch ( gen_config->superCase() )
			{
			case ClassGeneratorConfig::LowerCase:
				header = header.lower();
				break;
			case ClassGeneratorConfig::UpperCase:
				header = header.upper();
				break;
			default:
				;
			}
		}

		baseinclude_edit->setText( header );
	}
}

void CppNewClassDialog::baseIncludeChanged( const TQString &text )
{
	if ( baseinclude_edit->hasFocus() )
	{
		baseincludeModified = true;
		if ( baseclasses_view->selectedItem() )
			baseclasses_view->selectedItem() ->setText( 4, "true" );
	}
	if ( baseclasses_view->selectedItem() )
	{
		baseclasses_view->selectedItem() ->setText( 3, text );
	}
}

void CppNewClassDialog::headerChanged()
{
	// Only if a change caused by the user himself
	if ( header_edit->hasFocus() )
		headerModified = true;
}


void CppNewClassDialog::implementationChanged()
{
	// Only if a change caused by the user himself
	if ( implementation_edit->hasFocus() )
		implementationModified = true;
}

void CppNewClassDialog::checkObjCInheritance( int val )
{
	childclass_box->setEnabled( !val && m_part->qtBuildConfig()->isUsed() );
	gtk_box->setEnabled( !val );
	qobject_box->setEnabled( !val && m_part->qtBuildConfig()->isUsed() );
	namespace_edit->setEnabled( !val );
	class_tabs->setTabEnabled( tab2, !val );
	/*    virtual_box->setEnabled(!val);
	    public_button->setEnabled(!val);
	    protected_button->setEnabled(!val);
	    private_button->setEnabled(!val);*/
	if ( val && ( baseclasses_view->childCount() > 1 ) )
		if ( KMessageBox::warningContinueCancel( this,
		        i18n( "Objective C does not support multiple inheritance.\nOnly the first base class in the list will be taken into account." ),
		        i18n( "Warning" ), KStdGuiItem::cont(), "Check Objective C inheritance rules" ) == KMessageBox::Cancel )
			objc_box->setChecked( false );
}

void CppNewClassDialog::checkTQWidgetInheritance( int val )
{
	if ( val )
	{
		qobject_box->setEnabled( val && m_part->qtBuildConfig()->isUsed() );
		qobject_box->setChecked( val && m_part->qtBuildConfig()->isUsed() );
		objc_box->setEnabled( !val );
		gtk_box->setEnabled( !val );
	}
	else if ( qobject_box->isChecked() )
	{
		objc_box->setEnabled( false );
		gtk_box->setEnabled( false );
	}
	else
	{
		objc_box->setEnabled( !val );
		gtk_box->setEnabled( !val );
	}


	if ( val )
	{
		if ( baseclasses_view->childCount() == 0 )
		{
			addBaseClass();
			basename_edit->setText( TQWIDGET_OBJECT_NAME_STRING );
		}
		/*        constructors_cpp_edit->append(classname_edit->text() + "::" + classname_edit->text() +
		            "(TQWidget *parent, const char *name):\n    TQWidget(parent, name)\n{\n}\n");
		        constructors_h_edit->append(classname_edit->text() + "(TQWidget *parent, const char *name);\n");*/
	}

	if ( val && ( baseclasses_view->childCount() > 1 ) )
		if ( KMessageBox::warningContinueCancel( this,
		        i18n( "Multiple inheritance requires TQObject derivative to be first and unique in base class list." ),
		        i18n( "Warning" ), KStdGuiItem::cont(), "Check TQWidget inheritance rules" ) == KMessageBox::Cancel )
			childclass_box->setChecked( false );
}

void CppNewClassDialog::qobject_box_stateChanged( int val )
{
	if ( childclass_box->isChecked() )
		return ;

	if ( baseclasses_view->childCount() == 0 )
	{
		addBaseClass();
		basename_edit->setText( TQOBJECT_OBJECT_NAME_STRING );
	}


	objc_box->setEnabled( !val );
	gtk_box->setEnabled( !val );
}

void CppNewClassDialog::gtk_box_stateChanged( int val )
{
	class_tabs->setTabEnabled( tab2, !val );
	childclass_box->setEnabled( !val && m_part->qtBuildConfig()->isUsed() );
	objc_box->setEnabled( !val );
	qobject_box->setEnabled( !val && m_part->qtBuildConfig()->isUsed() );
	namespace_edit->setEnabled( !val );

	basename_edit->setEnabled( !val );
	virtual_box->setEnabled( !val );
	public_button->setEnabled( !val );
	protected_button->setEnabled( !val );
	private_button->setEnabled( !val );
	addbaseclass_button->setEnabled( !val );
	rembaseclass_button->setEnabled( !val );
	upbaseclass_button->setEnabled( !val );
	downbaseclass_button->setEnabled( !val );
	baseclasses_view->setEnabled( !val );
	baseinclude_edit->setEnabled( !val );
}


void CppNewClassDialog::accept()
{
	ClassGenerator generator( *this );
	if ( generator.generate() )
		TQDialog::accept();

}

void CppNewClassDialog::setStateOfInheritanceEditors( bool state, bool hideList )
{
	basename_edit->setEnabled( state );
	virtual_box->setEnabled( state );
	public_button->setEnabled( state );
	protected_button->setEnabled( state );
	private_button->setEnabled( state );
	scope_box->setEnabled( state );
	baseinclude_edit->setEnabled( state );
	if ( state )
		baseclasses_view->setEnabled( state );
	else
		baseclasses_view->setEnabled( hideList ? state : true );
	rembaseclass_button->setEnabled( state );
	if ( !state )
	{
		upbaseclass_button->setEnabled( state );
		downbaseclass_button->setEnabled( state );
	}
}

void CppNewClassDialog::addBaseClass()
{
	baseincludeModified = false;
	if ( baseclasses_view->selectedItem() )
		baseclasses_view->selectedItem() ->setSelected( false );
	TQListViewItem* it = new TQListViewItem( baseclasses_view, baseclasses_view->lastItem(),
	                                       TQString(), "public", TQString( "%1" ).arg( scope_box->currentItem() ), TQString(), "false" );
	setStateOfInheritanceEditors( true );
	public_button->setChecked( true );
	virtual_box->setChecked( false );
	basename_edit->setText( TQString() );
	basename_edit->setFocus();
	baseclasses_view->setSelected( it, true );
}

void CppNewClassDialog::remBaseClass()
{
	bool basename_focused = false;
	if ( basename_edit->hasFocus() )
	{
		basename_focused = true;
		basename_edit->clearFocus();
	}
	if ( baseclasses_view->selectedItem() )
	{
		TQListViewItem * it = baseclasses_view->selectedItem();
		remClassFromAdv( it->text( 0 ) );
		baseclasses_view->selectedItem() ->setSelected( false );
		if ( it->itemBelow() )
			baseclasses_view->setSelected( it->itemBelow(), true );
		else if ( it->itemAbove() )
			baseclasses_view->setSelected( it->itemAbove(), true );
		delete it;
		if ( baseclasses_view->childCount() == 0 )
			setStateOfInheritanceEditors( false );
		baseincludeModified = false;
	}
	if ( basename_focused )
		basename_edit->setFocus();
}

void CppNewClassDialog::remBaseClassOnly()
{
	if ( baseclasses_view->selectedItem() )
	{
		TQListViewItem * it = baseclasses_view->selectedItem();
		baseclasses_view->selectedItem() ->setSelected( false );
		if ( it->itemBelow() )
			baseclasses_view->setSelected( it->itemBelow(), true );
		else if ( it->itemAbove() )
			baseclasses_view->setSelected( it->itemAbove(), true );
		delete it;
		if ( baseclasses_view->childCount() == 0 )
			setStateOfInheritanceEditors( false );
		baseincludeModified = true;
	}
}

void CppNewClassDialog::remClassFromAdv( TQString text )
{
	// Strip off namespace qualification
	if ( text.contains( "::" ) )
		text = text.mid( text.findRev( "::" ) + 2 );

	removeTemplateParams( text );
	TQListViewItem *it = 0;
	if ( ( it = access_view->findItem( text, 0 ) ) )
		delete it;
	if ( ( it = methods_view->findItem( text, 0 ) ) )
		delete it;
	if ( ( it = constructors_view->findItem( text, 0 ) ) )
	{
		/// @todo changing constructors text in constructors_cpp_edit
		// and constructors_h_edit must be implemented

		/*        int *para = new int(1);
		        int *index = new int(1);
		        if (constructors_cpp_edit->find(text + "(", true, false, true, para, index))
		        {
		            tqWarning("%s( found", text.latin1());
		            if (para) constructors_cpp_edit->removeParagraph(*para);
		        }*/
		delete it;
	}
}

void CppNewClassDialog::currBaseNameChanged( const TQString &text )
{
	if ( baseclasses_view->selectedItem() && ( basename_edit->hasFocus() ) )
	{
		if ( class_tabs->isTabEnabled( tab2 ) )
		{
			//check for this class in the adv. inheritance lists
			//and delete if it exists
			remClassFromAdv( baseclasses_view->selectedItem() ->text( 0 ) );
			//parse new base class
			parseClass( text, baseclasses_view->selectedItem() ->text( 1 ) );
		}
		baseclasses_view->selectedItem() ->setText( 0, text );
		updateConstructorsOrder();
	}
}

void CppNewClassDialog::currBasePrivateSet()
{
	if ( baseclasses_view->selectedItem() )
	{
		setAccessForBase( baseclasses_view->selectedItem() ->text( 0 ), "private" );
		baseclasses_view->selectedItem() ->setText( 1, ( virtual_box->isChecked() ? "virtual " : "" ) + TQString( "private" ) );
	}
}

void CppNewClassDialog::currBaseProtectedSet()
{
	if ( baseclasses_view->selectedItem() )
	{
		setAccessForBase( baseclasses_view->selectedItem() ->text( 0 ), "protected" );
		baseclasses_view->selectedItem() ->setText( 1, ( virtual_box->isChecked() ? "virtual " : "" ) + TQString( "protected" ) );
	}
}

void CppNewClassDialog::currBasePublicSet()
{
	if ( baseclasses_view->selectedItem() )
	{
		setAccessForBase( baseclasses_view->selectedItem() ->text( 0 ), "public" );
		baseclasses_view->selectedItem() ->setText( 1, ( virtual_box->isChecked() ? "virtual " : "" ) + TQString( "public" ) );
	}
}

void CppNewClassDialog::scopeboxActivated( int value )
{
	if ( baseclasses_view->selectedItem() )
	{
		baseclasses_view->selectedItem() ->setText( 2, TQString( "%1" ).arg( value ) );
	}
}

void CppNewClassDialog::currBaseVirtualChanged( int val )
{
	if ( baseclasses_view->selectedItem() )
	{
		baseclasses_view->selectedItem() ->setText( 1, TQString( val ? "virtual " : "" ) +
		        TQString( private_button->isChecked() ? "private" : "" ) +
		        TQString( protected_button->isChecked() ? "protected" : "" ) +
		        TQString( public_button->isChecked() ? "public" : "" ) );
	}
}

void CppNewClassDialog::currBaseSelected( TQListViewItem *it )
{
	if ( it == 0 )
	{
		setStateOfInheritanceEditors( false, false );
		return ;
	}
	setStateOfInheritanceEditors( true );
	basename_edit->setText( it->text( 0 ) );
	baseinclude_edit->setText( it->text( 3 ) );
	scope_box->setCurrentItem( it->text( 2 ).toInt() );
	if ( it->text( 1 ).contains( "private" ) )
		private_button->setChecked( true );
	else
		private_button->setChecked( false );
	if ( it->text( 1 ).contains( "protected" ) )
		protected_button->setChecked( true );
	else
		protected_button->setChecked( false );
	if ( it->text( 1 ).contains( "public" ) )
		public_button->setChecked( true );
	else
		public_button->setChecked( false );
	if ( it->text( 1 ).contains( "virtual" ) )
		virtual_box->setChecked( true );
	else
		virtual_box->setChecked( false );
	checkUpButtonState();
	checkDownButtonState();

	if ( it->text( 4 ) == "true" )
		baseincludeModified = true;
	else
		baseincludeModified = false;
}

void CppNewClassDialog::upbaseclass_button_clicked()
{
	bool basename_focused = false;
	if ( basename_edit->hasFocus() )
	{
		basename_focused = true;
		basename_edit->clearFocus();
	}
	if ( baseclasses_view->selectedItem() )
	{
		TQListViewItem * it = baseclasses_view->selectedItem();
		if ( it->itemAbove() )
		{
			TQListViewItem * newit;
			if ( it->itemAbove() ->itemAbove() )
				newit = new TQListViewItem( baseclasses_view, it->itemAbove() ->itemAbove(),
				                           it->text( 0 ), it->text( 1 ), it->text( 2 ), it->text( 3 ), it->text( 4 ) );
			else
				newit = new TQListViewItem( baseclasses_view, it->text( 0 ), it->text( 1 ),
				                           it->text( 2 ), it->text( 3 ), it->text( 4 ) );
			remBaseClassOnly();
			baseclasses_view->setSelected( newit, true );
			checkUpButtonState();
			updateConstructorsOrder();
		}
	}
	if ( basename_focused )
		basename_edit->setFocus();
}

void CppNewClassDialog::downbaseclass_button_clicked()
{
	bool basename_focused = false;
	if ( basename_edit->hasFocus() )
	{
		basename_focused = true;
		basename_edit->clearFocus();
	}
	if ( baseclasses_view->selectedItem() )
	{
		TQListViewItem * it = baseclasses_view->selectedItem();
		if ( it->itemBelow() )
		{
			TQListViewItem * newit = new TQListViewItem( baseclasses_view, it->itemBelow(),
			                        it->text( 0 ), it->text( 1 ), it->text( 2 ), it->text( 3 ), it->text( 3 ) );
			remBaseClassOnly();
			baseclasses_view->setSelected( newit, true );
			setStateOfInheritanceEditors( true );
			checkDownButtonState();
			updateConstructorsOrder();
		}
	}
	if ( basename_focused )
		basename_edit->setFocus();
}

void CppNewClassDialog::updateConstructorsOrder()
{
	TQListViewItemIterator it( baseclasses_view );
	TQListViewItem *c_it;
	TQListViewItem *fc_it = 0;

	while ( it.current() )
	{
		if ( ( c_it = constructors_view->findItem( it.current() ->text( 0 ), 0 ) ) )
		{
			c_it->moveItem( fc_it );
			fc_it = c_it;
		}
		++it;
	}
}


void CppNewClassDialog::checkUpButtonState()
{
	if ( baseclasses_view->selectedItem() )
		upbaseclass_button->setEnabled( baseclasses_view->selectedItem() ->itemAbove() );
}

void CppNewClassDialog::checkDownButtonState()
{
	if ( baseclasses_view->selectedItem() )
		downbaseclass_button->setEnabled( baseclasses_view->selectedItem() ->itemBelow() );
}

void CppNewClassDialog::baseclasses_view_selectionChanged()
{
	/*    if (baseclasses_view->selectedItem())
	    {
	        setStateOfInheritanceEditors(false, false);
	    }*/
}

void CppNewClassDialog::changeToPrivate()
{
	if ( access_view->selectedItem() )
		access_view->selectedItem() ->setText( 2, "private" );
}

void CppNewClassDialog::changeToProtected()
{
	if ( access_view->selectedItem() )
		access_view->selectedItem() ->setText( 2, "protected" );
}

void CppNewClassDialog::changeToPublic()
{
	if ( access_view->selectedItem() )
		access_view->selectedItem() ->setText( 2, "public" );
}

void CppNewClassDialog::changeToInherited()
{
	if ( access_view->selectedItem() )
		access_view->selectedItem() ->setText( 2, TQString() );
}

void CppNewClassDialog::newTabSelected( const TQString& /*text*/ )
{
	/*    if (text == i18n("&Advanced Inheritance"))
	        reloadAdvancedInheritance(true);*/
}

void CppNewClassDialog::newTabSelected( TQWidget* /*w*/ )
{
	/*    if ( TQString(w->name()) == TQString("tab2"))
	    {
	        reloadAdvancedInheritance(false);
	    }*/
}


void CppNewClassDialog::reloadAdvancedInheritance( bool clean )
{
	clearConstructorsList( clean );
	clearMethodsList( clean );
	clearUpgradeList( clean );

	TQListViewItemIterator it( baseclasses_view );
	while ( it.current() )
	{
		if ( ! ( it.current() ->text( 0 ).isEmpty() ) )
		{
			parseClass( it.current() ->text( 0 ), it.current() ->text( 1 ) );
		}
		++it;
	}
}

void CppNewClassDialog::parseClass( TQString clName, TQString inheritance )
{
	// Determine namespace
	TQStringList clNamespace = currNamespace;
	bool clFullQualified = false;

	if ( clName.contains( "::" ) )
	{
		// Full qualified, override imported namespace
		clFullQualified = true;
		int splitpoint = clName.findRev( "::" );
		clNamespace = TQStringList::split( "::", clName.left( splitpoint ) );
		clName = clName.mid( splitpoint + 2 );
	}

	kdDebug( 9007 ) << "clFullQualified = " << clFullQualified << endl;
	kdDebug( 9007 ) << "clName = " << clName << endl;
	TQString debMsg = "clNamespace = ";
	for ( TQStringList::const_iterator it = clNamespace.begin();
	        it != clNamespace.end(); ++it )
		debMsg += ( *it ) + "::";
	kdDebug( 9007 ) << debMsg << endl;

	TQString templateAdd = templateActualParamsFormatted( clName );
	removeTemplateParams( clName );

	ClassList myClasses; // = m_part->codeModel()->globalNamespace()->classByName(clName);

	NamespaceDom namespaceDom = m_part->codeModel() ->globalNamespace();

	TQStringList::const_iterator namespaceIt = clNamespace.begin();
	for ( ; namespaceIt != clNamespace.end(); ++namespaceIt )
	{
		if ( ! namespaceDom -> hasNamespace( *namespaceIt ) )
			break;
		namespaceDom = namespaceDom->namespaceByName( *namespaceIt );
	}
	if ( namespaceIt == clNamespace.end() )
	{
		// Found specified namespace
		myClasses = namespaceDom->classByName( clName );
		// Fall back to global namespace if class was not fully qualified and is not found in selected namespace
		if ( myClasses.empty() && ! clFullQualified )
			myClasses = m_part -> codeModel() -> globalNamespace() -> classByName( clName );
	}

	if ( myClasses.empty() )
	{
		kdDebug() << "Trying persistent class store..." << endl;
		parsePCSClass( clName, inheritance );
	}

	for ( ClassList::const_iterator classIt = myClasses.begin(); classIt != myClasses.end(); ++classIt )
	{
		PCheckListItem<ClassDom> *it = new PCheckListItem<ClassDom>( *classIt, constructors_view, ( *classIt ) ->name() );
		it->templateAddition = templateAdd;
		PListViewItem<ClassDom> *over = new PListViewItem<ClassDom>( *classIt, methods_view, ( *classIt ) ->name() );
		over->templateAddition = templateAdd;
		TQListViewItem *over_methods = new TQListViewItem( over, i18n( "Methods" ) );
		TQListViewItem *over_slots = new TQListViewItem( over, i18n( "Slots (TQt-specific)" ) );
		PListViewItem<ClassDom> *access = new PListViewItem<ClassDom>( *classIt, access_view, ( *classIt ) ->name() );
		TQListViewItem *access_methods = new TQListViewItem( access, i18n( "Methods" ) );
		TQListViewItem *access_slots = new TQListViewItem( access, i18n( "Slots (TQt-specific)" ) );
		TQListViewItem *access_attrs = new TQListViewItem( access, i18n( "Attributes" ) );

		FunctionList functionList = ( *classIt ) ->functionList();
		for ( FunctionList::const_iterator methodIt = functionList.begin();
		        methodIt != functionList.end(); ++methodIt )
		{
			if ( ( *methodIt ) ->isSignal() )
			{
				// don't show signals as overridable methods
			}
			else if ( isConstructor( ( *classIt ) ->name(), *methodIt ) )
			{
				addToConstructorsList( it, *methodIt );
			}
			else if ( ( *methodIt ) ->isSlot() )
			{
				if ( ( *methodIt ) ->access() != CodeModelItem::Private )
				{
					addToMethodsList( over_slots, *methodIt );

					TQString inhModifier;
					//protected inheritance gives protected attributes
					if ( inheritance.contains( "protected" ) )
						inhModifier = "protected";
					//private inheritance gives private attributes
					else if ( inheritance.contains( "private" ) )
						inhModifier = "private";
					//public inheritance gives protected and public attributes
					else if ( inheritance.contains( "public" ) )
						inhModifier = ( *methodIt ) ->access() == CodeModelItem::Public ? "public" : "protected";
					addToUpgradeList( access_slots, *methodIt, inhModifier );
				}
			}
			else
			{
				// display only public and protected methods of the base class
				if ( ( !isDestructor( ( *classIt ) ->name(), *methodIt ) ) && ( ( *methodIt ) ->access() != CodeModelItem::Private ) )
				{
					addToMethodsList( over_methods, *methodIt );

					// see what modifier is given for the base class
					TQString inhModifier;
					//protected inheritance gives protected methods
					if ( inheritance.contains( "protected" ) )
						inhModifier = "protected";
					//private inheritance gives private methods
					else if ( inheritance.contains( "private" ) )
						inhModifier = "private";
					//public inheritance gives protected and public methods
					else if ( inheritance.contains( "public" ) )
						inhModifier = ( *methodIt ) ->access() == CodeModelItem::Public ? "public" : "protected";
					addToUpgradeList( access_methods, *methodIt, inhModifier );
				}
			}
		}

		VariableList variableList = ( *classIt ) ->variableList();
		for ( VariableList::const_iterator varIt = variableList.begin();
		        varIt != variableList.end(); ++varIt )
		{
			if ( ( *varIt ) ->access() != CodeModelItem::Private )
			{
				TQString inhModifier;
				//protected inheritance gives protected attributes
				if ( inheritance.contains( "protected" ) )
					inhModifier = "protected";
				//private inheritance gives private attributes
				else if ( inheritance.contains( "private" ) )
					inhModifier = "private";
				//public inheritance gives protected and public attributes
				else if ( inheritance.contains( "public" ) )
					inhModifier = ( *varIt ) ->access() == CodeModelItem::Public ? "public" : "protected";
				addToUpgradeList( access_attrs, *varIt, inhModifier );
			}
		}
	}
}

bool CppNewClassDialog::isConstructor( TQString className, const FunctionDom &method )
{
	//  regexp:  myclass\\s*\\(\\s*(const)?\\s*myclass\\s*&[A-Za-z_0-9\\s]*\\) is for copy constructors
	if ( ( className == method->name() ) )
	{
		tqWarning( "1x" );
		if ( ( method->argumentList().count() == 1 ) && ( m_part->formatModelItem( method->argumentList() [ 0 ].data() ).contains( TQRegExp( " *(const)? *" + className + " *& *" ) ) ) )
			//        if ( method->asString().contains(TQRegExp(className + "\\s*\\(\\s*(const)?\\s*" + className + "\\s*&[A-Za-z_0-9\\s]*\\)", true, false)) )
			return false;
		else
			return true;
	}
	else
		return false;
}

void CppNewClassDialog::addToConstructorsList( TQCheckListItem *myClass, FunctionDom method )
{
	new PCheckListItem<FunctionDom>( method, myClass, m_part->formatModelItem( method.data() ), TQCheckListItem::RadioButton );
}

void CppNewClassDialog::addToMethodsList( TQListViewItem *parent, FunctionDom method )
{
	PCheckListItem<FunctionDom> *it = new PCheckListItem<FunctionDom>( method, parent, m_part->formatModelItem( method.data() ), TQCheckListItem::CheckBox );
	method->isAbstract() ? it->setText( 1, i18n( "replace" ) ) : it->setText( 1, i18n( "extend" ) );
}

void CppNewClassDialog::addToUpgradeList( TQListViewItem *parent, FunctionDom method, TQString modifier )
{
	PListViewItem<FunctionDom> *it = new PListViewItem<FunctionDom>( method, parent, m_part->formatModelItem( method.data() ) );
	it->setText( 1, modifier );
}

void CppNewClassDialog::addToUpgradeList( TQListViewItem *parent, VariableDom attr, TQString modifier )
{
	PListViewItem<VariableDom> *it = new PListViewItem<VariableDom>( attr, parent, m_part->formatModelItem( attr.data() ) );
	it->setText( 1, modifier );
}


void CppNewClassDialog::parsePCSClass( TQString clName, TQString inheritance )
{
	// Determine namespace
	TQStringList clNamespace = currNamespace;
	bool clFullQualified = false;

	if ( clName.contains( "::" ) )
	{
		// Full qualified, override imported namespace
		clFullQualified = true;
		int splitpoint = clName.findRev( "::" );
		clNamespace = TQStringList::split( "::", clName.left( splitpoint ) );
		clName = clName.mid( splitpoint + 2 );
	}

	kdDebug( 9007 ) << "clFullQualified = " << clFullQualified << endl;
	kdDebug( 9007 ) << "clName = " << clName << endl;
	kdDebug( 9007 ) << "clNamespace = " << clNamespace.join( "." ) << endl;

	TQString templateAdd = templateActualParamsFormatted( clName );
	removeTemplateParams( clName );

	myModel = new CodeModel();
	StoreConverter converter( m_part, myModel );
	converter.PCSClassToCodeModel( clName, clNamespace );

	ClassList myClasses = myModel->globalNamespace() ->classByName( clName );
	//     kdDebug() << "    tag class count: " << myClasses.count() << endl;

	for ( ClassList::const_iterator classIt = myClasses.begin(); classIt != myClasses.end(); ++classIt )
	{
		kdDebug() << "    this is class " << ( *classIt ) ->name() << endl;
		PCheckListItem<ClassDom> *it = new PCheckListItem<ClassDom>( *classIt, constructors_view, ( *classIt ) ->name() );
		it->templateAddition = templateAdd;
		PListViewItem<ClassDom> *over = new PListViewItem<ClassDom>( *classIt, methods_view, ( *classIt ) ->name() );
		over->templateAddition = templateAdd;
		TQListViewItem *over_methods = new TQListViewItem( over, i18n( "Methods" ) );
		TQListViewItem *over_slots = new TQListViewItem( over, i18n( "Slots (TQt-specific)" ) );
		PListViewItem<ClassDom> *access = new PListViewItem<ClassDom>( *classIt, access_view, ( *classIt ) ->name() );
		TQListViewItem *access_methods = new TQListViewItem( access, i18n( "Methods" ) );
		TQListViewItem *access_slots = new TQListViewItem( access, i18n( "Slots (TQt-specific)" ) );
		TQListViewItem *access_attrs = new TQListViewItem( access, i18n( "Attributes" ) );

		FunctionList functionList = ( *classIt ) ->functionList();
		for ( FunctionList::const_iterator methodIt = functionList.begin();
		        methodIt != functionList.end(); ++methodIt )
		{
			if ( ( *methodIt ) ->isSignal() )
			{
				//don't show signals as overridable methods
			}
			else if ( isConstructor( ( *classIt ) ->name(), *methodIt ) )
			{
				addToConstructorsList( it, *methodIt );
			}
			else if ( ( *methodIt ) ->isSlot() )
			{
				if ( ( *methodIt ) ->access() != CodeModelItem::Private )
				{
					addToMethodsList( over_slots, *methodIt );

					TQString inhModifier;
					//protected inheritance gives protected attributes
					if ( inheritance.contains( "protected" ) )
						inhModifier = "protected";
					//private inheritance gives private attributes
					else if ( inheritance.contains( "private" ) )
						inhModifier = "private";
					//public inheritance gives protected and public attributes
					else if ( inheritance.contains( "public" ) )
						inhModifier = ( *methodIt ) ->access() == CodeModelItem::Public ? "public" : "protected";
					addToUpgradeList( access_slots, *methodIt, inhModifier );
				}
			}
			else
			{
				//display only public and protected methods of the base class
				if ( ( !isDestructor( ( *classIt ) ->name(), *methodIt ) ) && ( ( *methodIt ) ->access() != CodeModelItem::Private ) )
				{
					addToMethodsList( over_methods, *methodIt );

					//see what modifier is given for the base class
					TQString inhModifier;
					//protected inheritance gives protected methods
					if ( inheritance.contains( "protected" ) )
						inhModifier = "protected";
					//private inheritance gives private methods
					else if ( inheritance.contains( "private" ) )
						inhModifier = "private";
					//public inheritance gives protected and public methods
					else if ( inheritance.contains( "public" ) )
						inhModifier = ( *methodIt ) ->access() == CodeModelItem::Public ? "public" : "protected";
					addToUpgradeList( access_methods, *methodIt, inhModifier );
				}
			}
		}

		VariableList variableList = ( *classIt ) ->variableList();
		for ( VariableList::const_iterator varIt = variableList.begin();
		        varIt != variableList.end(); ++varIt )
		{
			if ( ( *varIt ) ->access() != CodeModelItem::Private )
			{
				TQString inhModifier;
				//protected inheritance gives protected attributes
				if ( inheritance.contains( "protected" ) )
					inhModifier = "protected";
				//private inheritance gives private attributes
				else if ( inheritance.contains( "private" ) )
					inhModifier = "private";
				//public inheritance gives protected and public attributes
				else if ( inheritance.contains( "public" ) )
					inhModifier = ( *varIt ) ->access() == CodeModelItem::Public ? "public" : "protected";
				addToUpgradeList( access_attrs, *varIt, inhModifier );
			}
		}
	}
}

void CppNewClassDialog::clear_selection_button_clicked()
{
	TQListViewItemIterator it( constructors_view );
	while ( it.current() )
	{
		PCheckListItem<FunctionDom> *curr;
		if ( ( curr = dynamic_cast<PCheckListItem<FunctionDom>* >( it.current() ) ) )
			curr->setOn( false );
		++it;
	}
}

void CppNewClassDialog::clearConstructorsList( bool clean )
{
	if ( clean )
		constructors_view->clear();
	/*    else
	    {
	        TQListViewItemIterator it( constructors_view );
	        while ( it.current() )
	        {
	            if ( ! currBaseClasses.contains(it.current().text(0)) )
	                delete it.current();
	            ++it;
	        }
	    }*/
}

void CppNewClassDialog::clearMethodsList( bool clean )
{
	if ( clean )
		methods_view->clear();
}

void CppNewClassDialog::clearUpgradeList( bool clean )
{
	if ( clean )
		access_view->clear();
}

void CppNewClassDialog::setAccessForItem( TQListViewItem *curr, TQString newAccess, bool isPublic )
{
	if ( newAccess == "public" )
		curr->setText( 1, isPublic ? "public" : "protected" );
	else
		curr->setText( 1, newAccess );
	if ( !curr->text( 2 ).isEmpty() )
	{
		if ( ( curr->text( 2 ) == "private" ) && ( ( newAccess == "public" ) || ( newAccess == "protected" ) ) )
			curr->setText( 2, TQString() );
		if ( ( curr->text( 2 ) == "protected" ) && ( ( newAccess == "public" ) && ( isPublic ) ) )
			curr->setText( 2, TQString() );
	}
}

void CppNewClassDialog::setAccessForBase( TQString baseclass, TQString newAccess )
{
	TQListViewItem * base;

	if ( ( base = access_view->findItem( baseclass, 0 ) ) )
	{
		TQListViewItemIterator it( base );
		while ( it.current() )
		{
			if ( !it.current() ->text( 1 ).isEmpty() )
			{
				PListViewItem<VariableDom> *curr;
				PListViewItem<FunctionDom> *curr_m;
				if ( ( curr = dynamic_cast<PListViewItem<VariableDom>* >( it.current() ) ) )
					setAccessForItem( curr, newAccess, curr->item() ->access() == CodeModelItem::Public );
				else if ( ( curr_m = dynamic_cast<PListViewItem<FunctionDom>* >( it.current() ) ) )
					setAccessForItem( curr_m, newAccess, curr_m->item() ->access() == CodeModelItem::Public );
			}
			++it;
		}
	}
}


void CppNewClassDialog::access_view_mouseButtonPressed( int button, TQListViewItem * item, const TQPoint &p, int /*c*/ )
{
	if ( item && ( ( button == Qt::LeftButton ) || ( button == Qt::RightButton ) ) && ( item->depth() > 1 ) )
	{
		accessMenu->setItemEnabled( 1, true );
		accessMenu->setItemEnabled( 2, true );
		accessMenu->setItemEnabled( 3, true );
		if ( item->text( 1 ) == "protected" )
		{
			accessMenu->setItemEnabled( 1, false );
		}
		if ( item->text( 1 ) == "public" )
		{
			accessMenu->setItemEnabled( 1, false );
			accessMenu->setItemEnabled( 2, false );
		}
		accessMenu->exec( p );

		/*        accessMenu->setItemEnabled(1, item->text(1) == "private" ? false : true );
		        accessMenu->setItemEnabled(2, item->text(1) == "protected" ? false : true );
		        accessMenu->setItemEnabled(3, item->text(1) == "public" ? false : true );*/
	}
}


void CppNewClassDialog::methods_view_mouseButtonPressed( int button , TQListViewItem * item, const TQPoint&p , int /*c*/ )
{
	if ( item && ( button == Qt::RightButton ) && ( item->depth() > 1 ) && ( ! item->text( 1 ).isEmpty() ) )
	{
		overMenu->exec( p );
	}
}

void CppNewClassDialog::extendFunctionality()
{
	if ( methods_view->selectedItem() )
		methods_view->selectedItem() ->setText( 1, i18n( "extend" ) );
}

void CppNewClassDialog::replaceFunctionality()
{
	if ( methods_view->selectedItem() )
		methods_view->selectedItem() ->setText( 1, i18n( "replace" ) );
}

void CppNewClassDialog::selectall_button_clicked()
{
	TQListViewItemIterator it( constructors_view );
	while ( it.current() )
	{
		PCheckListItem<FunctionDom> *curr;
		if ( ( curr = dynamic_cast<PCheckListItem<FunctionDom>* >( it.current() ) ) )
			curr->setOn( true );
		++it;
	}
}

void CppNewClassDialog::to_constructors_list_clicked()
{
	TQString templateAdd = templateStrFormatted().isEmpty() ? TQString() : templateStrFormatted() + "\n";
	TQString constructor_h = classNameFormatted();
	TQString constructor_cpp = templateAdd + classNameFormatted() + templateParamsFormatted() + "::" + classNameFormatted();
	constructor_h += "(";
	constructor_cpp += "(";
	TQString params_h;
	TQString params_cpp;
	TQString base;
	int unnamed = 1;

	TQListViewItemIterator it( constructors_view );
	while ( it.current() )
	{
		PCheckListItem<FunctionDom> *curr;
		if ( ( curr = dynamic_cast<PCheckListItem<FunctionDom>* >( it.current() ) ) )
		{
			if ( curr->isOn() && curr->parent() )
			{
				//fill the base classes list
				base += base.isEmpty() ? ": " : ", ";
				base += curr->parent() ->text( 0 );
				PCheckListItem<ClassDom> *p;
				if ( ( p = dynamic_cast<PCheckListItem<ClassDom>* >( curr->parent() ) ) )
				{
					base += p->templateAddition;
				}
				params_h += params_h.isEmpty() ? "" : ", ";

				//fill arguments for both constructor and base class initializer
				TQString cparams;
				TQString bparams;
				ArgumentList argumentList = curr->item() ->argumentList();
				for ( ArgumentList::const_iterator argIt = argumentList.begin();
				        argIt != argumentList.end(); ++argIt )
				{
					bparams += bparams.isEmpty() ? "" : ", ";
					cparams += cparams.isEmpty() ? "" : ", ";
					cparams += ( *argIt ) ->type() + " ";
					if ( ( *argIt ) ->name().isEmpty() )
					{
						cparams += TQString( "arg%1" ).arg( unnamed );
						bparams += TQString( "arg%1" ).arg( unnamed++ );
					}
					else
					{
						bparams += ( *argIt ) ->name();
						cparams += ( *argIt ) ->name();
					}
					if ( !( *argIt ) ->defaultValue().isEmpty() )
						bparams += " = " + ( *argIt ) ->defaultValue();
				}
				params_h += cparams;
				params_cpp = params_h;
				base += "(" + bparams + ")";
			}
		}
		++it;
	}

	constructor_cpp += params_cpp + ")" + base + TQString( "\n{\n}\n\n\n" );
	constructor_h += params_h + ");\n\n";

	constructors_h_edit->append( constructor_h );
	constructors_cpp_edit->append( constructor_cpp );
}



/* ----------------------------------------------------------
   ----------------------------------------------------------
   ----------------------------------------------------------
   ----------------------------------------------------------

    class CppNewClassDialog::ClassGenerator

   ----------------------------------------------------------
   ----------------------------------------------------------
   ----------------------------------------------------------
   ---------------------------------------------------------- */


bool CppNewClassDialog::ClassGenerator::validateInput()
{
	className = dlg.classname_edit->text().simplifyWhiteSpace();
	TQString temp = className;
	className.replace( TQRegExp( "template *<.*> *(class *)?" ), "" );
	templateStr = temp.replace( TQRegExp( TQRegExp_escape( className ) ), "" );
	templateStr.replace( TQRegExp( " *class *$" ), "" );

	templateParams = templateStr;
	templateParams.replace( TQRegExp( "^ *template *" ), "" );
	templateParams.replace( TQRegExp( " *class *" ), "" );
	templateParams.simplifyWhiteSpace();

	if ( className.isEmpty() )
	{
		KMessageBox::error( &dlg, i18n( "You must enter a classname." ) );
		return false;
	}

	header = dlg.header_edit->text().simplifyWhiteSpace();
	if ( header.isEmpty() )
	{
		KMessageBox::error( &dlg, i18n( "You must enter a name for the header file." ) );
		return false;
	}
	implementation = dlg.implementation_edit->text().simplifyWhiteSpace();
	if ( (!headeronly) &&  implementation.isEmpty() )
	{
		KMessageBox::error( &dlg, i18n( "You must enter a name for the implementation file." ) );
		return false;
	}

	/// \FIXME
    if ( ( header.find( '/' ) != -1 || implementation.find( '/' ) != -1 ) && !( dlg.m_part->project() ->options() & KDevProject::UsesTQMakeBuildSystem) )
	{
		KMessageBox::error( &dlg, i18n( "Generated files will always be added to the "
		                                "active directory, so you must not give an "
		                                "explicit subdirectory." ) );
		return false;
	}

	return true;
}


bool CppNewClassDialog::ClassGenerator::generate()
{
	if ( !validateInput() )
		return false;

	project = dlg.m_part->project();
	subDir = project->projectDirectory() + "/";
	if ( !project->activeDirectory().isEmpty() ){
		subDir += project->activeDirectory();
		subDir = TQDir::cleanDirPath(subDir);
		subDir += "/";
	}
	headerPath = subDir + header;
	implementationPath = subDir + implementation;

	if ( TQFileInfo( headerPath ).exists() || TQFileInfo( implementationPath ).exists() )
	{
		KMessageBox::error( &dlg, i18n( "TDevelop is not able to add classes "
		                                "to existing header or implementation files." ) );
		return false;
	}

    if( ( dlg.m_part->project() ->options() & KDevProject::UsesTQMakeBuildSystem) )
    {
        TQDir dir( TQFileInfo( project->projectDirectory()+TQString( TQChar( TQDir::separator() ) )+project->activeDirectory() + TQString( TQChar( TQDir::separator() ) ) + header ).dirPath() );
        kdDebug(9024) << "Dir for new file:" << dir.absPath() << endl;
        if( dir.isRelative() )
            dir.convertToAbs();

        TQValueStack<TQString> dirsToCreate;
        while( !dir.exists() )
        {
            dirsToCreate.push( dir.dirName() );
            dir.cdUp();
        }

        while( !dirsToCreate.isEmpty() )
        {
            dir.mkdir( dirsToCreate.top() );
            dir.cd( dirsToCreate.pop() );
        }
    }
	common_text();

	if(!headeronly) gen_implementation();

	gen_interface();

    TQStringList fileList;
    TQString file;
    if( project->activeDirectory().isEmpty() )
        file = header;
    else
      file = project->activeDirectory() + "/" + header;
    fileList.append ( file );
    if (!headeronly)
    {
        if( project->activeDirectory().isEmpty() )
            file = implementation;
        else
          file = project->activeDirectory() + "/" + implementation;
        fileList.append ( file );
    }
	project->addFiles ( fileList );

	return true;
}

void CppNewClassDialog::ClassGenerator::common_text()
{

	// common

	namespaceStr = dlg.namespace_edit->text();
	namespaces = TQStringList::split( TQString( "::" ), namespaceStr );

	childClass = dlg.childclass_box->isChecked();
	objc = dlg.objc_box->isChecked();
	qobject = dlg.qobject_box->isChecked();
	gtk = dlg.gtk_box->isChecked();
	headeronly = dlg.headeronly_box->isChecked();

	if ( ( dlg.baseclasses_view->childCount() == 0 ) && childClass )
		new TQListViewItem( dlg.baseclasses_view, TQWIDGET_OBJECT_NAME_STRING, "public" );
	if ( objc && ( dlg.baseclasses_view->childCount() == 0 ) )
		new TQListViewItem( dlg.baseclasses_view, "NSObject", "public" );

	if ( dlg.documentation_edit->text().isEmpty() && ( !dlg.gen_config->doc_box->isChecked() ) )
		doc = "";
	else
	{
		doc = TQString( "/**\n" );
		if ( !dlg.documentation_edit->text().isEmpty() )
		{
			doc.append( dlg.documentation_edit->text() );
			if ( dlg.gen_config->author_box->isChecked() )
				doc.append( "\n\n" );
		}
		TQString author = DomUtil::readEntry( *dlg.m_part->projectDom(), "/general/author" );
		TQString email = DomUtil::readEntry( *dlg.m_part->projectDom(), "/general/email" );
		if( !email.isEmpty() )
			author += TQString( " <%1>" ).arg( email );

		if ( dlg.gen_config->author_box->isChecked() )
			doc.append( "\t@author " + author + "\n" );
		doc.append( "*/" );
	}

	if ( !namespaceStr.isEmpty() )
	{
		for ( TQStringList::Iterator it = namespaces.begin(); it != namespaces.end(); ++it )
		{
			if ( !namespaceBeg.isEmpty() )
				namespaceBeg += "\n\n";
			if ( !namespaceEnd.isEmpty() )
				namespaceEnd += "\n\n";
			namespaceBeg += "namespace " + ( *it ) + " {";
			namespaceEnd += "}";
		}
	}

	//advanced constructor creation

	advConstructorsHeader = TQString();
	advConstructorsSource = TQString();
	if ( !dlg.constructors_h_edit->text().isEmpty() )
	{
		advConstructorsHeader = "    " + dlg.constructors_h_edit->text();
		advConstructorsHeader.replace( TQRegExp( "\n" ), "\n    " );
	}
	if ( !dlg.constructors_cpp_edit->text().isEmpty() )
	{
		advConstructorsSource = dlg.constructors_cpp_edit->text();
	}
	advConstructorsHeader.replace( TQRegExp( "[\\n ]*$" ), TQString() );
	advConstructorsSource.replace( TQRegExp( "[\\n ]*$" ), TQString() );

	//advanced method overriding

	advH_public = TQString();
	advH_public_slots = TQString();
	advH_protected = TQString();
	advH_protected_slots = TQString();
	advH_private = TQString();
	advH_private_slots = TQString();
	advCpp = TQString();

	TQListViewItemIterator it( dlg.methods_view );
	while ( it.current() )
	{
		PCheckListItem<FunctionDom> *curr;
		if ( ( curr = dynamic_cast<PCheckListItem<FunctionDom>* >( it.current() ) ) )
		{
			if ( curr->isOn() && ( curr->parent() ) && ( curr->parent() ->parent() ) )
			{
				TQString * adv_h = 0;
				if ( curr->item() ->access() == CodeModelItem::Private )
					adv_h = curr->item() ->isSlot() ? &advH_private_slots : &advH_private;
				if ( curr->item() ->access() == CodeModelItem::Protected )
					adv_h = curr->item() ->isSlot() ? &advH_protected_slots : &advH_protected;
				if ( curr->item() ->access() == CodeModelItem::Public )
					adv_h = curr->item() ->isSlot() ? &advH_public_slots : &advH_public;

				//        if (advCpp.isEmpty()) advCpp += "\n\n";

				TQString bcName = curr->parent() ->parent() ->text( 0 );
				PListViewItem<ClassDom> *bc;
				if ( ( bc = dynamic_cast<PListViewItem<ClassDom>* >( curr->parent() ->parent() ) ) )
				{
					bcName += bc->templateAddition;
				}
				genMethodDeclaration( curr->item(), className, templateStr, adv_h, &advCpp,
				                      ( curr->text( 1 ) == i18n( "extend" ) ) ? true : false, bcName );
			}
		}
		++it;
	}

	//advanced access control and upgrading
	TQListViewItemIterator ita( dlg.access_view );
	while ( ita.current() )
	{
		PListViewItem<VariableDom> *curr;
		PListViewItem<FunctionDom> *curr_m;
		if ( ( curr = dynamic_cast<PListViewItem<VariableDom>* >( ita.current() ) ) )
		{
			if ( ( !curr->text( 2 ).isEmpty() ) && ( curr->parent() ) && ( curr->parent() ->parent() ) )
			{
				TQString * adv_h = 0;
				if ( curr->text( 2 ) == "private" )
					adv_h = &advH_private;
				if ( curr->text( 2 ) == "public" )
					adv_h = &advH_public;
				if ( curr->text( 2 ) == "protected" )
					adv_h = &advH_protected;

				/*    if ((*adv_h).isEmpty())
				            *adv_h += "\n\n";*/
				if ( adv_h )
					*adv_h += TQString( "    using " ) + curr->parent() ->parent() ->text( 0 ) + "::" + curr->item() ->name() + ";\n";
			}
		}
		else if ( ( curr_m = dynamic_cast<PListViewItem<FunctionDom>* >( ita.current() ) ) )
		{
			if ( ( !curr_m->text( 2 ).isEmpty() ) && ( curr_m->parent() ) && ( curr_m->parent() ->parent() ) )
			{
				TQString * adv_h = 0;
				if ( curr_m->text( 2 ) == "private" )
					adv_h = &advH_private;
				if ( curr_m->text( 2 ) == "public" )
					adv_h = &advH_public;
				if ( curr_m->text( 2 ) == "protected" )
					adv_h = &advH_protected;

				/*    if ((*adv_h).isEmpty())
				        *adv_h += "\n\n";*/

				TQString methodName = curr_m->item() ->name();
				if ( !methodName.contains( TQRegExp( "^[a-zA-z_]" ) ) )
					methodName = "operator" + methodName;
				*adv_h += "    using " + curr_m->parent() ->parent() ->text( 0 ) + "::" + methodName + ";\n";
			}
		}
		++ita;
	}

	TQRegExp e( "[\\n ]*$" );
	advH_public.replace( e, TQString() );
	advH_public_slots.replace( e, TQString() );
	advH_protected.replace( e, TQString() );
	advH_protected_slots.replace( e, TQString() );
	advH_private.replace( e, TQString() );
	advH_private_slots.replace( e, TQString() );
	advCpp.replace( e, TQString() );
}

void CppNewClassDialog::ClassGenerator::genMethodDeclaration( FunctionDom method,
        TQString className, TQString templateStr, TQString *adv_h, TQString *adv_cpp, bool extend, TQString baseClassName )
{
	/*    if ((*adv_h).isEmpty())
	        *adv_h += "\n\n";*/
	TQString methodName = method->name();
	if ( !methodName.contains( TQRegExp( "^[a-zA-z_]" ) ) )
		methodName = "operator" + methodName;
	*adv_h += "    " + ( method->isVirtual() ? TQString( "virtual " ) : TQString( "" ) )
	          + ( method->isStatic() ? TQString( "static " ) : TQString( "" ) )
	          + method->resultType() + " " + methodName + "(";
	if ( !templateStr.isEmpty() )
		* adv_cpp += templateStr + "\n";
	*adv_cpp += method->resultType() + " " + className + templateParams + "::" + methodName + "(";

	TQString bparams;
	TQString cparams;
	int unnamed = 1;

	ArgumentList argumentList = method->argumentList();
	for ( ArgumentList::const_iterator argIt = argumentList.begin();
	        argIt != argumentList.end(); ++argIt )
	{
		bparams += bparams.isEmpty() ? "" : ", ";
		cparams += cparams.isEmpty() ? "" : ", ";
		cparams += ( *argIt ) ->type() + " ";
		if ( ( *argIt ) ->name().isEmpty() )
		{
			cparams += TQString( "arg%1" ).arg( unnamed );
			bparams += TQString( "arg%1" ).arg( unnamed++ );
		}
		else
		{
			bparams += ( *argIt ) ->name();
			cparams += ( *argIt ) ->name();
		}
		if ( !( *argIt ) ->defaultValue().isEmpty() )
			bparams += " " + ( *argIt ) ->defaultValue();
	}
	*adv_h += cparams + ")" + ( method->isConstant() ? " const" : "" ) + ";\n";
	*adv_cpp += cparams + ")" + ( method->isConstant() ? " const" : "" ) + "\n{\n";
	if ( extend )
		* adv_cpp += ( ( method->resultType() == "void" ) ? "    " : "    return " ) +
		             baseClassName + "::" + methodName + "(" + bparams + ");\n";
	*adv_cpp += "}\n\n";
}


void CppNewClassDialog::ClassGenerator::gen_implementation()
{

	// implementation

	TQString classImpl;
	TQFileInfo fi( implementationPath );
	TQString module = fi.baseName();
	TQString basefilename = fi.baseName( true );

	if ( dlg.filetemplate_box->isChecked() )
	{
		/*    TQDomDocument dom = *dlg.m_part->projectDom();
		    if(DomUtil::readBoolEntry(dom,"/cppsupportpart/filetemplates/choosefiles",false))
		      classImpl = FileTemplate::read(dlg.m_part, DomUtil::readEntry(dom,"/cppsupportpart/filetemplates/implementationURL",""), FileTemplate::Custom);
		    else*/
		classImpl = FileTemplate::read( dlg.m_part, fi.extension( true ) );
	}

	classImpl.replace( TQRegExp( "\\$MODULE\\$" ), module );
	classImpl.replace( TQRegExp( "\\$FILENAME\\$" ), basefilename );

	if ( objc )
	{
		classImpl += dlg.gen_config->objcSource();
	}
	else if ( gtk )
	{
		classImpl += dlg.gen_config->gtkSource();
	}
	else
	{
		classImpl += dlg.gen_config->cppSource();
		/*    classImpl += TQString(
					 "#include \"$HEADER$\"\n"
					 "\n"
					 "\n")
		      + namespaceBeg
		      + ( advConstructorsSource.isEmpty() ? TQString("$CLASSNAME$::$CLASSNAME$($ARGS$)\n"
				"$BASEINITIALIZER$"
				"{\n"
				"}\n") : advConstructorsSource )
		      + TQString("\n"
				"$CLASSNAME$::~$CLASSNAME$()\n"
				"{\n"
				"}\n")
		      + advCpp
		      + namespaceEnd;*/
	}

	TQString relPath;
	for ( int i = implementation.findRev( '/' ); i != -1; i = implementation.findRev( '/', --i ) )
		relPath += "../";

	TQString constructors = ( advConstructorsSource.isEmpty() ? TQString( "$TEMPLATESTR$\n$CLASSNAME$$TEMPLATEPARAMS$::$CLASSNAME$($ARGS$)\n"
	                         "$BASEINITIALIZER$"
	                         "{\n"
	                         "}" ) : advConstructorsSource )
	                       + TQString( "\n\n\n"
	                                  "$TEMPLATESTR$\n$CLASSNAME$$TEMPLATEPARAMS$::~$CLASSNAME$()\n"
	                                  "{\n"
	                                  "}\n" );

	tqWarning( "NEW CLASS: constructors = %s", constructors.latin1() );

	if ( childClass )
	{
		if( dlg.m_part->qtBuildConfig()->version() == 3 )
		{
			argsH = "TQWidget *parent = 0, const char *name = 0";
			argsCpp = "TQWidget *parent, const char *name";
		}
		else
		{
			argsH = "TQWidget *parent = 0";
			argsCpp = "TQWidget *parent";
		}
	}
	else if ( qobject )
	{
		if( dlg.m_part->qtBuildConfig()->version() == 3 )
		{
			argsH = "TQObject *parent = 0, const char *name = 0";
			argsCpp = "TQObject *parent, const char *name";
		}
		else
		{
			argsH = "TQObject *parent = 0";
			argsCpp = "TQObject *parent";
		}
	}
	else
	{
		argsH = "";
		argsCpp = "";
	}
	TQString baseInitializer;

	if ( childClass && ( dlg.baseclasses_view->childCount() == 0 ) )
	{
		if( dlg.m_part->qtBuildConfig()->version() == 3 )
			baseInitializer = "  : TQWidget(parent, name)";
		else
			baseInitializer = "  : TQWidget(parent)";
	}
	else if ( qobject && ( dlg.baseclasses_view->childCount() == 0 ) )
	{
		if( dlg.m_part->qtBuildConfig()->version() == 3 )
			baseInitializer = "  : TQObject(parent, name)";
		else
			baseInitializer = "  : TQObject(parent)";
	}
	else if ( dlg.baseclasses_view->childCount() != 0 )
	{
		TQListViewItemIterator it( dlg.baseclasses_view );
		baseInitializer += " : ";
		while ( it.current() )
		{
			if ( !it.current() ->text( 0 ).isEmpty() )
			{
				if ( baseInitializer != " : " )
				{
					baseInitializer += ", ";
				}

				if ( childClass && ( baseInitializer == " : " ) )
				{
					if( dlg.m_part->qtBuildConfig()->version() == 3 )
						baseInitializer += it.current()->text( 0 ) + "(parent, name)";
					else
						baseInitializer += it.current()->text( 0 ) + "(parent)";
				}
				else if ( qobject && ( baseInitializer == " : " ) )
				{
					if( dlg.m_part->qtBuildConfig()->version() == 3 )
						baseInitializer += it.current()->text( 0 ) + "(parent, name)";
					else
						baseInitializer += it.current()->text( 0 ) + "(parent)";
				}
				else
				{
					baseInitializer += it.current()->text( 0 ) + "()";
				}
			}
			++it;
		}
		baseInitializer += "\n";
	}

	constructors.replace( TQRegExp( "\\$BASEINITIALIZER\\$" ), baseInitializer );
	constructors.replace( TQRegExp( "\\$CLASSNAME\\$" ), className );
	//  tqWarning("NEW CLASS: constructors = %s", constructors.latin1());
	if ( templateStr.isEmpty() )
	{
		constructors.replace( TQRegExp( "\\$TEMPLATESTR\\$\\n" ), "" );
		constructors.replace( TQRegExp( "\\$TEMPLATEPARAMS\\$" ), "" );
	}
	else
	{
		constructors.replace( TQRegExp( "\\$TEMPLATESTR\\$" ), templateStr );
		constructors.replace( TQRegExp( "\\$TEMPLATEPARAMS\\$" ), templateParams );
		classImpl.replace( TQRegExp( "#include \"\\$HEADER\\$\"\\n" ), "" );
	}
	//  tqWarning("NEW CLASS: constructors = %s", constructors.latin1());
	constructors.replace( TQRegExp( "\\$ARGS\\$" ), argsCpp );
	//  tqWarning("NEW CLASS: constructors = %s", constructors.latin1());


	//remove unnesessary carriadge returns
	TQString hp = relPath + header;
	beautifySource( classImpl, hp, className, namespaceBeg, constructors, advCpp, namespaceEnd, implementation );

	classImpl.replace( TQRegExp( "\\$HEADER\\$" ), relPath + header );
	classImpl.replace( TQRegExp( "\\$CLASSNAME\\$" ), className );
	classImpl.replace( TQRegExp( "\\$NAMESPACEBEG\\$" ), namespaceBeg );
	classImpl.replace( TQRegExp( "\\$CONSTRUCTORDEFINITIONS\\$" ), constructors );
	classImpl.replace( TQRegExp( "\\$DEFINITIONS\\$" ), advCpp );
	classImpl.replace( TQRegExp( "\\$NAMESPACEEND\\$" ), namespaceEnd );
	classImpl.replace( TQRegExp( "\\$FILENAME\\$" ), implementation );

	if ( ( dlg.m_part->project() ) && ( childClass || qobject ) && ( dlg.m_part->project() ->options() & KDevProject::UsesAutotoolsBuildSystem ) )
	{
		TQString moc = header;
		moc.replace( TQRegExp( "\\..*" ), ".moc" );
		classImpl += "#include \"" + moc + "\"\n";
	}

	if ( dlg.gen_config->reformat_box->isChecked() )
	{
		KDevSourceFormatter * fmt = dlg.m_part->extension<KDevSourceFormatter>( "TDevelop/SourceFormatter" );
		if ( fmt )
			classImpl = fmt->formatSource( classImpl );
	}

	kdDebug( 9007 ) << "implementationPath = " << implementationPath << endl;

	TQFile ifile( implementationPath );
	if ( !ifile.open( IO_WriteOnly ) )
	{
		KMessageBox::error( &dlg, i18n( "Cannot write to implementation file" ) );
		return ;
	}
	TQTextStream istream( &ifile );
	istream << classImpl;
	ifile.close();

	KURL u;
	u.setPath( implementationPath );
	dlg.m_part->partController()->editDocument( u );
}


void CppNewClassDialog::ClassGenerator::gen_interface()
{
	// interface

	TQString classIntf;
	TQFileInfo fi( headerPath );
	TQString module = fi.baseName();
	TQString basefilename = fi.baseName( true );

	if ( dlg.filetemplate_box->isChecked() )
	{
		/*    TQDomDocument dom = *dlg.m_part->projectDom();
		    if(DomUtil::readBoolEntry(dom,"/cppsupportpart/filetemplates/choosefiles",false))
		      classIntf = FileTemplate::read(dlg.m_part, DomUtil::readEntry(dom,"/cppsupportpart/filetemplates/interfaceURL",""), FileTemplate::Custom);
		    else*/
		classIntf = FileTemplate::read( dlg.m_part, fi.extension( true ) );
	}

	classIntf.replace( TQRegExp( "\\$MODULE\\$" ), module );
	classIntf.replace( TQRegExp( "\\$FILENAME\\$" ), basefilename );

	if ( objc )
	{
		classIntf += dlg.gen_config->objcHeader();
	}
	else if ( gtk )
	{
		classIntf += dlg.gen_config->gtkHeader();
	}
	else
	{
		classIntf += dlg.gen_config->cppHeader();
		/*    classIntf = TQString("\n"
					"#ifndef $HEADERGUARD$\n"
					"#define $HEADERGUARD$\n"
					"\n"
					"$INCLUDEBASEHEADER$\n"
					"\n")
		      + namespaceBeg
		      + TQString("class $CLASSNAME$$INHERITANCE$\n"
				"{\n"
				"$TQOBJECT$"
				"public:\n")
		      + ( advConstructorsHeader.isEmpty() ? TQString("    $CLASSNAME$($ARGS$);\n") : advConstructorsHeader )
		      + TQString("\n    ~$CLASSNAME$();\n")
		      + advH_public
		      + (advH_public_slots.isEmpty() ? TQString::fromLatin1("") : ("\n\npublic slots:" + advH_public_slots))
		      + (advH_protected.isEmpty() ? TQString::fromLatin1("") : ("\n\nprotected:" + advH_protected))
		      + (advH_protected_slots.isEmpty() ? TQString::fromLatin1("") : ("\n\nprotected slots:" + advH_protected_slots))
		      + (advH_private.isEmpty() ? TQString::fromLatin1("") : ("\n\nprivate:" + advH_private))
		      + (advH_private_slots.isEmpty() ? TQString::fromLatin1("") : ("\n\nprivate slots:" + advH_private_slots))
		      + TQString("};\n"
				"\n")
		      + namespaceEnd
		      +     "#endif\n";*/
	}

	TQString headerGuard;
	switch ( dlg.gen_config->defCase() )
	{
	case ClassGeneratorConfig::UpperCase:
        headerGuard = namespaceStr.upper() + header.mid( header.findRev( "/" )+1 ).upper();
		break;
	case ClassGeneratorConfig::LowerCase:
        headerGuard = namespaceStr.lower() + header.mid( header.findRev( "/" )+1 ).lower();
		break;
	case ClassGeneratorConfig::SameAsFileCase:
        headerGuard = dlg.header_edit->text().mid( dlg.header_edit->text().findRev( "/" )+1 );
		break;
	case ClassGeneratorConfig::SameAsClassCase:
        headerGuard = namespaceStr + header.mid( header.findRev( "/" )+1 );
		break;
	}

	headerGuard.replace( TQRegExp( "\\." ), "_" );
	headerGuard.replace( TQRegExp( "::" ), "_" );
	TQString includeBaseHeader;
	if( dlg.m_part->qtBuildConfig()->isUsed() )
	{
		if( childClass && ( dlg.baseclasses_view->childCount() == 0 ) )
		{
			if( dlg.m_part->qtBuildConfig()->version() == 3 )
				includeBaseHeader = "#include <tqwidget.h>";
			else
				includeBaseHeader = "#include <TQWidget>";
		}
		else if( qobject && ( dlg.baseclasses_view->childCount() == 0 ) )
		{
			if( dlg.m_part->qtBuildConfig()->version() == 3 )
				includeBaseHeader = "#include <tqobject.h>";
			else
				includeBaseHeader = "#include <TQObject>";
		}
	}

	if ( objc )
	{
		if ( dlg.baseclasses_view->firstChild() )
			if ( dlg.baseclasses_view->firstChild() ->text( 0 ) != "NSObject" )
				if ( !dlg.baseclasses_view->firstChild() ->text( 3 ).isEmpty() )
					includeBaseHeader = "#include "
					                    + ( dlg.baseclasses_view->firstChild() ->text( 2 ).toInt() == 0 ? TQString( "<" ) : TQString( "\"" ) )
					                    + dlg.baseclasses_view->firstChild() ->text( 3 )
					                    + ( dlg.baseclasses_view->firstChild() ->text( 2 ).toInt() == 0 ? TQString( ">" ) : TQString( "\"" ) );
	}
	else
	{
		TQListViewItemIterator it( dlg.baseclasses_view );
		while ( it.current() )
		{
			if ( !it.current() ->text( 0 ).isEmpty() )
				if ( !it.current() ->text( 3 ).isEmpty() )
					//          if ((!childClass) || (it.current()->text(0) != TQWIDGET_OBJECT_NAME_STRING))
					includeBaseHeader += ( includeBaseHeader.isEmpty() ? TQString( "" ) : TQString( "\n" ) ) + TQString::fromLatin1( "#include " ) +
					                     ( it.current() ->text( 2 ).toInt() == 0 ? TQString( "<" ) : TQString( "\"" ) )
					                     + it.current() ->text( 3 )
					                     + ( it.current() ->text( 2 ).toInt() == 0 ? TQString( ">" ) : TQString( "\"" ) );
			++it;
		}
	}

	TQString author = DomUtil::readEntry( *dlg.m_part->projectDom(), "/general/author" );
	TQString email = DomUtil::readEntry( *dlg.m_part->projectDom(), "/general/email" );
	if( !email.isEmpty() )
		author += TQString( " <%1>" ).arg( email );

	TQString inheritance;
	if ( dlg.baseclasses_view->childCount() > 0 )
	{
		inheritance += " : ";

		TQListViewItemIterator it( dlg.baseclasses_view );
		while ( it.current() )
		{
			if ( !it.current() ->text( 0 ).isEmpty() )
			{
				if ( inheritance != " : " )
					inheritance += ", ";
				if ( it.current() ->text( 1 ).contains( "virtual" ) )
					inheritance += "virtual ";
				if ( it.current() ->text( 1 ).contains( "public" ) )
					inheritance += "public ";
				if ( it.current() ->text( 1 ).contains( "protected" ) )
					inheritance += "protected ";
				if ( it.current() ->text( 1 ).contains( "private" ) )
					inheritance += "private ";
				inheritance += it.current() ->text( 0 );
			}
			++it;
		}
	}
	else if ( qobject )
		inheritance += ": public TQObject";

	TQString constructors = TQString( advConstructorsHeader.isEmpty() ?
	                                TQString( "    $CLASSNAME$($ARGS$);" ) : advConstructorsHeader )
	                       + TQString( "\n\n    ~$CLASSNAME$();" );

	constructors.replace( TQRegExp( "\\$CLASSNAME\\$" ), className );
	constructors.replace( TQRegExp( "\\$ARGS\\$" ), argsH );

	TQString qobjectStr;
	if ( childClass || qobject )
		qobjectStr = "Q_OBJECT\n";


	TQString baseclass;
	if ( dlg.baseclasses_view->childCount() > 0 )
		baseclass = dlg.baseclasses_view->firstChild() ->text( 0 );
	//remove unnesessary carriadge returns
	beautifyHeader( classIntf, headerGuard, includeBaseHeader, author, doc, className, templateStr,
	                baseclass, inheritance, qobjectStr, argsH,
	                header, namespaceBeg, constructors, advH_public, advH_public_slots,
	                advH_protected, advH_protected_slots, advH_private, advH_private_slots, namespaceEnd );


	classIntf.replace( TQRegExp( "\\$HEADERGUARD\\$" ), headerGuard );
	classIntf.replace( TQRegExp( "\\$INCLUDEBASEHEADER\\$" ), includeBaseHeader );
	classIntf.replace( TQRegExp( "\\$AUTHOR\\$" ), author );
	classIntf.replace( TQRegExp( "\\$DOC\\$" ), doc );
	classIntf.replace( TQRegExp( "\\$TEMPLATE\\$" ), templateStr );
	classIntf.replace( TQRegExp( "\\$CLASSNAME\\$" ), className );
	if ( dlg.baseclasses_view->childCount() > 0 )
		classIntf.replace( TQRegExp( "\\$BASECLASS\\$" ), dlg.baseclasses_view->firstChild() ->text( 0 ) );
	classIntf.replace( TQRegExp( "\\$INHERITANCE\\$" ), inheritance );
	classIntf.replace( TQRegExp( "\\$TQOBJECT\\$" ), qobjectStr );
	classIntf.replace( TQRegExp( "\\$ARGS\\$" ), argsH );
	classIntf.replace( TQRegExp( "\\$FILENAME\\$" ), header );
	classIntf.replace( TQRegExp( "\\$NAMESPACEBEG\\$" ), namespaceBeg );
	classIntf.replace( TQRegExp( "\\$CONSTRUCTORDECLARATIONS\\$" ), constructors );
	classIntf.replace( TQRegExp( "\\$PUBLICDECLARATIONS\\$" ), advH_public );
	classIntf.replace( TQRegExp( "\\$PUBLICSLOTS\\$" ), advH_public_slots );
	classIntf.replace( TQRegExp( "\\$PROTECTEDDECLARATIONS\\$" ), TQString( "protected:\n" ) + advH_protected );
	classIntf.replace( TQRegExp( "\\$PROTECTEDSLOTS\\$" ), TQString( "protected slots:\n" ) + advH_protected_slots );
	classIntf.replace( TQRegExp( "\\$PRIVATEDECLARATIONS\\$" ), TQString( "private:\n" ) + advH_private );
	classIntf.replace( TQRegExp( "\\$PRIVATESLOTS\\$" ), TQString( "private slots:\n" ) + advH_private_slots );
	classIntf.replace( TQRegExp( "\\$NAMESPACEEND\\$" ), namespaceEnd );

	if ( !templateStr.isEmpty() && (!headeronly) )
		classIntf.replace( TQRegExp( "#endif" ), "#include \"" + dlg.implementation_edit->text() + "\"\n\n#endif" );

	if ( dlg.gen_config->reformat_box->isChecked() )
	{
		KDevSourceFormatter * fmt = dlg.m_part->extension<KDevSourceFormatter>( "TDevelop/SourceFormatter" );
		if ( fmt )
			classIntf = fmt->formatSource( classIntf );
	}

	TQFile hfile( headerPath );
	if ( !hfile.open( IO_WriteOnly ) )
	{
		KMessageBox::error( &dlg, i18n( "Cannot write to header file" ) );
		return ;
	}
	TQTextStream hstream( &hfile );
	hstream << classIntf;
	hfile.close();

	KURL u;
	u.setPath( headerPath );
	dlg.m_part->partController()->editDocument( u );
}

void CppNewClassDialog::ClassGenerator::beautifyHeader( TQString &templ, TQString &headerGuard,
        TQString &includeBaseHeader, TQString &author, TQString &doc, TQString &className, TQString &templateStr,
        TQString &baseclass, TQString &inheritance, TQString &qobjectStr, TQString &args,
        TQString &header, TQString &namespaceBeg, TQString &constructors, TQString &advH_public, TQString &advH_public_slots,
        TQString &advH_protected, TQString &advH_protected_slots, TQString &advH_private, TQString &advH_private_slots,
        TQString &namespaceEnd )
{
	if ( headerGuard.isEmpty() )
		templ.replace( TQRegExp( "\\$HEADERGUARD\\$[\\n ]*" ), TQString() );
	if ( includeBaseHeader.isEmpty() )
		templ.replace( TQRegExp( "\\$INCLUDEBASEHEADER\\$[\\n ]*" ), TQString() );
	if ( author.isEmpty() )
		templ.replace( TQRegExp( "\\$AUTHOR\\$[\\n ]*" ), TQString() );
	if ( doc.isEmpty() )
		templ.replace( TQRegExp( "\\$DOC\\$[\\n ]*" ), TQString() );
	if ( className.isEmpty() )
		templ.replace( TQRegExp( "\\$CLASSNAME\\$[\\n ]*" ), TQString() );
	if ( templateStr.isEmpty() )
		templ.replace( TQRegExp( "\\$TEMPLATE\\$[\\n ]*" ), TQString() );
	if ( baseclass.isEmpty() )
		templ.replace( TQRegExp( "\\$BASECLASS\\$[\\n ]*" ), TQString() );
	if ( inheritance.isEmpty() )
		templ.replace( TQRegExp( "\\$INHERITANCE\\$[\\n ]*" ), TQString() );
	if ( qobjectStr.isEmpty() )
		templ.replace( TQRegExp( "\\$TQOBJECT\\$[\\n ]*" ), TQString() );
	if ( args.isEmpty() )
		templ.replace( TQRegExp( "\\$ARGS\\$[\\n ]*" ), TQString() );
	if ( header.isEmpty() )
		templ.replace( TQRegExp( "\\$FILENAME\\$[\\n ]*" ), TQString() );
	if ( namespaceBeg.isEmpty() )
		templ.replace( TQRegExp( "\\$NAMESPACEBEG\\$[\\n ]*" ), TQString() );
	if ( constructors.isEmpty() )
		templ.replace( TQRegExp( "\\$CONSTRUCTORDECLARATIONS\\$[\\n ]*" ), TQString() );
	if ( advH_public.isEmpty() )
		templ.replace( TQRegExp( "\\$PUBLICDECLARATIONS\\$[\\n ]*" ), TQString() );
	if ( advH_public_slots.isEmpty() )
		templ.replace( TQRegExp( "\\$PUBLICSLOTS\\$[\\n ]*" ), TQString() );
	if ( advH_protected.isEmpty() )
		templ.replace( TQRegExp( "\\$PROTECTEDDECLARATIONS\\$[\\n ]*" ), TQString() );
	if ( advH_protected_slots.isEmpty() )
		templ.replace( TQRegExp( "\\$PROTECTEDSLOTS\\$[\\n ]*" ), TQString() );
	if ( advH_private.isEmpty() )
		templ.replace( TQRegExp( "\\$PRIVATEDECLARATIONS\\$[\\n ]*" ), TQString() );
	if ( advH_private_slots.isEmpty() )
		templ.replace( TQRegExp( "\\$PRIVATESLOTS\\$[\\n ]*" ), TQString() );
	if ( namespaceEnd.isEmpty() )
		templ.replace( TQRegExp( "\\$NAMESPACEEND\\$[\\n ]*" ), TQString() );
}


void CppNewClassDialog::ClassGenerator::beautifySource( TQString &templ, TQString &header, TQString &className, TQString &namespaceBeg,
        TQString &constructors, TQString &advCpp, TQString &namespaceEnd, TQString &implementation )
{
	if ( header.isEmpty() )
		templ.replace( TQRegExp( "\\$HEADER\\$[\\n ]*" ), TQString() );
	if ( className.isEmpty() )
		templ.replace( TQRegExp( "\\$CLASSNAME\\$[\\n ]*" ), TQString() );
	if ( namespaceBeg.isEmpty() )
		templ.replace( TQRegExp( "\\$NAMESPACEBEG\\$[\\n ]*" ), TQString() );
	if ( constructors.isEmpty() )
		templ.replace( TQRegExp( "\\$CONSTRUCTORDEFINITIONS\\$[\\n ]*" ), TQString() );
	if ( advCpp.isEmpty() )
		templ.replace( TQRegExp( "\\$DEFINITIONS\\$[\\n ]*" ), TQString() );
	if ( namespaceEnd.isEmpty() )
		templ.replace( TQRegExp( "\\$NAMESPACEEND\\$[\\n ]*" ), TQString() );
	if ( implementation.isEmpty() )
		templ.replace( TQRegExp( "\\$FILENAME\\$[\\n ]*" ), TQString() );
}

TQString CppNewClassDialog::classNameFormatted( )
{
	return classNameFormatted( classname_edit->text() );
}

TQString CppNewClassDialog::classNameFormatted( const TQString &name )
{
	TQString temp = name.simplifyWhiteSpace();
	return temp.replace( TQRegExp( "template *<.*> *(class *)?" ), "" );
}


TQString CppNewClassDialog::templateStrFormatted( )
{
	return templateStrFormatted( classname_edit->text() );
}

TQString CppNewClassDialog::templateStrFormatted( const TQString &name )
{
	TQString className = name.simplifyWhiteSpace();
	TQString temp = className;
	className.replace( TQRegExp( "template *<.*> *(class *)?" ), "" );
	TQString templateStr = temp.replace( TQRegExp( TQRegExp_escape( className ) ), "" );
	templateStr.replace( TQRegExp( " *class *$" ), "" );
	return templateStr;
}

TQString CppNewClassDialog::templateParamsFormatted( )
{
	return templateParamsFormatted( classname_edit->text() );
}

TQString CppNewClassDialog::templateParamsFormatted( const TQString &name )
{
	TQString className = name.simplifyWhiteSpace();
	TQString temp = className;
	className.replace( TQRegExp( "template *<.*> *(class *)?" ), "" );
	TQString templateStr = temp.replace( TQRegExp( TQRegExp_escape( className ) ), "" );
	templateStr.replace( TQRegExp( " *class *$" ), "" );

	TQString templateParams = templateStr;
	templateParams.replace( TQRegExp( "^ *template *" ), "" );
	templateParams.replace( TQRegExp( " *class *" ), "" );
	templateParams.simplifyWhiteSpace();

	return templateParams;
}

TQString CppNewClassDialog::templateActualParamsFormatted( const TQString & name )
{
	TQString className = name.simplifyWhiteSpace();
	TQString temp = className;
	className.replace( TQRegExp( "<.*> *" ), "" );
	TQString templateStr = temp.replace( TQRegExp( TQRegExp_escape( className ) ), "" );
	return templateStr;
}

void CppNewClassDialog::removeTemplateParams( TQString & name )
{
	name.replace( TQRegExp( "<.*> *" ), "" );
}

bool CppNewClassDialog::isDestructor( TQString className, const FunctionDom &method )
{
	if ( m_part->formatModelItem( method.data() ).contains( TQRegExp( " *~ *" + className ) ) )
		return true;
	return false;
}

void CppNewClassDialog::headeronly_box_stateChanged(int val)
{
    implementation_edit->setEnabled(!val);
}

#include "cppnewclassdlg.moc"
