%{CPP_TEMPLATE}

#include <TQtGui>
#include "%{APPNAMELC}.h"

#include <TQTextEdit>
#include <TQTextStream>
#include <TQCloseEvent>
#include <TQFileDialog>

%{APPNAME}::%{APPNAME}()
{
      textEdit = new TQTextEdit;
      setCentralWidget(textEdit);
      
      createActions();
      createMenus();
      createToolBars();
      createStatusBar();
      
      readSettings();
      
      connect(textEdit->document(), TQT_SIGNAL(contentsChanged()),
            this, TQT_SLOT(documentWasModified()));
      
      setCurrentFile("");
}

void %{APPNAME}::closeEvent(TQCloseEvent *event)
{
      if (maybeSave()) {
            writeSettings();
            event->accept();
      } else {
            event->ignore();
      }
}

void %{APPNAME}::newFile()
{
      if (maybeSave()) {
            textEdit->clear();
            setCurrentFile("");
      }
}

void %{APPNAME}::open()
{
      if (maybeSave()) {
            TQString fileName = TQFileDialog::getOpenFileName(this);
            if (!fileName.isEmpty())
            loadFile(fileName);
      }
}

bool %{APPNAME}::save()
{
      if (curFile.isEmpty()) {
            return saveAs();
      } else {
            return saveFile(curFile);
      }
}

bool %{APPNAME}::saveAs()
{
      TQString fileName = TQFileDialog::getSaveFileName(this);
      if (fileName.isEmpty())
            return false;

      return saveFile(fileName);
}

void %{APPNAME}::about()
{
      TQMessageBox::about(this, tr("About Application"),
            tr("The <b>Application</b> example demonstrates how to "
                  "write modern GUI applications using TQt, with a menu bar, "
                  "toolbars, and a status bar."));
}

void %{APPNAME}::documentWasModified()
{
      setWindowModified(true);
}

void %{APPNAME}::createActions()
{
      newAct = new TQAction(TQIcon(":/filenew.xpm"), tr("&New"), this);
      newAct->setShortcut(tr("Ctrl+N"));
      newAct->setStatusTip(tr("Create a new file"));
      connect(newAct, TQT_SIGNAL(triggered()), this, TQT_SLOT(newFile()));

      openAct = new TQAction(TQIcon(":/fileopen.xpm"), tr("&Open..."), this);
      openAct->setShortcut(tr("Ctrl+O"));
      openAct->setStatusTip(tr("Open an existing file"));
      connect(openAct, TQT_SIGNAL(triggered()), this, TQT_SLOT(open()));

      saveAct = new TQAction(TQIcon(":/filesave.xpm"), tr("&Save"), this);
      saveAct->setShortcut(tr("Ctrl+S"));
      saveAct->setStatusTip(tr("Save the document to disk"));
      connect(saveAct, TQT_SIGNAL(triggered()), this, TQT_SLOT(save()));

      saveAsAct = new TQAction(tr("Save &As..."), this);
      saveAsAct->setStatusTip(tr("Save the document under a new name"));
      connect(saveAsAct, TQT_SIGNAL(triggered()), this, TQT_SLOT(saveAs()));

      exitAct = new TQAction(tr("E&xit"), this);
      exitAct->setShortcut(tr("Ctrl+Q"));
      exitAct->setStatusTip(tr("Exit the application"));
      connect(exitAct, TQT_SIGNAL(triggered()), this, TQT_SLOT(close()));

      cutAct = new TQAction(TQIcon(":/editcut.xpm"), tr("Cu&t"), this);
      cutAct->setShortcut(tr("Ctrl+X"));
      cutAct->setStatusTip(tr("Cut the current selection's contents to the "
                              "clipboard"));
      connect(cutAct, TQT_SIGNAL(triggered()), textEdit, TQT_SLOT(cut()));

      copyAct = new TQAction(TQIcon(":/editcopy.xpm"), tr("&Copy"), this);
      copyAct->setShortcut(tr("Ctrl+C"));
      copyAct->setStatusTip(tr("Copy the current selection's contents to the "
                              "clipboard"));
      connect(copyAct, TQT_SIGNAL(triggered()), textEdit, TQT_SLOT(copy()));

      pasteAct = new TQAction(TQIcon(":/editpaste.xpm"), tr("&Paste"), this);
      pasteAct->setShortcut(tr("Ctrl+V"));
      pasteAct->setStatusTip(tr("Paste the clipboard's contents into the current "
                              "selection"));
      connect(pasteAct, TQT_SIGNAL(triggered()), textEdit, TQT_SLOT(paste()));

      aboutAct = new TQAction(tr("&About"), this);
      aboutAct->setStatusTip(tr("Show the application's About box"));
      connect(aboutAct, TQT_SIGNAL(triggered()), this, TQT_SLOT(about()));

      aboutTQtAct = new TQAction(tr("About &TQt"), this);
      aboutTQtAct->setStatusTip(tr("Show the TQt library's About box"));
      connect(aboutTQtAct, TQT_SIGNAL(triggered()), tqApp, TQT_SLOT(aboutTQt()));

      cutAct->setEnabled(false);
      copyAct->setEnabled(false);
      connect(textEdit, TQT_SIGNAL(copyAvailable(bool)),
            cutAct, TQT_SLOT(setEnabled(bool)));
      connect(textEdit, TQT_SIGNAL(copyAvailable(bool)),
            copyAct, TQT_SLOT(setEnabled(bool)));
}

void %{APPNAME}::createMenus()
{
      fileMenu = menuBar()->addMenu(tr("&File"));
      fileMenu->addAction(newAct);
      fileMenu->addAction(openAct);
      fileMenu->addAction(saveAct);
      fileMenu->addAction(saveAsAct);
      fileMenu->addSeparator();
      fileMenu->addAction(exitAct);

      editMenu = menuBar()->addMenu(tr("&Edit"));
      editMenu->addAction(cutAct);
      editMenu->addAction(copyAct);
      editMenu->addAction(pasteAct);

      menuBar()->addSeparator();

      helpMenu = menuBar()->addMenu(tr("&Help"));
      helpMenu->addAction(aboutAct);
      helpMenu->addAction(aboutTQtAct);
}

void %{APPNAME}::createToolBars()
{
      fileToolBar = addToolBar(tr("File"));
      fileToolBar->addAction(newAct);
      fileToolBar->addAction(openAct);
      fileToolBar->addAction(saveAct);

      editToolBar = addToolBar(tr("Edit"));
      editToolBar->addAction(cutAct);
      editToolBar->addAction(copyAct);
      editToolBar->addAction(pasteAct);
}

void %{APPNAME}::createStatusBar()
{
      statusBar()->showMessage(tr("Ready"));
}

void %{APPNAME}::readSettings()
{
      TQSettings settings("Trolltech", "Application Example");
      TQPoint pos = settings.value("pos", TQPoint(200, 200)).toPoint();
      TQSize size = settings.value("size", TQSize(400, 400)).toSize();
      resize(size);
      move(pos);
}

void %{APPNAME}::writeSettings()
{
      TQSettings settings("Trolltech", "Application Example");
      settings.setValue("pos", pos());
      settings.setValue("size", size());
}

bool %{APPNAME}::maybeSave()
{
      if (textEdit->document()->isModified()) {
            int ret = TQMessageBox::warning(this, tr("Application"),
                        tr("The document has been modified.\n"
                        "Do you want to save your changes?"),
                        TQMessageBox::Yes | TQMessageBox::Default,
                        TQMessageBox::No,
                        TQMessageBox::Cancel | TQMessageBox::Escape);
            if (ret == TQMessageBox::Yes)
            return save();
            else if (ret == TQMessageBox::Cancel)
            return false;
      }
      return true;
}

void %{APPNAME}::loadFile(const TQString &fileName)
{
      TQFile file(fileName);
      if (!file.open(TQFile::ReadOnly | TQFile::Text)) {
            TQMessageBox::warning(this, tr("Application"),
                              tr("Cannot read file %1:\n%2.")
                              .arg(fileName)
                              .arg(file.errorString()));
            return;
      }

      TQTextStream in(&file);
      TQApplication::setOverrideCursor(TQt::WaitCursor);
      textEdit->setPlainText(in.readAll());
      TQApplication::restoreOverrideCursor();

      setCurrentFile(fileName);
      statusBar()->showMessage(tr("File loaded"), 2000);
}

bool %{APPNAME}::saveFile(const TQString &fileName)
{
      TQFile file(fileName);
      if (!file.open(TQFile::WriteOnly | TQFile::Text)) {
            TQMessageBox::warning(this, tr("Application"),
                              tr("Cannot write file %1:\n%2.")
                              .arg(fileName)
                              .arg(file.errorString()));
            return false;
      }

      TQTextStream out(&file);
      TQApplication::setOverrideCursor(TQt::WaitCursor);
      out << textEdit->toPlainText();
      TQApplication::restoreOverrideCursor();

      setCurrentFile(fileName);
      statusBar()->showMessage(tr("File saved"), 2000);
      return true;
}

void %{APPNAME}::setCurrentFile(const TQString &fileName)
{
      curFile = fileName;
      textEdit->document()->setModified(false);
      setWindowModified(false);

      TQString shownName;
      if (curFile.isEmpty())
            shownName = "untitled.txt";
      else
            shownName = strippedName(curFile);

      setWindowTitle(tr("%1[*] - %2").arg(shownName).arg(tr("Application")));
}

TQString %{APPNAME}::strippedName(const TQString &fullFileName)
{
      return TQFileInfo(fullFileName).fileName();
}

%{APPNAME}::~%{APPNAME}()
{

}

