#include <tqwidget.h>
#include <tqcheckbox.h>
#include <tqlabel.h>
#include <tqsignalmapper.h>
#include <tqpushbutton.h>
#include <tqpe/resource.h>

#include "%{APPNAMELC}.h"

%{APPNAME}::%{APPNAME}(TQWidget* par, WFlags fl )
	: TQHBox(par, "name", fl )
{
	TQCheckBox *box1 = new TQCheckBox(tr("Alt"),this);
	connect(box1,TQT_SIGNAL(toggled(bool)),
			this,TQT_SLOT(slotAlt(bool)));
	m_alt = box1;
	box1 = new TQCheckBox(tr("Shift"),this );
	connect(box1,TQT_SIGNAL(toggled(bool)),
			this,TQT_SLOT(slotShift(bool)));
	m_shi = box1;
	box1 = new TQCheckBox(tr("Ctrl","Control Shortcut on keyboard"),this );
	connect(box1,TQT_SIGNAL(toggled(bool)),
			this,TQT_SLOT(slotCtrl(bool)));
	m_ctrl = box1;
			
	TQSignalMapper *map = new TQSignalMapper(this);
	TQPushButton *btn = new TQPushButton("a",this);
	map->setMapping(btn,0);
	connect(btn,TQT_SIGNAL(clicked()),map,TQT_SLOT(map()));
	
	btn = new TQPushButton("b",this);
	map->setMapping(btn,1);
	connect(btn,TQT_SIGNAL(clicked()),map,TQT_SLOT(map()));
	
	btn = new TQPushButton("c",this);
	map->setMapping(btn,2);
	connect(btn,TQT_SIGNAL(clicked()),map,TQT_SLOT(map()));
	
	connect(map,TQT_SIGNAL(mapped(int)),
			this,TQT_SLOT(slotKey(int)));
	resetState();
}

%{APPNAME}::~%{APPNAME}(){
}

void %{APPNAME}::resetState(){
	m_state = 0;
	m_shi->setChecked(false);
	m_ctrl->setChecked(false);
	m_alt->setChecked(false);
}

void %{APPNAME}::slotKey(int _ke){	
	int ke = _ke + 0x61; // 0 + 65 = 0x41 == A
	if(m_state & ShiftButton )	
		ke -= 0x20;
	
	/*
	 *  Send the key
	 * ke is the unicode
	 * _ke + 0x41 is the keycode
	 *  m_state Normally the state 
	 * down/up
	 * auto repeat
	 */
	emit key(ke, _ke +0x41,m_state,true,false);
	emit key(ke, _ke + 0x41,m_state,false,false);
}

void %{APPNAME}::slotShift(bool b){
	if(b)
		m_state |= ShiftButton;
	else
		m_state &= ~ShiftButton;	
}

void %{APPNAME}::slotAlt(bool b){
	if(b)
		m_state |= AltButton;
	else
		m_state &=  ~AltButton;
}

void %{APPNAME}::slotCtrl(bool b){
	if(b)
		m_state |= ControlButton;
	else
		m_state &= ~ControlButton;
}



%{APPNAME}Impl::%{APPNAME}Impl()
    : m_pickboard(0), m_icn(0)
{
}

%{APPNAME}Impl::~%{APPNAME}Impl()
{
    delete m_pickboard;
    delete m_icn;
}

TQWidget *%{APPNAME}Impl::inputMethod( TQWidget *parent, TQt::WFlags f )
{
    if ( !m_pickboard )
	m_pickboard = new %{APPNAME}( parent, f );
    return m_pickboard;
}

void %{APPNAME}Impl::resetState()
{
    if ( m_pickboard )
	m_pickboard->resetState();
}

TQPixmap *%{APPNAME}Impl::icon()
{
    if ( !m_icn )
	m_icn = new TQPixmap(Resource::loadPixmap("Tux"));
    return m_icn;
}

TQString %{APPNAME}Impl::name()
{
    return TQObject::tr("Example Input");
}

void %{APPNAME}Impl::onKeyPress( TQObject *receiver, const char *slot )
{
    if ( m_pickboard )
	TQObject::connect( m_pickboard, TQT_SIGNAL(key(ushort,ushort,ushort,bool,bool)), receiver, slot );
}

#ifndef TQT_NO_COMPONENT
TQRESULT %{APPNAME}Impl::queryInterface( const TQUuid &uuid, TQUnknownInterface **iface )
{
    *iface = 0;
    if ( uuid == IID_TQUnknown )
	*iface = this;
    else if ( uuid == IID_InputMethod )
	*iface = this;
    else
	return TQS_FALSE;

    if ( *iface )
	(*iface)->addRef();
    return TQS_OK;
}

TQ_EXPORT_INTERFACE()
{
    TQ_CREATE_INSTANCE( %{APPNAME}Impl )
}
#endif

