/* Copyright (C) 2003
	 Mickael Marchand <marchand@kde.org>

	 This program is free software; you can redistribute it and/or
	 modify it under the terms of the GNU General Public
	 License as published by the Free Software Foundation; either
	 version 2 of the License, or (at your option) any later version.

	 This program is distributed in the hope that it will be useful,
	 but WITHOUT ANY WARRANTY; without even the implied warranty of
	 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	 General Public License for more details.

	 You should have received a copy of the GNU General Public License
	 along with this program; see the file COPYING.  If not, write to
	 the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
	 Boston, MA 02110-1301, USA.
	 */
#ifndef __KDEVPART_SUBVERSION_H__
#define __KDEVPART_SUBVERSION_H__


#include <tqguardedptr.h>
#include <kdevplugin.h>
#include <kurl.h>
#include <tqpopupmenu.h>
#include <kdialogbase.h>
#include "kdevversioncontrol.h"

class subversionCore;
class subversionOptionsWidget;
class subversionProjectWidget;
class Context;
namespace SvnGlobal
{
class SvnInfoHolder;
};

class subversionPart : public KDevVersionControl
{
	Q_OBJECT
  

public:
		subversionPart(TQObject *parent, const char *name, const TQStringList &);
		virtual ~subversionPart();

		void setupActions();
		TQWidget* newProjectWidget( TQWidget* parent );
		void createNewProject( const TQString& dirname );
		bool fetchFromRepository();
		KDevVCSFileInfoProvider * fileInfoProvider() const;
		bool urlFocusedDocument( KURL &url );
		void restorePartialProjectSession(const TQDomElement* );
		void savePartialProjectSession(TQDomElement* );
		void setBaseURL(const KURL& url ) { base = url; }
		KURL baseURL() { return base; }
		virtual bool isValidDirectory( const TQString &dirPath ) const;
		KURL::List urls() { return m_urls; }
        subversionCore* svncore() { return m_impl; }

signals:
//		void finishedFetching( TQString destinationDir );

private slots:
		void contextMenu( TQPopupMenu *popup, const Context *context );
		void slotActionUpdate();
		void slotActionRevert();
		void slotActionCommit();
		void slotActionAdd();
		void slotActionDel();
		void slotActionDiffHead();
		void slotActionDiffLocal();
		void slotActionResolve();
		void slotUpdate();
		void slotRevert();
		void slotCommit();
		void slotAdd();
		void slotDel();
		void slotLog();
		void slotBlame();
		void slotDiffLocal();
		void slotDiffHead();
		void slotResolve();
		void slotSwitch();
		void slotCopy();
		void slotMerge();
		void slotProjectClosed();
		void slotProjectOpened();

private:
		TQGuardedPtr<subversionCore> m_impl;
		KURL::List m_urls;

		TDEAction *actionCommit,
		*actionDiffHead,
		*actionDiffLocal,
		*actionAdd,
		*actionLog,
		*actionBlame,
		*actionRemove,
		*actionUpdate,
		//*actionAddToIgnoreList,
		//*actionRemoveFromIgnoreList,
		*actionRevert,
		*actionResolve,
		*actionSwitch,
		*actionCopy,
		*actionMerge;

		TQGuardedPtr<subversionProjectWidget> m_projWidget;
		KURL base;

public:
        TQMap< KURL, SvnGlobal::SvnInfoHolder > m_prjInfoMap;

};


#endif
