/***************************************************************************
 *   Copyright (C) 2003 by Jens Dagerbo                                    *
 *   jens.dagerbo@swipnet.se                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef __KDEVPART_BOOKMARKS_H__
#define __KDEVPART_BOOKMARKS_H__


#include <tqguardedptr.h>
#include <tqvaluelist.h>
#include <tqdict.h>
#include <tqpair.h>

#include <tdeparts/part.h>
#include <kurl.h>

#include <kdevplugin.h>

class TQTimer;
class KDialogBase;
class BookmarksConfig;
class ConfigWidgetProxy;

struct EditorData
{
	KURL url;
	TQValueList< TQPair<int,TQString> > marks;
};

class BookmarksWidget;
class TQDomElement;

class BookmarksPart : public KDevPlugin
{
	Q_OBJECT
  

public:

	BookmarksPart(TQObject *parent, const char *name, const TQStringList &);
	~BookmarksPart();

	// reimplemented from KDevPlugin
	void restorePartialProjectSession( const TQDomElement * el );
	void savePartialProjectSession( TQDomElement * el );
	
	BookmarksConfig * config();

	TQStringList getContext( KURL const & url, unsigned int line, unsigned int context );
	
private slots:
	// connected to partcontroller
	void partAdded( KParts::Part * part );

	// connected to KTextEditor::MarkInterface
	void marksEvent();

	// connected to _marksChangeTimer	
	void marksChanged();
	
	// connected to KParts::ReadOnlyPart
	void reload();

	// connected to BookmarksWidget
	void removeAllBookmarksForURL( const KURL & );
	void removeBookmarkForURL( const KURL &, int );

	void insertConfigWidget( const KDialogBase * dlg, TQWidget * page, unsigned int );
	
private:
	bool setBookmarksForURL( KParts::ReadOnlyPart * );
	bool clearBookmarksForURL( KParts::ReadOnlyPart * );
	void setBookmarksForAllURLs();

	EditorData * storeBookmarksForURL( KParts::ReadOnlyPart * );
	void storeBookmarksForAllURLs();

	void updateContextStringForURL( KParts::ReadOnlyPart * );
	void updateContextStringForURL( KURL const & url );
	void updateContextStringForAll();

	TQStringList getContextFromStream( TQTextStream & istream, unsigned int line, unsigned int context );
	
	KParts::ReadOnlyPart * partForURL( KURL const & url );
	bool partIsSane( KParts::ReadOnlyPart * );

	TQGuardedPtr<BookmarksWidget> _widget;
	TQDict<EditorData> _editorMap;
	bool _settingMarks;	//	are we currently in the process of setting bookmarks?
	
	BookmarksConfig * _config;
	
	ConfigWidgetProxy * _configProxy;
	
	TQTimer * _marksChangeTimer;
	TQValueList<KParts::ReadOnlyPart*> _dirtyParts;
};


#endif

// kate: space-indent off; indent-width 4; tab-width 4; show-tabs off;
