/***************************************************************************
*   Copyright (C) 2003 by Alexander Dymo                                  *
*   cloudtemple@mksat.net                                                 *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#include "kdevcustomimporter.h"

#include "settingsdialog.h"

#include <tqvaluestack.h>
#include <tqdir.h>

#include <kdebug.h>
#include <kgenericfactory.h>

K_EXPORT_COMPONENT_FACTORY( libkdevcustompcsimporter, KGenericFactory<KDevCustomImporter>( "kdevcustompcsimporter" ) )

KDevCustomImporter::KDevCustomImporter( TQObject* parent, const char* name, const TQStringList & // args
                                      )
		: KDevPCSImporter( parent, name )
{}


KDevCustomImporter::~KDevCustomImporter()
{}


TQString KDevCustomImporter::dbName() const
{
	return m_settings->dbName();
}

TQStringList KDevCustomImporter::fileList( const TQString& path )
{
	TQDir dir( path );
	if ( !dir.exists() )
		return TQStringList();
// 	TQStringList lst = dir.entryList( "*.h;*.H;*.hh;*.hxx;*.hpp;*.tlh" );
	TQStringList lst = dir.entryList( m_settings->filePattern() );
	TQStringList fileList;
	for ( TQStringList::Iterator it = lst.begin(); it != lst.end(); ++it )
	{
		fileList.push_back( dir.absPath() + "/" + ( *it ) );
	}
	return fileList;
}

TQStringList KDevCustomImporter::fileList()
{
	if ( !m_settings )
		return TQStringList();

	TQStringList lst = m_settings->dirs();
	TQStringList files;
	for ( TQStringList::Iterator it = lst.begin(); it != lst.end(); ++it )
	{
		if ( !m_settings->recursive() )
			files += fileList( *it );
		else
			processDir( *it, files );
	}

	return files;
}

TQStringList KDevCustomImporter::includePaths()
{
	if ( !m_settings )
		return TQStringList();

	return m_settings->dirs();
}

TQWidget* KDevCustomImporter::createSettingsPage( TQWidget* parent, const char* name )
{
	m_settings = new SettingsDialog( parent, name );
	return m_settings;
}

void KDevCustomImporter::processDir( const TQString path, TQStringList & files )
{
	TQValueStack<TQString> s;
	s.push( path );
	files += fileList( path );

	TQDir dir;
	do
	{
		dir.setPath( s.pop() );
		if (!dir.exists())
		    continue;
		kdDebug( 9015 ) << "Examining: " << dir.path() << endl;
		const TQFileInfoList *dirEntries = dir.entryInfoList();
		if ( !dirEntries ) continue;
		TQPtrListIterator<TQFileInfo> it( *dirEntries );
		for ( ; dirEntries && it.current(); ++it )
		{
			TQString fileName = it.current() ->fileName();
			if ( fileName == "." || fileName == ".." )
				continue;
			if ( it.current() ->isDir() )
			{
                                TQString tmpPath = it.current() ->absFilePath();
				kdDebug( 9015 ) << "Pushing: " << tmpPath << endl;
				s.push( tmpPath );
				files += fileList( tmpPath );
			}
		}
	}
	while ( !s.isEmpty() );
}

#include "kdevcustomimporter.moc" 
//kate: indent-mode csands; tab-width 4; space-indent off;
