
#include "kdevdriver.h"
#include "JavaLexer.hpp"
#include <unistd.h>
#include <tqfileinfo.h>

KDevDriver::KDevDriver( JavaSupportPart* javaSupport )
	: m_javaSupport( javaSupport )
{
}

JavaSupportPart* KDevDriver::javaSupport()
{
	return m_javaSupport;
}

void KDevDriver::setupProject()
{
	TQMap<TQString, bool> map;

	{
	TQStringList fileList = m_javaSupport->project()->allFiles();
	TQStringList::ConstIterator it = fileList.begin();
	while( it != fileList.end() ){
		TQFileInfo info( *it );
		++it;

		map.insert( info.dirPath(true), true );
	}
	}

	{
	TQMap<TQString, bool>::Iterator it = map.begin();
	while( it != map.end() ){
		addIncludePath( it.key() );
		++it;
	}
	}
}

void KDevDriver::setupLexer( JavaLexer* lexer )
{
	Driver::setupLexer( lexer );
}
