/***************************************************************************
*   Copyright (C) 2003 by Roberto Raggi                                   *
*   roberto@kdevelop.org                                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#include "kdevqtimporter.h"
#include "kdevqtimporter.moc"
#include "settingsdialog.h"

#include <kgenericfactory.h>

#include <tqlabel.h>
#include <tqdir.h>

K_EXPORT_COMPONENT_FACTORY( libkdevqtimporter, KGenericFactory<KDevQtImporter>( "kdevqtimporter" ) )

KDevQtImporter::KDevQtImporter( TQObject * parent, const char * name, const TQStringList& )
		: KDevPCSImporter( parent, name )
{}

KDevQtImporter::~KDevQtImporter()
{}

TQStringList KDevQtImporter::fileList()
{
	if ( !m_settings )
		return TQStringList();

	TQDir dir( m_settings->qtDir() );
	TQStringList lst = dir.entryList( "*.h" );
	TQStringList fileList;
	for ( TQStringList::Iterator it = lst.begin(); it != lst.end(); ++it )
	{
		if ( ( *it ).startsWith( "qconfig-" ) )
		{
			if ( ( *it ).endsWith( m_settings->configuration() + ".h" ) )
				fileList.prepend( dir.absPath() + "/" + ( *it ) );
		}
		else
		{
			fileList.push_back( dir.absPath() + "/" + ( *it ) );
		}
	}
	return fileList;
}

TQStringList KDevQtImporter::includePaths()
{
	if ( !m_settings )
		return TQStringList();

	TQStringList includePaths;
	includePaths.push_back( m_settings->qtDir() );
	includePaths.push_back( m_settings->qtDir() + "/private" );
	includePaths.push_back( m_settings->qtDir() + "/default" );

	/// @todo add mkspec
	return includePaths;
}

TQWidget * KDevQtImporter::createSettingsPage( TQWidget * parent, const char * name )
{
	m_settings = new SettingsDialog( parent, name );
	return m_settings;
}

//kate: indent-mode csands; tab-width 4; space-indent off;
