/***************************************************************************
 *   Copyright (C) 2007 by Andreas Pakulat                                 *
 *   apaku@gmx.de                                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "selectnewfilesdialog.h"

#include <tqlistview.h>
#include <tdelistview.h>
#include <tqheader.h>
#include <tqstringlist.h>
#include <tdelocale.h>
#include <kdebug.h>
#include "selectnewfilesdialogbase.h"

SelectNewFilesDialog::SelectNewFilesDialog( TQStringList paths, TQWidget* parent, const char* name )
        : KDialogBase( parent, name, true, i18n("Add newly created files to project"), KDialogBase::Ok|KDialogBase::Cancel )
{
    m_widget = new SelectNewFilesDialogBase(this);
    m_widget->fileView->header()->hide();
    m_widget->fileView->addColumn(i18n("Path") );
    for( TQStringList::const_iterator it = paths.begin(); it != paths.end(); ++it)
    {
        addPath(0, *it);
    }
    setMainWidget( m_widget );
    resize( 300,400 );
}

SelectNewFilesDialog::~SelectNewFilesDialog()
{}

void SelectNewFilesDialog::slotCancel()
{
    excludePaths.clear();
    includePaths.clear();
    KDialogBase::slotCancel();
}

void SelectNewFilesDialog::checkItem( TQCheckListItem* item, const TQString& curpath )
{
    if( !item )
        return;

    TQString path = curpath + item->text();
    if( item->state() != TQCheckListItem::Off )
        includePaths << path;
    else
        excludePaths << path;
    if( item->firstChild() )
    {
        checkItem( static_cast<TQCheckListItem*>(item->firstChild()), path+"/" );
    }
    if( item->nextSibling() )
    {
        checkItem( static_cast<TQCheckListItem*>(item->nextSibling()), curpath );
    }
}

void SelectNewFilesDialog::slotOk()
{
    TQCheckListItem* item = static_cast<TQCheckListItem*> (m_widget->fileView->firstChild());
    checkItem( item, "" );
    kdDebug(9025) << "Inc List:" << includePaths << endl;
    kdDebug(9025) << "Exc List:" << excludePaths << endl;
    KDialogBase::slotOk();
}

void SelectNewFilesDialog::addPath( TQCheckListItem* item, const TQString& path )
{
    if( path.isEmpty() )
        return;

    TQStringList parts = TQStringList::split("/", path );
    TQString name = parts.first();
    parts.pop_front();
    TQCheckListItem* i = createItem( item, name, parts.size() );
    i->setState( TQCheckListItem::On );
    i->setTristate( true );
    addPath(i, parts.join("/") );
}

TQCheckListItem* SelectNewFilesDialog::createItem( TQCheckListItem* parent, const TQString& name, int count )
{
    TQCheckListItem::Type t = TQCheckListItem::CheckBox;
    if( count > 0 )
        t = TQCheckListItem::CheckBoxController;

    if( parent == 0 )
    {
        TQListViewItem* item = m_widget->fileView->firstChild();
        while( item )
        {
            if( item->text( 0 ) == name )
                return static_cast<TQCheckListItem*>(item);
            item = item->nextSibling();
        }
        return new TQCheckListItem( m_widget->fileView, name, t );
    }else
    {
        TQListViewItem* item = parent->firstChild();
        while( item )
        {
            if( item->text( 0 ) == name )
                return static_cast<TQCheckListItem*>(item);
            item = item->nextSibling();
        }
        return new TQCheckListItem( parent, name, t );
    }
}

TQStringList SelectNewFilesDialog::excludedPaths() const
{
    return excludePaths;
}

TQStringList SelectNewFilesDialog::includedPaths() const
{
    return includePaths;
}

#include "selectnewfilesdialog.moc"

// kate: space-indent on; indent-width 4; tab-width 4; replace-tabs on
