/*
  TDevelop Autotools Support
  Copyright (c) 2002 by Victor Roeder <victor_roeder@gmx.de>
  Copyright (c) 2005 by Matt Rogers <mattr@kde.org>

***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************
*/

#ifndef AUTOSUBPROJECTVIEW_H
#define AUTOSUBPROJECTVIEW_H

#include <tqwidget.h>
#include "autoprojectviewbase.h"


class TDEAction;
class AutoToolsAction;
class AutoProjectWidget;
class AutoProjectPart;
class TargetItem;
class SubprojectItem;
class TDEListViewItem;
class TDEListView;

namespace AutoProjectPrivate
{
	bool isHeader( const TQString& fileName );
}


//with protected inheritance gcc 3.2.3 complains in autoprojectwidget.cpp, line 116
//that it cannot access the base class TQObject (for the connect() call),
//so in order to be able to compile this file I made the inheritance public again, Alex
class AutoSubprojectView : public AutoProjectViewBase
{
	Q_OBJECT
  

public:
	AutoSubprojectView( AutoProjectWidget* widget, AutoProjectPart* part, TQWidget *parent, const char *name );
	virtual ~AutoSubprojectView();

public:
	void loadMakefileams ( const TQString& dir );

	void parse( SubprojectItem *item );
	TDEListView* listView() const
	{
		return m_listView;
	}

	TargetItem *findNoinstHeaders( SubprojectItem *item );

signals:
	void selectionChanged( TQListViewItem* );

protected:
	void initActions ();

	void parseKDEDOCS( SubprojectItem *item,
	                   const TQString &lhs, const TQString &rhs );
	void parseKDEICON( SubprojectItem *item,
	                   const TQString &lhs, const TQString &rhs );
	void parsePrimary( SubprojectItem *item,
	                   const TQString &lhs, const TQString &rhs );
	void parsePrefix( SubprojectItem *item,
	                  const TQString &lhs, const TQString &rhs );
	void parseSUBDIRS( SubprojectItem *item,
	                   const TQString &lhs, const TQString &rhs );
	virtual void focusOutEvent( TQFocusEvent *e );
	void expandCollapse( TQListViewItem * item, bool expand );
	void expandCollapseFirst( TQListViewItem * item, bool expand );

private:
	AutoProjectWidget* m_widget;
	AutoProjectPart* m_part;
	TQStringList headers;

	bool m_kdeMode;

	AutoToolsAction* addApplicationAction;
	AutoToolsAction* subProjectOptionsAction;
	AutoToolsAction* addSubprojectAction;
	TDEAction* addExistingSubprojectAction;
	AutoToolsAction* addTargetAction;
	AutoToolsAction* addServiceAction;
	AutoToolsAction* buildSubprojectAction;
	TDEAction* removeSubprojectAction;
	TDEAction* cleanSubprojectAction;
	TDEAction* forceReeditSubprojectAction;
	TDEAction* installSubprojectAction;
	TDEAction* installSuSubprojectAction;
	TDEAction* otherAction;
	TDEAction* expandAction;
	TDEAction* collapseAction;

	TQStringList m_commandList;
	TQValueList<int> m_commandTypeList;

private slots:
	void slotContextMenu( TDEListView *, TQListViewItem *item, const TQPoint &p );
	//void slotSubprojectExecuted(TQListViewItem* item);
	void slotSelectionChanged( TQListViewItem* item );
	void slotAddApplication();
	void slotSubprojectOptions();
	void slotAddSubproject();
	void slotAddExistingSubproject();
	void slotAddTarget();
	void slotAddService();
	void slotBuildSubproject();
	void slotRemoveSubproject();
	void slotForceReeditSubproject();
	void slotInstallSubproject();
	void slotInstallSuSubproject();
	void slotCleanSubproject();
	void slotManageBuildCommands();
	void slotCustomBuildCommand( int );
	void slotExpandTree();
	void slotCollapseTree();
};

#endif

// kate: indent-mode csands; tab-width 4;
