/***************************************************************************
 *   Copyright (C) 2004 by Alexander Dymo <adymo@kdevelop.org>             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef PROFILEEDITOR_H
#define PROFILEEDITOR_H

#include <profileengine.h>

#include "profileeditorbase.h"

class TQListBoxItem;
class TQListViewItem;
class TDEListViewItem;

class ProfileEditor : public ProfileEditorBase {
    Q_OBJECT
  
public:
    ProfileEditor(TQWidget *parent = 0, const char *name = 0);
    
public slots:
    virtual void removeProperty();
    virtual void addProperty();
    virtual void removeProfile();
    virtual void addProfile();
    virtual void propertyExecuted(TQListBoxItem *item);
    virtual void profileExecuted(TQListViewItem *item);
    
    virtual void delDisabled();
    virtual void addDisabled();
    virtual void delEnabled();
    virtual void addEnabled();

    virtual void accept();

protected:
    void refresh();
    void refreshPropertyCombo();
    void refreshAvailableList();
    
    void fillPropertyList(Profile *profile);
    void fillEDLists(Profile *profile);
    void fillPluginsList(Profile *profile);
    
    Profile *currentProfile();
    
private:
    ProfileEngine engine;

    TDEListViewItem *allCore;
    TDEListViewItem *allGlobal;
    TDEListViewItem *allProject;    
};

#endif
